/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractThrownPotion;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.Level;

public abstract class ThrowablePotionItem
extends PotionItem
implements ProjectileItem {
    public static float PROJECTILE_SHOOT_POWER = 0.5f;

    public ThrowablePotionItem(Item.Properties p_43301_) {
        super(p_43301_);
    }

    @Override
    public InteractionResult use(Level p_43303_, Player p_43304_, InteractionHand p_43305_) {
        ItemStack itemstack = p_43304_.getItemInHand(p_43305_);
        if (p_43303_ instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)p_43303_;
            Projectile.spawnProjectileFromRotation(this::createPotion, serverlevel, itemstack, p_43304_, -20.0f, PROJECTILE_SHOOT_POWER, 1.0f);
        }
        p_43304_.awardStat(Stats.ITEM_USED.get(this));
        itemstack.consume(1, p_43304_);
        return InteractionResult.SUCCESS;
    }

    protected abstract AbstractThrownPotion createPotion(ServerLevel var1, LivingEntity var2, ItemStack var3);

    protected abstract AbstractThrownPotion createPotion(Level var1, Position var2, ItemStack var3);

    @Override
    public Projectile asProjectile(Level p_338465_, Position p_338661_, ItemStack p_338506_, Direction p_338517_) {
        return this.createPotion(p_338465_, p_338661_, p_338506_);
    }

    @Override
    public ProjectileItem.DispenseConfig createDispenseConfig() {
        return ProjectileItem.DispenseConfig.builder().uncertainty(ProjectileItem.DispenseConfig.DEFAULT.uncertainty() * 0.5f).power(ProjectileItem.DispenseConfig.DEFAULT.power() * 1.25f).build();
    }
}

