/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ScaffoldingBlock;
import net.minecraft.world.level.block.state.BlockState;

public class ScaffoldingBlockItem
extends BlockItem {
    public ScaffoldingBlockItem(Block p_43060_, Item.Properties p_43061_) {
        super(p_43060_, p_43061_);
    }

    @Override
    @Nullable
    public BlockPlaceContext updatePlacementContext(BlockPlaceContext p_43063_) {
        Block block;
        BlockPos blockpos = p_43063_.getClickedPos();
        Level level = p_43063_.getLevel();
        BlockState blockstate = level.getBlockState(blockpos);
        if (!blockstate.is(block = this.getBlock())) {
            return ScaffoldingBlock.getDistance(level, blockpos) == 7 ? null : p_43063_;
        }
        Direction direction = p_43063_.isSecondaryUseActive() ? (p_43063_.isInside() ? p_43063_.getClickedFace().getOpposite() : p_43063_.getClickedFace()) : (p_43063_.getClickedFace() == Direction.UP ? p_43063_.getHorizontalDirection() : Direction.UP);
        int i = 0;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = blockpos.mutable().move(direction);
        while (i < 7) {
            if (!level.isClientSide && !level.isInWorldBounds(blockpos$mutableblockpos)) {
                Player player = p_43063_.getPlayer();
                int j = level.getMaxY();
                if (!(player instanceof ServerPlayer) || blockpos$mutableblockpos.getY() <= j) break;
                ((ServerPlayer)player).sendSystemMessage(Component.translatable("build.tooHigh", j).withStyle(ChatFormatting.RED), true);
                break;
            }
            blockstate = level.getBlockState(blockpos$mutableblockpos);
            if (!blockstate.is(this.getBlock())) {
                if (!blockstate.canBeReplaced(p_43063_)) break;
                return BlockPlaceContext.at(p_43063_, blockpos$mutableblockpos, direction);
            }
            blockpos$mutableblockpos.move(direction);
            if (!direction.getAxis().isHorizontal()) continue;
            ++i;
        }
        return null;
    }

    @Override
    protected boolean mustSurvive() {
        return false;
    }
}

