/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class MaceItem
extends Item {
    private static final int DEFAULT_ATTACK_DAMAGE = 5;
    private static final float DEFAULT_ATTACK_SPEED = -3.4f;
    public static final float SMASH_ATTACK_FALL_THRESHOLD = 1.5f;
    private static final float SMASH_ATTACK_HEAVY_THRESHOLD = 5.0f;
    public static final float SMASH_ATTACK_KNOCKBACK_RADIUS = 3.5f;
    private static final float SMASH_ATTACK_KNOCKBACK_POWER = 0.7f;

    public MaceItem(Item.Properties p_333796_) {
        super(p_333796_);
    }

    public static ItemAttributeModifiers createAttributes() {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 5.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, -3.4f, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public static Tool createToolProperties() {
        return new Tool(List.of(), 1.0f, 2, false);
    }

    @Override
    public void hurtEnemy(ItemStack p_334046_, LivingEntity p_333712_, LivingEntity p_333812_) {
        if (MaceItem.canSmashAttack(p_333812_)) {
            ServerLevel serverlevel = (ServerLevel)p_333812_.level();
            p_333812_.setDeltaMovement(p_333812_.getDeltaMovement().with(Direction.Axis.Y, 0.01f));
            if (p_333812_ instanceof ServerPlayer) {
                ServerPlayer serverplayer = (ServerPlayer)p_333812_;
                serverplayer.currentImpulseImpactPos = this.calculateImpactPosition(serverplayer);
                serverplayer.setIgnoreFallDamageFromCurrentImpulse(true);
                serverplayer.connection.send(new ClientboundSetEntityMotionPacket(serverplayer));
            }
            if (p_333712_.onGround()) {
                if (p_333812_ instanceof ServerPlayer) {
                    ServerPlayer serverplayer1 = (ServerPlayer)p_333812_;
                    serverplayer1.setSpawnExtraParticlesOnFall(true);
                }
                SoundEvent soundevent = p_333812_.fallDistance > 5.0 ? SoundEvents.MACE_SMASH_GROUND_HEAVY : SoundEvents.MACE_SMASH_GROUND;
                serverlevel.playSound(null, p_333812_.getX(), p_333812_.getY(), p_333812_.getZ(), soundevent, p_333812_.getSoundSource(), 1.0f, 1.0f);
            } else {
                serverlevel.playSound(null, p_333812_.getX(), p_333812_.getY(), p_333812_.getZ(), SoundEvents.MACE_SMASH_AIR, p_333812_.getSoundSource(), 1.0f, 1.0f);
            }
            MaceItem.knockback(serverlevel, p_333812_, p_333712_);
        }
    }

    private Vec3 calculateImpactPosition(ServerPlayer p_365384_) {
        return p_365384_.isIgnoringFallDamageFromCurrentImpulse() && p_365384_.currentImpulseImpactPos != null && p_365384_.currentImpulseImpactPos.y <= p_365384_.position().y ? p_365384_.currentImpulseImpactPos : p_365384_.position();
    }

    @Override
    public void postHurtEnemy(ItemStack p_345716_, LivingEntity p_345817_, LivingEntity p_346003_) {
        if (MaceItem.canSmashAttack(p_346003_)) {
            p_346003_.resetFallDistance();
        }
    }

    @Override
    public float getAttackDamageBonus(Entity p_344900_, float p_335575_, DamageSource p_344972_) {
        Entity entity = p_344972_.getDirectEntity();
        if (entity instanceof LivingEntity) {
            float f;
            LivingEntity livingentity = (LivingEntity)entity;
            if (!MaceItem.canSmashAttack(livingentity)) {
                return 0.0f;
            }
            double d3 = 3.0;
            double d0 = 8.0;
            double d1 = livingentity.fallDistance;
            double d2 = d1 <= 3.0 ? 4.0 * d1 : (d1 <= 8.0 ? 12.0 + 2.0 * (d1 - 3.0) : 22.0 + d1 - 8.0);
            Level level = livingentity.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)level;
                f = (float)(d2 + (double)EnchantmentHelper.modifyFallBasedDamage(serverlevel, livingentity.getWeaponItem(), p_344900_, p_344972_, 0.0f) * d1);
            } else {
                f = (float)d2;
            }
            return f;
        }
        return 0.0f;
    }

    private static void knockback(Level p_335716_, Entity p_335810_, Entity p_360964_) {
        p_335716_.levelEvent(2013, p_360964_.getOnPos(), 750);
        p_335716_.getEntitiesOfClass(LivingEntity.class, p_360964_.getBoundingBox().inflate(3.5), MaceItem.knockbackPredicate(p_335810_, p_360964_)).forEach(p_347296_ -> {
            Vec3 vec3 = p_347296_.position().subtract(p_360964_.position());
            double d0 = MaceItem.getKnockbackPower(p_335810_, p_347296_, vec3);
            Vec3 vec31 = vec3.normalize().scale(d0);
            if (d0 > 0.0) {
                p_347296_.push(vec31.x, 0.7f, vec31.z);
                if (p_347296_ instanceof ServerPlayer) {
                    ServerPlayer serverplayer = (ServerPlayer)p_347296_;
                    serverplayer.connection.send(new ClientboundSetEntityMotionPacket(serverplayer));
                }
            }
        });
    }

    private static Predicate<LivingEntity> knockbackPredicate(Entity p_338698_, Entity p_361210_) {
        return arg_0 -> MaceItem.lambda$knockbackPredicate$1(p_338698_, p_361210_, arg_0);
    }

    private static double getKnockbackPower(Entity p_364341_, LivingEntity p_338630_, Vec3 p_338866_) {
        return (3.5 - p_338866_.length()) * (double)0.7f * (double)(p_364341_.fallDistance > 5.0 ? 2 : 1) * (1.0 - p_338630_.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
    }

    public static boolean canSmashAttack(LivingEntity p_344836_) {
        return p_344836_.fallDistance > 1.5 && !p_344836_.isFallFlying();
    }

    @Override
    @Nullable
    public DamageSource getDamageSource(LivingEntity p_372868_) {
        return MaceItem.canSmashAttack(p_372868_) ? p_372868_.damageSources().mace(p_372868_) : super.getDamageSource(p_372868_);
    }

    /*
     * Unable to fully structure code
     */
    private static /* synthetic */ boolean lambda$knockbackPredicate$1(Entity p_338698_, Entity p_361210_, LivingEntity p_393278_) {
        flag = p_393278_.isSpectator() == false;
        flag1 = p_393278_ != p_338698_ && p_393278_ != p_361210_;
        v0 = flag2 = p_338698_.isAlliedTo(p_393278_) == false;
        if (!(p_393278_ instanceof TamableAnimal)) ** GOTO lbl-1000
        tamableanimal = (TamableAnimal)p_393278_;
        if (!(p_361210_ instanceof LivingEntity)) ** GOTO lbl-1000
        livingentity = (LivingEntity)p_361210_;
        if (tamableanimal.isTame() && tamableanimal.isOwnedBy(livingentity)) {
            v1 = true;
        } else lbl-1000:
        // 3 sources

        {
            v1 = false;
        }
        flag3 = v1 == false;
        flag4 = (p_393278_ instanceof ArmorStand != false && (armorstand = (ArmorStand)p_393278_).isMarker() != false) == false;
        flag5 = p_361210_.distanceToSqr(p_393278_) <= Math.pow(3.5, 2.0);
        return flag != false && flag1 != false && flag2 != false && flag3 != false && flag4 != false && flag5 != false;
    }
}

