/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.variant;

import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.util.RandomSource;

public interface PriorityProvider<Context, Condition extends SelectorCondition<Context>> {
    public List<Selector<Context, Condition>> selectors();

    public static <C, T> Stream<T> select(Stream<T> p_399981_, Function<T, PriorityProvider<C, ?>> p_399700_, C p_400086_) {
        ArrayList list = new ArrayList();
        p_399981_.forEach(p_399951_ -> {
            PriorityProvider priorityprovider = (PriorityProvider)p_399700_.apply(p_399951_);
            for (Selector selector : priorityprovider.selectors()) {
                list.add(new UnpackedEntry(p_399951_, selector.priority(), (SelectorCondition)DataFixUtils.orElseGet(selector.condition(), SelectorCondition::alwaysTrue)));
            }
        });
        list.sort(UnpackedEntry.HIGHEST_PRIORITY_FIRST);
        Iterator iterator = list.iterator();
        int i = Integer.MIN_VALUE;
        while (iterator.hasNext()) {
            UnpackedEntry unpackedentry = (UnpackedEntry)iterator.next();
            if (unpackedentry.priority < i) {
                iterator.remove();
                continue;
            }
            if (unpackedentry.condition.test(p_400086_)) {
                i = unpackedentry.priority;
                continue;
            }
            iterator.remove();
        }
        return list.stream().map(UnpackedEntry::entry);
    }

    public static <C, T> Optional<T> pick(Stream<T> p_399512_, Function<T, PriorityProvider<C, ?>> p_399827_, RandomSource p_399605_, C p_400048_) {
        List<T> list = PriorityProvider.select(p_399512_, p_399827_, p_400048_).toList();
        return Util.getRandomSafe(list, p_399605_);
    }

    public static <Context, Condition extends SelectorCondition<Context>> List<Selector<Context, Condition>> single(Condition p_400158_, int p_399749_) {
        return List.of(new Selector(p_400158_, p_399749_));
    }

    public static <Context, Condition extends SelectorCondition<Context>> List<Selector<Context, Condition>> alwaysTrue(int p_400309_) {
        return List.of(new Selector(Optional.empty(), p_400309_));
    }

    public record UnpackedEntry<C, T>(T entry, int priority, SelectorCondition<C> condition) {
        public static final Comparator<UnpackedEntry<?, ?>> HIGHEST_PRIORITY_FIRST = Comparator.comparingInt(UnpackedEntry::priority).reversed();
    }

    @FunctionalInterface
    public static interface SelectorCondition<C>
    extends Predicate<C> {
        public static <C> SelectorCondition<C> alwaysTrue() {
            return p_400277_ -> true;
        }
    }

    public record Selector<Context, Condition extends SelectorCondition<Context>>(Optional<Condition> condition, int priority) {
        public Selector(Condition p_400069_, int p_400304_) {
            this(Optional.of(p_400069_), p_400304_);
        }

        public Selector(int p_399666_) {
            this(Optional.empty(), p_399666_);
        }

        public static <Context, Condition extends SelectorCondition<Context>> Codec<Selector<Context, Condition>> codec(Codec<Condition> p_399682_) {
            return RecordCodecBuilder.create(p_399853_ -> p_399853_.group((App)p_399682_.optionalFieldOf("condition").forGetter(Selector::condition), (App)Codec.INT.fieldOf("priority").forGetter(Selector::priority)).apply((Applicative)p_399853_, Selector::new));
        }
    }
}

