/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractThrownPotion;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;

public class ThrownSplashPotion
extends AbstractThrownPotion {
    public ThrownSplashPotion(EntityType<? extends ThrownSplashPotion> p_400190_, Level p_399722_) {
        super((EntityType<? extends AbstractThrownPotion>)p_400190_, p_399722_);
    }

    public ThrownSplashPotion(Level p_399777_, LivingEntity p_400264_, ItemStack p_400186_) {
        super(EntityType.SPLASH_POTION, p_399777_, p_400264_, p_400186_);
    }

    public ThrownSplashPotion(Level p_400144_, double p_400061_, double p_400032_, double p_399549_, ItemStack p_400218_) {
        super(EntityType.SPLASH_POTION, p_400144_, p_400061_, p_400032_, p_399549_, p_400218_);
    }

    @Override
    protected Item getDefaultItem() {
        return Items.SPLASH_POTION;
    }

    @Override
    public void onHitAsPotion(ServerLevel p_399483_, ItemStack p_400156_, HitResult p_422131_) {
        PotionContents potioncontents = p_400156_.getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY);
        float f = p_400156_.getOrDefault(DataComponents.POTION_DURATION_SCALE, Float.valueOf(1.0f)).floatValue();
        Iterable<MobEffectInstance> iterable = potioncontents.getAllEffects();
        AABB aabb = this.getBoundingBox().move(p_422131_.getLocation().subtract(this.position()));
        AABB aabb1 = aabb.inflate(4.0, 2.0, 4.0);
        List list = this.level().getEntitiesOfClass(LivingEntity.class, aabb1);
        float f1 = ProjectileUtil.computeMargin(this);
        if (!list.isEmpty()) {
            Entity entity = this.getEffectSource();
            for (LivingEntity livingentity : list) {
                double d0;
                if (!livingentity.isAffectedByPotions() || !((d0 = aabb.distanceToSqr(livingentity.getBoundingBox().inflate(f1))) < 16.0)) continue;
                double d1 = 1.0 - Math.sqrt(d0) / 4.0;
                for (MobEffectInstance mobeffectinstance : iterable) {
                    Holder<MobEffect> holder = mobeffectinstance.getEffect();
                    if (holder.value().isInstantenous()) {
                        holder.value().applyInstantenousEffect(p_399483_, this, this.getOwner(), livingentity, mobeffectinstance.getAmplifier(), d1);
                        continue;
                    }
                    int i = mobeffectinstance.mapDuration(p_400103_ -> (int)(d1 * (double)p_400103_ * (double)f + 0.5));
                    MobEffectInstance mobeffectinstance1 = new MobEffectInstance(holder, i, mobeffectinstance.getAmplifier(), mobeffectinstance.isAmbient(), mobeffectinstance.isVisible());
                    if (mobeffectinstance1.endsWithin(20)) continue;
                    livingentity.addEffect(mobeffectinstance1, entity);
                }
            }
        }
    }
}

