/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;

public class ThrownLingeringPotion
extends AbstractThrownPotion {
    public ThrownLingeringPotion(EntityType<? extends ThrownLingeringPotion> p_400031_, Level p_400145_) {
        super((EntityType<? extends AbstractThrownPotion>)p_400031_, p_400145_);
    }

    public ThrownLingeringPotion(Level p_400111_, LivingEntity p_400085_, ItemStack p_399851_) {
        super(EntityType.LINGERING_POTION, p_400111_, p_400085_, p_399851_);
    }

    public ThrownLingeringPotion(Level p_399495_, double p_399947_, double p_400038_, double p_400027_, ItemStack p_399471_) {
        super(EntityType.LINGERING_POTION, p_399495_, p_399947_, p_400038_, p_400027_, p_399471_);
    }

    @Override
    protected Item getDefaultItem() {
        return Items.LINGERING_POTION;
    }

    @Override
    public void onHitAsPotion(ServerLevel p_399902_, ItemStack p_400168_, HitResult p_421887_) {
        AreaEffectCloud areaeffectcloud = new AreaEffectCloud(this.level(), this.getX(), this.getY(), this.getZ());
        Entity entity = this.getOwner();
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            areaeffectcloud.setOwner(livingentity);
        }
        areaeffectcloud.setRadius(3.0f);
        areaeffectcloud.setRadiusOnUse(-0.5f);
        areaeffectcloud.setDuration(600);
        areaeffectcloud.setWaitTime(10);
        areaeffectcloud.setRadiusPerTick(-areaeffectcloud.getRadius() / (float)areaeffectcloud.getDuration());
        areaeffectcloud.applyComponentsFromItemStack(p_400168_);
        p_399902_.addFreshEntity(areaeffectcloud);
    }
}

