/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public abstract class AbstractThrownPotion
extends ThrowableItemProjectile {
    public static final double SPLASH_RANGE = 4.0;
    protected static final double SPLASH_RANGE_SQ = 16.0;
    public static final Predicate<LivingEntity> WATER_SENSITIVE_OR_ON_FIRE = p_427132_ -> p_427132_.isSensitiveToWater() || p_427132_.isOnFire();

    public AbstractThrownPotion(EntityType<? extends AbstractThrownPotion> p_399901_, Level p_400202_) {
        super((EntityType<? extends ThrowableItemProjectile>)p_399901_, p_400202_);
    }

    public AbstractThrownPotion(EntityType<? extends AbstractThrownPotion> p_399755_, Level p_399661_, LivingEntity p_399813_, ItemStack p_400023_) {
        super(p_399755_, p_399813_, p_399661_, p_400023_);
    }

    public AbstractThrownPotion(EntityType<? extends AbstractThrownPotion> p_399500_, Level p_399980_, double p_399961_, double p_399539_, double p_399938_, ItemStack p_399737_) {
        super(p_399500_, p_399961_, p_399539_, p_399938_, p_399980_, p_399737_);
    }

    @Override
    protected double getDefaultGravity() {
        return 0.05;
    }

    @Override
    protected void onHitBlock(BlockHitResult p_399776_) {
        super.onHitBlock(p_399776_);
        if (!this.level().isClientSide) {
            ItemStack itemstack = this.getItem();
            Direction direction = p_399776_.getDirection();
            BlockPos blockpos = p_399776_.getBlockPos();
            BlockPos blockpos1 = blockpos.relative(direction);
            PotionContents potioncontents = itemstack.getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY);
            if (potioncontents.is(Potions.WATER)) {
                this.dowseFire(blockpos1);
                this.dowseFire(blockpos1.relative(direction.getOpposite()));
                for (Direction direction1 : Direction.Plane.HORIZONTAL) {
                    this.dowseFire(blockpos1.relative(direction1));
                }
            }
        }
    }

    @Override
    protected void onHit(HitResult p_399893_) {
        super.onHit(p_399893_);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            ItemStack itemstack = this.getItem();
            PotionContents potioncontents = itemstack.getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY);
            if (potioncontents.is(Potions.WATER)) {
                this.onHitAsWater(serverlevel);
            } else if (potioncontents.hasEffects()) {
                this.onHitAsPotion(serverlevel, itemstack, p_399893_);
            }
            int i = potioncontents.potion().isPresent() && potioncontents.potion().get().value().hasInstantEffects() ? 2007 : 2002;
            serverlevel.levelEvent(i, this.blockPosition(), potioncontents.getColor());
            this.discard();
        }
    }

    private void onHitAsWater(ServerLevel p_399548_) {
        AABB aabb = this.getBoundingBox().inflate(4.0, 2.0, 4.0);
        for (LivingEntity livingentity : this.level().getEntitiesOfClass(LivingEntity.class, aabb, WATER_SENSITIVE_OR_ON_FIRE)) {
            double d0 = this.distanceToSqr(livingentity);
            if (!(d0 < 16.0)) continue;
            if (livingentity.isSensitiveToWater()) {
                livingentity.hurtServer(p_399548_, this.damageSources().indirectMagic(this, this.getOwner()), 1.0f);
            }
            if (!livingentity.isOnFire() || !livingentity.isAlive()) continue;
            livingentity.extinguishFire();
        }
        for (Axolotl axolotl : this.level().getEntitiesOfClass(Axolotl.class, aabb)) {
            axolotl.rehydrate();
        }
    }

    protected abstract void onHitAsPotion(ServerLevel var1, ItemStack var2, HitResult var3);

    private void dowseFire(BlockPos p_400047_) {
        BlockState blockstate = this.level().getBlockState(p_400047_);
        if (blockstate.is(BlockTags.FIRE)) {
            this.level().destroyBlock(p_400047_, false, this);
        } else if (AbstractCandleBlock.isLit(blockstate)) {
            AbstractCandleBlock.extinguish(null, blockstate, this.level(), p_400047_);
        } else if (CampfireBlock.isLitCampfire(blockstate)) {
            this.level().levelEvent(null, 1009, p_400047_, 0);
            CampfireBlock.dowse(this.getOwner(), this.level(), p_400047_, blockstate);
            this.level().setBlockAndUpdate(p_400047_, (BlockState)blockstate.setValue(CampfireBlock.LIT, false));
        }
    }

    @Override
    public DoubleDoubleImmutablePair calculateHorizontalHurtKnockbackDirection(LivingEntity p_400055_, DamageSource p_399475_) {
        double d0 = p_400055_.position().x - this.position().x;
        double d1 = p_400055_.position().z - this.position().z;
        return DoubleDoubleImmutablePair.of((double)d0, (double)d1);
    }
}

