/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.breeze;

import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.breeze.Breeze;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BreezeUtil {
    private static final double MAX_LINE_OF_SIGHT_TEST_RANGE = 50.0;

    public static Vec3 randomPointBehindTarget(LivingEntity p_316886_, RandomSource p_316867_) {
        int i = 90;
        float f = p_316886_.yHeadRot + 180.0f + (float)p_316867_.nextGaussian() * 90.0f / 2.0f;
        float f1 = Mth.lerp(p_316867_.nextFloat(), 4.0f, 8.0f);
        Vec3 vec3 = Vec3.directionFromRotation(0.0f, f).scale(f1);
        return p_316886_.position().add(vec3);
    }

    public static boolean hasLineOfSight(Breeze p_316785_, Vec3 p_316249_) {
        Vec3 vec3 = new Vec3(p_316785_.getX(), p_316785_.getY(), p_316785_.getZ());
        return p_316249_.distanceTo(vec3) > BreezeUtil.getMaxLineOfSightTestRange(p_316785_) ? false : p_316785_.level().clip(new ClipContext(vec3, p_316249_, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, p_316785_)).getType() == HitResult.Type.MISS;
    }

    private static double getMaxLineOfSightTestRange(Breeze p_361416_) {
        return Math.max(50.0, p_361416_.getAttributeValue(Attributes.FOLLOW_RANGE));
    }
}

