/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.PaintingVariantTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Painting
extends HangingEntity {
    private static final EntityDataAccessor<Holder<PaintingVariant>> DATA_PAINTING_VARIANT_ID = SynchedEntityData.defineId(Painting.class, EntityDataSerializers.PAINTING_VARIANT);
    public static final float DEPTH = 0.0625f;

    public Painting(EntityType<? extends Painting> p_31904_, Level p_31905_) {
        super((EntityType<? extends HangingEntity>)p_31904_, p_31905_);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_326078_) {
        super.defineSynchedData(p_326078_);
        p_326078_.define(DATA_PAINTING_VARIANT_ID, VariantUtils.getAny(this.registryAccess(), Registries.PAINTING_VARIANT));
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> p_218896_) {
        super.onSyncedDataUpdated(p_218896_);
        if (DATA_PAINTING_VARIANT_ID.equals(p_218896_)) {
            this.recalculateBoundingBox();
        }
    }

    private void setVariant(Holder<PaintingVariant> p_218892_) {
        this.entityData.set(DATA_PAINTING_VARIANT_ID, p_218892_);
    }

    public Holder<PaintingVariant> getVariant() {
        return this.entityData.get(DATA_PAINTING_VARIANT_ID);
    }

    @Override
    @Nullable
    public <T> T get(DataComponentType<? extends T> p_397321_) {
        return p_397321_ == DataComponents.PAINTING_VARIANT ? Painting.castComponentValue(p_397321_, this.getVariant()) : super.get(p_397321_);
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter p_397977_) {
        this.applyImplicitComponentIfPresent(p_397977_, DataComponents.PAINTING_VARIANT);
        super.applyImplicitComponents(p_397977_);
    }

    @Override
    protected <T> boolean applyImplicitComponent(DataComponentType<T> p_397293_, T p_397672_) {
        if (p_397293_ == DataComponents.PAINTING_VARIANT) {
            this.setVariant(Painting.castComponentValue(DataComponents.PAINTING_VARIANT, p_397672_));
            return true;
        }
        return super.applyImplicitComponent(p_397293_, p_397672_);
    }

    public static Optional<Painting> create(Level p_218888_, BlockPos p_218889_, Direction p_218890_) {
        Painting painting = new Painting(p_218888_, p_218889_);
        ArrayList<Holder> list = new ArrayList<Holder>();
        p_218888_.registryAccess().lookupOrThrow(Registries.PAINTING_VARIANT).getTagOrEmpty(PaintingVariantTags.PLACEABLE).forEach(list::add);
        if (list.isEmpty()) {
            return Optional.empty();
        }
        painting.setDirection(p_218890_);
        list.removeIf(p_412922_ -> {
            painting.setVariant((Holder<PaintingVariant>)p_412922_);
            return !painting.survives();
        });
        if (list.isEmpty()) {
            return Optional.empty();
        }
        int i = list.stream().mapToInt(Painting::variantArea).max().orElse(0);
        list.removeIf(p_218883_ -> Painting.variantArea(p_218883_) < i);
        Optional optional = Util.getRandomSafe(list, painting.random);
        if (optional.isEmpty()) {
            return Optional.empty();
        }
        painting.setVariant((Holder)optional.get());
        painting.setDirection(p_218890_);
        return Optional.of(painting);
    }

    private static int variantArea(Holder<PaintingVariant> p_218899_) {
        return p_218899_.value().area();
    }

    private Painting(Level p_218874_, BlockPos p_218875_) {
        super((EntityType<? extends HangingEntity>)EntityType.PAINTING, p_218874_, p_218875_);
    }

    public Painting(Level p_218877_, BlockPos p_218878_, Direction p_218879_, Holder<PaintingVariant> p_218880_) {
        this(p_218877_, p_218878_);
        this.setVariant(p_218880_);
        this.setDirection(p_218879_);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput p_421983_) {
        p_421983_.store("facing", Direction.LEGACY_ID_CODEC_2D, this.getDirection());
        super.addAdditionalSaveData(p_421983_);
        VariantUtils.writeVariant(p_421983_, this.getVariant());
    }

    @Override
    protected void readAdditionalSaveData(ValueInput p_421740_) {
        Direction direction = p_421740_.read("facing", Direction.LEGACY_ID_CODEC_2D).orElse(Direction.SOUTH);
        super.readAdditionalSaveData(p_421740_);
        this.setDirection(direction);
        VariantUtils.readVariant(p_421740_, Registries.PAINTING_VARIANT).ifPresent(this::setVariant);
    }

    @Override
    protected AABB calculateBoundingBox(BlockPos p_344831_, Direction p_345917_) {
        float f = 0.46875f;
        Vec3 vec3 = Vec3.atCenterOf(p_344831_).relative(p_345917_, -0.46875);
        PaintingVariant paintingvariant = this.getVariant().value();
        double d0 = this.offsetForPaintingSize(paintingvariant.width());
        double d1 = this.offsetForPaintingSize(paintingvariant.height());
        Direction direction = p_345917_.getCounterClockWise();
        Vec3 vec31 = vec3.relative(direction, d0).relative(Direction.UP, d1);
        Direction.Axis direction$axis = p_345917_.getAxis();
        double d2 = direction$axis == Direction.Axis.X ? 0.0625 : (double)paintingvariant.width();
        double d3 = paintingvariant.height();
        double d4 = direction$axis == Direction.Axis.Z ? 0.0625 : (double)paintingvariant.width();
        return AABB.ofSize(vec31, d2, d3, d4);
    }

    private double offsetForPaintingSize(int p_345028_) {
        return p_345028_ % 2 == 0 ? 0.5 : 0.0;
    }

    @Override
    public void dropItem(ServerLevel p_376289_, @Nullable Entity p_31925_) {
        if (p_376289_.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            Player player;
            this.playSound(SoundEvents.PAINTING_BREAK, 1.0f, 1.0f);
            if (!(p_31925_ instanceof Player) || !(player = (Player)p_31925_).hasInfiniteMaterials()) {
                this.spawnAtLocation(p_376289_, Items.PAINTING);
            }
        }
    }

    @Override
    public void playPlacementSound() {
        this.playSound(SoundEvents.PAINTING_PLACE, 1.0f, 1.0f);
    }

    @Override
    public void snapTo(double p_31929_, double p_31930_, double p_31931_, float p_31932_, float p_31933_) {
        this.setPos(p_31929_, p_31930_, p_31931_);
    }

    @Override
    public Vec3 trackingPosition() {
        return Vec3.atLowerCornerOf(this.pos);
    }

    @Override
    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity p_352062_) {
        return new ClientboundAddEntityPacket((Entity)this, this.getDirection().get3DDataValue(), this.getPos());
    }

    @Override
    public void recreateFromPacket(ClientboundAddEntityPacket p_218894_) {
        super.recreateFromPacket(p_218894_);
        this.setDirection(Direction.from3DDataValue(p_218894_.getData()));
    }

    @Override
    public ItemStack getPickResult() {
        return new ItemStack(Items.PAINTING);
    }
}

