/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.wolf;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Crackiness;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BegGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.animal.wolf.WolfSoundVariant;
import net.minecraft.world.entity.animal.wolf.WolfSoundVariants;
import net.minecraft.world.entity.animal.wolf.WolfVariant;
import net.minecraft.world.entity.animal.wolf.WolfVariants;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class Wolf
extends TamableAnimal
implements NeutralMob {
    private static final EntityDataAccessor<Boolean> DATA_INTERESTED_ID = SynchedEntityData.defineId(Wolf.class, EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> DATA_COLLAR_COLOR = SynchedEntityData.defineId(Wolf.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.defineId(Wolf.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Holder<WolfVariant>> DATA_VARIANT_ID = SynchedEntityData.defineId(Wolf.class, EntityDataSerializers.WOLF_VARIANT);
    private static final EntityDataAccessor<Holder<WolfSoundVariant>> DATA_SOUND_VARIANT_ID = SynchedEntityData.defineId(Wolf.class, EntityDataSerializers.WOLF_SOUND_VARIANT);
    public static final TargetingConditions.Selector PREY_SELECTOR = (p_423321_, p_423322_) -> {
        EntityType<?> entitytype = p_423321_.getType();
        return entitytype == EntityType.SHEEP || entitytype == EntityType.RABBIT || entitytype == EntityType.FOX;
    };
    private static final float START_HEALTH = 8.0f;
    private static final float TAME_HEALTH = 40.0f;
    private static final float ARMOR_REPAIR_UNIT = 0.125f;
    public static final float DEFAULT_TAIL_ANGLE = 0.62831855f;
    private static final DyeColor DEFAULT_COLLAR_COLOR = DyeColor.RED;
    private float interestedAngle;
    private float interestedAngleO;
    private boolean isWet;
    private boolean isShaking;
    private float shakeAnim;
    private float shakeAnimO;
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.rangeOfSeconds(20, 39);
    @Nullable
    private UUID persistentAngerTarget;

    public Wolf(EntityType<? extends Wolf> p_406225_, Level p_406236_) {
        super((EntityType<? extends TamableAnimal>)p_406225_, p_406236_);
        this.setTame(false, false);
        this.setPathfindingMalus(PathType.POWDER_SNOW, -1.0f);
        this.setPathfindingMalus(PathType.DANGER_POWDER_SNOW, -1.0f);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(1, new FloatGoal(this));
        this.goalSelector.addGoal(1, new TamableAnimal.TamableAnimalPanicGoal(1.5, DamageTypeTags.PANIC_ENVIRONMENTAL_CAUSES));
        this.goalSelector.addGoal(2, new SitWhenOrderedToGoal(this));
        this.goalSelector.addGoal(3, new WolfAvoidEntityGoal<Llama>(this, Llama.class, 24.0f, 1.5, 1.5));
        this.goalSelector.addGoal(4, new LeapAtTargetGoal(this, 0.4f));
        this.goalSelector.addGoal(5, new MeleeAttackGoal(this, 1.0, true));
        this.goalSelector.addGoal(6, new FollowOwnerGoal(this, 1.0, 10.0f, 2.0f));
        this.goalSelector.addGoal(7, new BreedGoal(this, 1.0));
        this.goalSelector.addGoal(8, new WaterAvoidingRandomStrollGoal(this, 1.0));
        this.goalSelector.addGoal(9, new BegGoal(this, 8.0f));
        this.goalSelector.addGoal(10, new LookAtPlayerGoal(this, Player.class, 8.0f));
        this.goalSelector.addGoal(10, new RandomLookAroundGoal(this));
        this.targetSelector.addGoal(1, new OwnerHurtByTargetGoal(this));
        this.targetSelector.addGoal(2, new OwnerHurtTargetGoal(this));
        this.targetSelector.addGoal(3, new HurtByTargetGoal(this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(4, new NearestAttackableTargetGoal<Player>(this, Player.class, 10, true, false, this::isAngryAt));
        this.targetSelector.addGoal(5, new NonTameRandomTargetGoal<Animal>(this, Animal.class, false, PREY_SELECTOR));
        this.targetSelector.addGoal(6, new NonTameRandomTargetGoal<Turtle>(this, Turtle.class, false, Turtle.BABY_ON_LAND_SELECTOR));
        this.targetSelector.addGoal(7, new NearestAttackableTargetGoal<AbstractSkeleton>((Mob)this, AbstractSkeleton.class, false));
        this.targetSelector.addGoal(8, new ResetUniversalAngerTargetGoal<Wolf>(this, true));
    }

    public ResourceLocation getTexture() {
        WolfVariant wolfvariant = this.getVariant().value();
        if (this.isTame()) {
            return wolfvariant.assetInfo().tame().texturePath();
        }
        return this.isAngry() ? wolfvariant.assetInfo().angry().texturePath() : wolfvariant.assetInfo().wild().texturePath();
    }

    private Holder<WolfVariant> getVariant() {
        return this.entityData.get(DATA_VARIANT_ID);
    }

    private void setVariant(Holder<WolfVariant> p_406302_) {
        this.entityData.set(DATA_VARIANT_ID, p_406302_);
    }

    private Holder<WolfSoundVariant> getSoundVariant() {
        return this.entityData.get(DATA_SOUND_VARIANT_ID);
    }

    private void setSoundVariant(Holder<WolfSoundVariant> p_406324_) {
        this.entityData.set(DATA_SOUND_VARIANT_ID, p_406324_);
    }

    @Override
    @Nullable
    public <T> T get(DataComponentType<? extends T> p_406363_) {
        if (p_406363_ == DataComponents.WOLF_VARIANT) {
            return Wolf.castComponentValue(p_406363_, this.getVariant());
        }
        if (p_406363_ == DataComponents.WOLF_SOUND_VARIANT) {
            return Wolf.castComponentValue(p_406363_, this.getSoundVariant());
        }
        return p_406363_ == DataComponents.WOLF_COLLAR ? Wolf.castComponentValue(p_406363_, this.getCollarColor()) : super.get(p_406363_);
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter p_406306_) {
        this.applyImplicitComponentIfPresent(p_406306_, DataComponents.WOLF_VARIANT);
        this.applyImplicitComponentIfPresent(p_406306_, DataComponents.WOLF_SOUND_VARIANT);
        this.applyImplicitComponentIfPresent(p_406306_, DataComponents.WOLF_COLLAR);
        super.applyImplicitComponents(p_406306_);
    }

    @Override
    protected <T> boolean applyImplicitComponent(DataComponentType<T> p_406368_, T p_406235_) {
        if (p_406368_ == DataComponents.WOLF_VARIANT) {
            this.setVariant(Wolf.castComponentValue(DataComponents.WOLF_VARIANT, p_406235_));
            return true;
        }
        if (p_406368_ == DataComponents.WOLF_SOUND_VARIANT) {
            this.setSoundVariant(Wolf.castComponentValue(DataComponents.WOLF_SOUND_VARIANT, p_406235_));
            return true;
        }
        if (p_406368_ == DataComponents.WOLF_COLLAR) {
            this.setCollarColor(Wolf.castComponentValue(DataComponents.WOLF_COLLAR, p_406235_));
            return true;
        }
        return super.applyImplicitComponent(p_406368_, p_406235_);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createAnimalAttributes().add(Attributes.MOVEMENT_SPEED, 0.3f).add(Attributes.MAX_HEALTH, 8.0).add(Attributes.ATTACK_DAMAGE, 4.0);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_406275_) {
        super.defineSynchedData(p_406275_);
        HolderLookup.RegistryLookup registry = this.registryAccess().lookupOrThrow(Registries.WOLF_SOUND_VARIANT);
        p_406275_.define(DATA_VARIANT_ID, VariantUtils.getDefaultOrAny(this.registryAccess(), WolfVariants.DEFAULT));
        p_406275_.define(DATA_SOUND_VARIANT_ID, (Holder)registry.get(WolfSoundVariants.CLASSIC).or(((Registry)registry)::getAny).orElseThrow());
        p_406275_.define(DATA_INTERESTED_ID, false);
        p_406275_.define(DATA_COLLAR_COLOR, DEFAULT_COLLAR_COLOR.getId());
        p_406275_.define(DATA_REMAINING_ANGER_TIME, 0);
    }

    @Override
    protected void playStepSound(BlockPos p_406221_, BlockState p_406277_) {
        this.playSound(SoundEvents.WOLF_STEP, 0.15f, 1.0f);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput p_422504_) {
        super.addAdditionalSaveData(p_422504_);
        p_422504_.store("CollarColor", DyeColor.LEGACY_ID_CODEC, this.getCollarColor());
        VariantUtils.writeVariant(p_422504_, this.getVariant());
        this.addPersistentAngerSaveData(p_422504_);
        this.getSoundVariant().unwrapKey().ifPresent(p_421374_ -> p_422504_.store("sound_variant", ResourceKey.codec(Registries.WOLF_SOUND_VARIANT), p_421374_));
    }

    @Override
    protected void readAdditionalSaveData(ValueInput p_421669_) {
        super.readAdditionalSaveData(p_421669_);
        VariantUtils.readVariant(p_421669_, Registries.WOLF_VARIANT).ifPresent(this::setVariant);
        this.setCollarColor(p_421669_.read("CollarColor", DyeColor.LEGACY_ID_CODEC).orElse(DEFAULT_COLLAR_COLOR));
        this.readPersistentAngerSaveData(this.level(), p_421669_);
        p_421669_.read("sound_variant", ResourceKey.codec(Registries.WOLF_SOUND_VARIANT)).flatMap(p_427093_ -> this.registryAccess().lookupOrThrow(Registries.WOLF_SOUND_VARIANT).get((ResourceKey)p_427093_)).ifPresent(this::setSoundVariant);
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_406251_, DifficultyInstance p_406357_, EntitySpawnReason p_406333_, @Nullable SpawnGroupData p_406273_) {
        if (p_406273_ instanceof WolfPackData) {
            WolfPackData wolf$wolfpackdata = (WolfPackData)p_406273_;
            this.setVariant(wolf$wolfpackdata.type);
        } else {
            Optional optional = VariantUtils.selectVariantToSpawn(SpawnContext.create(p_406251_, this.blockPosition()), Registries.WOLF_VARIANT);
            if (optional.isPresent()) {
                this.setVariant(optional.get());
                p_406273_ = new WolfPackData(optional.get());
            }
        }
        this.setSoundVariant(WolfSoundVariants.pickRandomSoundVariant(this.registryAccess(), p_406251_.getRandom()));
        return super.finalizeSpawn(p_406251_, p_406357_, p_406333_, p_406273_);
    }

    @Override
    protected SoundEvent getAmbientSound() {
        if (this.isAngry()) {
            return this.getSoundVariant().value().growlSound().value();
        }
        if (this.random.nextInt(3) == 0) {
            return this.isTame() && this.getHealth() < 20.0f ? this.getSoundVariant().value().whineSound().value() : this.getSoundVariant().value().pantSound().value();
        }
        return this.getSoundVariant().value().ambientSound().value();
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource p_406243_) {
        return this.canArmorAbsorb(p_406243_) ? SoundEvents.WOLF_ARMOR_DAMAGE : this.getSoundVariant().value().hurtSound().value();
    }

    @Override
    protected SoundEvent getDeathSound() {
        return this.getSoundVariant().value().deathSound().value();
    }

    @Override
    protected float getSoundVolume() {
        return 0.4f;
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide && this.isWet && !this.isShaking && !this.isPathFinding() && this.onGround()) {
            this.isShaking = true;
            this.shakeAnim = 0.0f;
            this.shakeAnimO = 0.0f;
            this.level().broadcastEntityEvent(this, (byte)8);
        }
        if (!this.level().isClientSide) {
            this.updatePersistentAnger((ServerLevel)this.level(), true);
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isAlive()) {
            this.interestedAngleO = this.interestedAngle;
            this.interestedAngle = this.isInterested() ? (this.interestedAngle += (1.0f - this.interestedAngle) * 0.4f) : (this.interestedAngle += (0.0f - this.interestedAngle) * 0.4f);
            if (this.isInWaterOrRain()) {
                this.isWet = true;
                if (this.isShaking && !this.level().isClientSide) {
                    this.level().broadcastEntityEvent(this, (byte)56);
                    this.cancelShake();
                }
            } else if ((this.isWet || this.isShaking) && this.isShaking) {
                if (this.shakeAnim == 0.0f) {
                    this.playSound(SoundEvents.WOLF_SHAKE, this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
                    this.gameEvent(GameEvent.ENTITY_ACTION);
                }
                this.shakeAnimO = this.shakeAnim;
                this.shakeAnim += 0.05f;
                if (this.shakeAnimO >= 2.0f) {
                    this.isWet = false;
                    this.isShaking = false;
                    this.shakeAnimO = 0.0f;
                    this.shakeAnim = 0.0f;
                }
                if (this.shakeAnim > 0.4f) {
                    float f = (float)this.getY();
                    int i = (int)(Mth.sin((this.shakeAnim - 0.4f) * (float)Math.PI) * 7.0f);
                    Vec3 vec3 = this.getDeltaMovement();
                    for (int j = 0; j < i; ++j) {
                        float f1 = (this.random.nextFloat() * 2.0f - 1.0f) * this.getBbWidth() * 0.5f;
                        float f2 = (this.random.nextFloat() * 2.0f - 1.0f) * this.getBbWidth() * 0.5f;
                        this.level().addParticle(ParticleTypes.SPLASH, this.getX() + (double)f1, f + 0.8f, this.getZ() + (double)f2, vec3.x, vec3.y, vec3.z);
                    }
                }
            }
        }
    }

    private void cancelShake() {
        this.isShaking = false;
        this.shakeAnim = 0.0f;
        this.shakeAnimO = 0.0f;
    }

    @Override
    public void die(DamageSource p_406227_) {
        this.isWet = false;
        this.isShaking = false;
        this.shakeAnimO = 0.0f;
        this.shakeAnim = 0.0f;
        super.die(p_406227_);
    }

    public float getWetShade(float p_406247_) {
        return !this.isWet ? 1.0f : Math.min(0.75f + Mth.lerp(p_406247_, this.shakeAnimO, this.shakeAnim) / 2.0f * 0.25f, 1.0f);
    }

    public float getShakeAnim(float p_406314_) {
        return Mth.lerp(p_406314_, this.shakeAnimO, this.shakeAnim);
    }

    public float getHeadRollAngle(float p_406332_) {
        return Mth.lerp(p_406332_, this.interestedAngleO, this.interestedAngle) * 0.15f * (float)Math.PI;
    }

    @Override
    public int getMaxHeadXRot() {
        return this.isInSittingPose() ? 20 : super.getMaxHeadXRot();
    }

    @Override
    public boolean hurtServer(ServerLevel p_406240_, DamageSource p_406339_, float p_406257_) {
        if (this.isInvulnerableTo(p_406240_, p_406339_)) {
            return false;
        }
        this.setOrderedToSit(false);
        return super.hurtServer(p_406240_, p_406339_, p_406257_);
    }

    @Override
    protected void actuallyHurt(ServerLevel p_406271_, DamageSource p_406248_, float p_406370_) {
        if (!this.canArmorAbsorb(p_406248_)) {
            super.actuallyHurt(p_406271_, p_406248_, p_406370_);
        } else {
            ItemStack itemstack = this.getBodyArmorItem();
            int i = itemstack.getDamageValue();
            int j = itemstack.getMaxDamage();
            itemstack.hurtAndBreak(Mth.ceil(p_406370_), (LivingEntity)this, EquipmentSlot.BODY);
            if (Crackiness.WOLF_ARMOR.byDamage(i, j) != Crackiness.WOLF_ARMOR.byDamage(this.getBodyArmorItem())) {
                this.playSound(SoundEvents.WOLF_ARMOR_CRACK);
                p_406271_.sendParticles(new ItemParticleOption(ParticleTypes.ITEM, Items.ARMADILLO_SCUTE.getDefaultInstance()), this.getX(), this.getY() + 1.0, this.getZ(), 20, 0.2, 0.1, 0.2, 0.1);
            }
        }
    }

    private boolean canArmorAbsorb(DamageSource p_406249_) {
        return this.getBodyArmorItem().is(Items.WOLF_ARMOR) && !p_406249_.is(DamageTypeTags.BYPASSES_WOLF_ARMOR);
    }

    @Override
    protected void applyTamingSideEffects() {
        if (this.isTame()) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(40.0);
            this.setHealth(40.0f);
        } else {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(8.0);
        }
    }

    @Override
    protected void hurtArmor(DamageSource p_406334_, float p_406321_) {
        this.doHurtEquipment(p_406334_, p_406321_, EquipmentSlot.BODY);
    }

    @Override
    protected boolean canShearEquipment(Player p_426231_) {
        return this.isOwnedBy(p_426231_);
    }

    @Override
    public InteractionResult mobInteract(Player p_406380_, InteractionHand p_406261_) {
        block13: {
            ItemStack itemstack;
            block10: {
                DyeItem dyeitem;
                block12: {
                    block11: {
                        itemstack = p_406380_.getItemInHand(p_406261_);
                        Item item = itemstack.getItem();
                        if (!this.isTame()) break block10;
                        if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                            FoodProperties foodproperties = itemstack.get(DataComponents.FOOD);
                            float f = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
                            this.heal(2.0f * f);
                            this.usePlayerItem(p_406380_, p_406261_, itemstack);
                            this.gameEvent(GameEvent.EAT);
                            return InteractionResult.SUCCESS;
                        }
                        if (!(item instanceof DyeItem)) break block11;
                        dyeitem = (DyeItem)item;
                        if (this.isOwnedBy(p_406380_)) break block12;
                    }
                    if (this.isEquippableInSlot(itemstack, EquipmentSlot.BODY) && !this.isWearingBodyArmor() && this.isOwnedBy(p_406380_) && !this.isBaby()) {
                        this.setBodyArmorItem(itemstack.copyWithCount(1));
                        itemstack.consume(1, p_406380_);
                        return InteractionResult.SUCCESS;
                    }
                    if (this.isInSittingPose() && this.isWearingBodyArmor() && this.isOwnedBy(p_406380_) && this.getBodyArmorItem().isDamaged() && this.getBodyArmorItem().isValidRepairItem(itemstack)) {
                        itemstack.shrink(1);
                        this.playSound(SoundEvents.WOLF_ARMOR_REPAIR);
                        ItemStack itemstack1 = this.getBodyArmorItem();
                        int i = (int)((float)itemstack1.getMaxDamage() * 0.125f);
                        itemstack1.setDamageValue(Math.max(0, itemstack1.getDamageValue() - i));
                        return InteractionResult.SUCCESS;
                    }
                    InteractionResult interactionresult = super.mobInteract(p_406380_, p_406261_);
                    if (!interactionresult.consumesAction() && this.isOwnedBy(p_406380_)) {
                        this.setOrderedToSit(!this.isOrderedToSit());
                        this.jumping = false;
                        this.navigation.stop();
                        this.setTarget(null);
                        return InteractionResult.SUCCESS.withoutItem();
                    }
                    return interactionresult;
                }
                DyeColor dyecolor = dyeitem.getDyeColor();
                if (dyecolor != this.getCollarColor()) {
                    this.setCollarColor(dyecolor);
                    itemstack.consume(1, p_406380_);
                    return InteractionResult.SUCCESS;
                }
                break block13;
            }
            if (!this.level().isClientSide && itemstack.is(Items.BONE) && !this.isAngry()) {
                itemstack.consume(1, p_406380_);
                this.tryToTame(p_406380_);
                return InteractionResult.SUCCESS_SERVER;
            }
        }
        return super.mobInteract(p_406380_, p_406261_);
    }

    private void tryToTame(Player p_406358_) {
        if (this.random.nextInt(3) == 0 && !EventHooks.onAnimalTame((Animal)this, (Player)p_406358_)) {
            this.tame(p_406358_);
            this.navigation.stop();
            this.setTarget(null);
            this.setOrderedToSit(true);
            this.level().broadcastEntityEvent(this, (byte)7);
        } else {
            this.level().broadcastEntityEvent(this, (byte)6);
        }
    }

    @Override
    public void handleEntityEvent(byte p_406350_) {
        if (p_406350_ == 8) {
            this.isShaking = true;
            this.shakeAnim = 0.0f;
            this.shakeAnimO = 0.0f;
        } else if (p_406350_ == 56) {
            this.cancelShake();
        } else {
            super.handleEntityEvent(p_406350_);
        }
    }

    public float getTailAngle() {
        if (this.isAngry()) {
            return 1.5393804f;
        }
        if (this.isTame()) {
            float f = this.getMaxHealth();
            float f1 = (f - this.getHealth()) / f;
            return (0.55f - f1 * 0.4f) * (float)Math.PI;
        }
        return 0.62831855f;
    }

    @Override
    public boolean isFood(ItemStack p_406272_) {
        return p_406272_.is(ItemTags.WOLF_FOOD);
    }

    @Override
    public int getMaxSpawnClusterSize() {
        return 8;
    }

    @Override
    public int getRemainingPersistentAngerTime() {
        return this.entityData.get(DATA_REMAINING_ANGER_TIME);
    }

    @Override
    public void setRemainingPersistentAngerTime(int p_406218_) {
        this.entityData.set(DATA_REMAINING_ANGER_TIME, p_406218_);
    }

    @Override
    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.sample(this.random));
    }

    @Override
    @Nullable
    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    @Override
    public void setPersistentAngerTarget(@Nullable UUID p_406276_) {
        this.persistentAngerTarget = p_406276_;
    }

    public DyeColor getCollarColor() {
        return DyeColor.byId(this.entityData.get(DATA_COLLAR_COLOR));
    }

    private void setCollarColor(DyeColor p_406328_) {
        this.entityData.set(DATA_COLLAR_COLOR, p_406328_.getId());
    }

    @Override
    @Nullable
    public Wolf getBreedOffspring(ServerLevel p_406360_, AgeableMob p_406340_) {
        Wolf wolf = EntityType.WOLF.create(p_406360_, EntitySpawnReason.BREEDING);
        if (wolf != null && p_406340_ instanceof Wolf) {
            Wolf wolf1 = (Wolf)p_406340_;
            if (this.random.nextBoolean()) {
                wolf.setVariant(this.getVariant());
            } else {
                wolf.setVariant(wolf1.getVariant());
            }
            if (this.isTame()) {
                wolf.setOwnerReference(this.getOwnerReference());
                wolf.setTame(true, true);
                DyeColor dyecolor = this.getCollarColor();
                DyeColor dyecolor1 = wolf1.getCollarColor();
                wolf.setCollarColor(DyeColor.getMixedColor(p_406360_, dyecolor, dyecolor1));
            }
            wolf.setSoundVariant(WolfSoundVariants.pickRandomSoundVariant(this.registryAccess(), this.random));
        }
        return wolf;
    }

    public void setIsInterested(boolean p_406238_) {
        this.entityData.set(DATA_INTERESTED_ID, p_406238_);
    }

    @Override
    public boolean canMate(Animal p_406266_) {
        if (p_406266_ == this) {
            return false;
        }
        if (!this.isTame()) {
            return false;
        }
        if (!(p_406266_ instanceof Wolf)) {
            return false;
        }
        Wolf wolf = (Wolf)p_406266_;
        if (!wolf.isTame()) {
            return false;
        }
        return wolf.isInSittingPose() ? false : this.isInLove() && wolf.isInLove();
    }

    public boolean isInterested() {
        return this.entityData.get(DATA_INTERESTED_ID);
    }

    @Override
    public boolean wantsToAttack(LivingEntity p_406214_, LivingEntity p_406223_) {
        TamableAnimal tamableanimal;
        AbstractHorse abstracthorse;
        if (p_406214_ instanceof Creeper || p_406214_ instanceof Ghast || p_406214_ instanceof ArmorStand) {
            return false;
        }
        if (p_406214_ instanceof Wolf) {
            Wolf wolf = (Wolf)p_406214_;
            return !wolf.isTame() || wolf.getOwner() != p_406223_;
        }
        if (p_406214_ instanceof Player) {
            Player player1;
            Player player = (Player)p_406214_;
            if (p_406223_ instanceof Player && !(player1 = (Player)p_406223_).canHarmPlayer(player)) {
                return false;
            }
        }
        return p_406214_ instanceof AbstractHorse && (abstracthorse = (AbstractHorse)p_406214_).isTamed() ? false : !(p_406214_ instanceof TamableAnimal) || !(tamableanimal = (TamableAnimal)p_406214_).isTame();
    }

    @Override
    public boolean canBeLeashed() {
        return !this.isAngry();
    }

    @Override
    public Vec3 getLeashOffset() {
        return new Vec3(0.0, 0.6f * this.getEyeHeight(), this.getBbWidth() * 0.4f);
    }

    public static boolean checkWolfSpawnRules(EntityType<Wolf> p_406300_, LevelAccessor p_406219_, EntitySpawnReason p_406228_, BlockPos p_406222_, RandomSource p_406373_) {
        return p_406219_.getBlockState(p_406222_.below()).is(BlockTags.WOLVES_SPAWNABLE_ON) && Wolf.isBrightEnoughToSpawn(p_406219_, p_406222_);
    }

    class WolfAvoidEntityGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        private final Wolf wolf;

        public WolfAvoidEntityGoal(Wolf p_406307_, Class<T> p_406210_, float p_406355_, double p_406232_, double p_406290_) {
            super(p_406307_, p_406210_, p_406355_, p_406232_, p_406290_);
            this.wolf = p_406307_;
        }

        @Override
        public boolean canUse() {
            return super.canUse() && this.toAvoid instanceof Llama ? !this.wolf.isTame() && this.avoidLlama((Llama)this.toAvoid) : false;
        }

        private boolean avoidLlama(Llama p_406226_) {
            return p_406226_.getStrength() >= Wolf.this.random.nextInt(5);
        }

        @Override
        public void start() {
            Wolf.this.setTarget(null);
            super.start();
        }

        @Override
        public void tick() {
            Wolf.this.setTarget(null);
            super.tick();
        }
    }

    public static class WolfPackData
    extends AgeableMob.AgeableMobGroupData {
        public final Holder<WolfVariant> type;

        public WolfPackData(Holder<WolfVariant> p_406297_) {
            super(false);
            this.type = p_406297_;
        }
    }
}

