/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.sheep;

import net.minecraft.core.Holder;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.biome.Biome;

public class SheepColorSpawnRules {
    private static final SheepColorSpawnConfiguration TEMPERATE_SPAWN_CONFIGURATION = new SheepColorSpawnConfiguration(SheepColorSpawnRules.weighted(SheepColorSpawnRules.builder().add(SheepColorSpawnRules.single(DyeColor.BLACK), 5).add(SheepColorSpawnRules.single(DyeColor.GRAY), 5).add(SheepColorSpawnRules.single(DyeColor.LIGHT_GRAY), 5).add(SheepColorSpawnRules.single(DyeColor.BROWN), 3).add(SheepColorSpawnRules.commonColors(DyeColor.WHITE), 82).build()));
    private static final SheepColorSpawnConfiguration WARM_SPAWN_CONFIGURATION = new SheepColorSpawnConfiguration(SheepColorSpawnRules.weighted(SheepColorSpawnRules.builder().add(SheepColorSpawnRules.single(DyeColor.GRAY), 5).add(SheepColorSpawnRules.single(DyeColor.LIGHT_GRAY), 5).add(SheepColorSpawnRules.single(DyeColor.WHITE), 5).add(SheepColorSpawnRules.single(DyeColor.BLACK), 3).add(SheepColorSpawnRules.commonColors(DyeColor.BROWN), 82).build()));
    private static final SheepColorSpawnConfiguration COLD_SPAWN_CONFIGURATION = new SheepColorSpawnConfiguration(SheepColorSpawnRules.weighted(SheepColorSpawnRules.builder().add(SheepColorSpawnRules.single(DyeColor.LIGHT_GRAY), 5).add(SheepColorSpawnRules.single(DyeColor.GRAY), 5).add(SheepColorSpawnRules.single(DyeColor.WHITE), 5).add(SheepColorSpawnRules.single(DyeColor.BROWN), 3).add(SheepColorSpawnRules.commonColors(DyeColor.BLACK), 82).build()));

    private static SheepColorProvider commonColors(DyeColor p_405584_) {
        return SheepColorSpawnRules.weighted(SheepColorSpawnRules.builder().add(SheepColorSpawnRules.single(p_405584_), 499).add(SheepColorSpawnRules.single(DyeColor.PINK), 1).build());
    }

    public static DyeColor getSheepColor(Holder<Biome> p_404960_, RandomSource p_405409_) {
        SheepColorSpawnConfiguration sheepcolorspawnrules$sheepcolorspawnconfiguration = SheepColorSpawnRules.getSheepColorConfiguration(p_404960_);
        return sheepcolorspawnrules$sheepcolorspawnconfiguration.colors().get(p_405409_);
    }

    private static SheepColorSpawnConfiguration getSheepColorConfiguration(Holder<Biome> p_405512_) {
        if (p_405512_.is(BiomeTags.SPAWNS_WARM_VARIANT_FARM_ANIMALS)) {
            return WARM_SPAWN_CONFIGURATION;
        }
        return p_405512_.is(BiomeTags.SPAWNS_COLD_VARIANT_FARM_ANIMALS) ? COLD_SPAWN_CONFIGURATION : TEMPERATE_SPAWN_CONFIGURATION;
    }

    private static SheepColorProvider weighted(WeightedList<SheepColorProvider> p_405728_) {
        if (p_405728_.isEmpty()) {
            throw new IllegalArgumentException("List must be non-empty");
        }
        return p_404682_ -> ((SheepColorProvider)p_405728_.getRandomOrThrow(p_404682_)).get(p_404682_);
    }

    private static SheepColorProvider single(DyeColor p_405704_) {
        return p_405197_ -> p_405704_;
    }

    private static WeightedList.Builder<SheepColorProvider> builder() {
        return WeightedList.builder();
    }

    @FunctionalInterface
    static interface SheepColorProvider {
        public DyeColor get(RandomSource var1);
    }

    record SheepColorSpawnConfiguration(SheepColorProvider colors) {
    }
}

