/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Donkey;
import net.minecraft.world.entity.animal.horse.Markings;
import net.minecraft.world.entity.animal.horse.Mule;
import net.minecraft.world.entity.animal.horse.Variant;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class Horse
extends AbstractHorse {
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.defineId(Horse.class, EntityDataSerializers.INT);
    private static final EntityDimensions BABY_DIMENSIONS = EntityType.HORSE.getDimensions().withAttachments(EntityAttachments.builder().attach(EntityAttachment.PASSENGER, 0.0f, EntityType.HORSE.getHeight() + 0.125f, 0.0f)).scale(0.5f);
    private static final int DEFAULT_VARIANT = 0;

    public Horse(EntityType<? extends Horse> p_30689_, Level p_30690_) {
        super((EntityType<? extends AbstractHorse>)p_30689_, p_30690_);
    }

    @Override
    protected void randomizeAttributes(RandomSource p_218815_) {
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(Horse.generateMaxHealth(p_218815_::nextInt));
        this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(Horse.generateSpeed(p_218815_::nextDouble));
        this.getAttribute(Attributes.JUMP_STRENGTH).setBaseValue(Horse.generateJumpStrength(p_218815_::nextDouble));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_326175_) {
        super.defineSynchedData(p_326175_);
        p_326175_.define(DATA_ID_TYPE_VARIANT, 0);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput p_422398_) {
        super.addAdditionalSaveData(p_422398_);
        p_422398_.putInt("Variant", this.getTypeVariant());
    }

    @Override
    protected void readAdditionalSaveData(ValueInput p_422070_) {
        super.readAdditionalSaveData(p_422070_);
        this.setTypeVariant(p_422070_.getIntOr("Variant", 0));
    }

    private void setTypeVariant(int p_30737_) {
        this.entityData.set(DATA_ID_TYPE_VARIANT, p_30737_);
    }

    private int getTypeVariant() {
        return this.entityData.get(DATA_ID_TYPE_VARIANT);
    }

    private void setVariantAndMarkings(Variant p_30700_, Markings p_30701_) {
        this.setTypeVariant(p_30700_.getId() & 0xFF | p_30701_.getId() << 8 & 0xFF00);
    }

    public Variant getVariant() {
        return Variant.byId(this.getTypeVariant() & 0xFF);
    }

    private void setVariant(Variant p_262684_) {
        this.setTypeVariant(p_262684_.getId() & 0xFF | this.getTypeVariant() & 0xFFFFFF00);
    }

    @Override
    @Nullable
    public <T> T get(DataComponentType<? extends T> p_397746_) {
        return p_397746_ == DataComponents.HORSE_VARIANT ? Horse.castComponentValue(p_397746_, this.getVariant()) : super.get(p_397746_);
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter p_397832_) {
        this.applyImplicitComponentIfPresent(p_397832_, DataComponents.HORSE_VARIANT);
        super.applyImplicitComponents(p_397832_);
    }

    @Override
    protected <T> boolean applyImplicitComponent(DataComponentType<T> p_397458_, T p_397829_) {
        if (p_397458_ == DataComponents.HORSE_VARIANT) {
            this.setVariant(Horse.castComponentValue(DataComponents.HORSE_VARIANT, p_397829_));
            return true;
        }
        return super.applyImplicitComponent(p_397458_, p_397829_);
    }

    public Markings getMarkings() {
        return Markings.byId((this.getTypeVariant() & 0xFF00) >> 8);
    }

    @Override
    protected void playGallopSound(SoundType p_30709_) {
        super.playGallopSound(p_30709_);
        if (this.random.nextInt(10) == 0) {
            this.playSound(SoundEvents.HORSE_BREATHE, p_30709_.getVolume() * 0.6f, p_30709_.getPitch());
        }
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.HORSE_AMBIENT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.HORSE_DEATH;
    }

    @Override
    @Nullable
    protected SoundEvent getEatingSound() {
        return SoundEvents.HORSE_EAT;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource p_30720_) {
        return SoundEvents.HORSE_HURT;
    }

    @Override
    protected SoundEvent getAngrySound() {
        return SoundEvents.HORSE_ANGRY;
    }

    @Override
    public InteractionResult mobInteract(Player p_30713_, InteractionHand p_30714_) {
        boolean flag;
        boolean bl = flag = !this.isBaby() && this.isTamed() && p_30713_.isSecondaryUseActive();
        if (!this.isVehicle() && !flag) {
            ItemStack itemstack = p_30713_.getItemInHand(p_30714_);
            if (!itemstack.isEmpty()) {
                if (this.isFood(itemstack)) {
                    return this.fedFood(p_30713_, itemstack);
                }
                if (!this.isTamed()) {
                    this.makeMad();
                    return InteractionResult.SUCCESS;
                }
            }
            return super.mobInteract(p_30713_, p_30714_);
        }
        return super.mobInteract(p_30713_, p_30714_);
    }

    @Override
    public boolean canMate(Animal p_30698_) {
        if (p_30698_ == this) {
            return false;
        }
        return !(p_30698_ instanceof Donkey) && !(p_30698_ instanceof Horse) ? false : this.canParent() && ((AbstractHorse)p_30698_).canParent();
    }

    @Override
    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel p_149533_, AgeableMob p_149534_) {
        if (p_149534_ instanceof Donkey) {
            Mule mule = EntityType.MULE.create(p_149533_, EntitySpawnReason.BREEDING);
            if (mule != null) {
                this.setOffspringAttributes(p_149534_, mule);
            }
            return mule;
        }
        Horse horse = (Horse)p_149534_;
        Horse horse1 = EntityType.HORSE.create(p_149533_, EntitySpawnReason.BREEDING);
        if (horse1 != null) {
            int i = this.random.nextInt(9);
            Variant variant = i < 4 ? this.getVariant() : (i < 8 ? horse.getVariant() : Util.getRandom(Variant.values(), this.random));
            int j = this.random.nextInt(5);
            Markings markings = j < 2 ? this.getMarkings() : (j < 4 ? horse.getMarkings() : Util.getRandom(Markings.values(), this.random));
            horse1.setVariantAndMarkings(variant, markings);
            this.setOffspringAttributes(p_149534_, horse1);
        }
        return horse1;
    }

    @Override
    public boolean canUseSlot(EquipmentSlot p_348583_) {
        return true;
    }

    @Override
    protected void hurtArmor(DamageSource p_379528_, float p_379933_) {
        this.doHurtEquipment(p_379528_, p_379933_, EquipmentSlot.BODY);
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_30703_, DifficultyInstance p_30704_, EntitySpawnReason p_364884_, @Nullable SpawnGroupData p_30706_) {
        Variant variant;
        RandomSource randomsource = p_30703_.getRandom();
        if (p_30706_ instanceof HorseGroupData) {
            variant = ((HorseGroupData)p_30706_).variant;
        } else {
            variant = Util.getRandom(Variant.values(), randomsource);
            p_30706_ = new HorseGroupData(variant);
        }
        this.setVariantAndMarkings(variant, Util.getRandom(Markings.values(), randomsource));
        return super.finalizeSpawn(p_30703_, p_30704_, p_364884_, p_30706_);
    }

    @Override
    public EntityDimensions getDefaultDimensions(Pose p_316325_) {
        return this.isBaby() ? BABY_DIMENSIONS : super.getDefaultDimensions(p_316325_);
    }

    public static class HorseGroupData
    extends AgeableMob.AgeableMobGroupData {
        public final Variant variant;

        public HorseGroupData(Variant p_30740_) {
            super(true);
            this.variant = p_30740_;
        }
    }
}

