/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.frog;

import net.minecraft.core.ClientAsset;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.animal.TemperatureVariants;
import net.minecraft.world.entity.animal.frog.FrogVariant;
import net.minecraft.world.entity.variant.BiomeCheck;
import net.minecraft.world.entity.variant.SpawnPrioritySelectors;
import net.minecraft.world.level.biome.Biome;

public interface FrogVariants {
    public static final ResourceKey<FrogVariant> TEMPERATE = FrogVariants.createKey(TemperatureVariants.TEMPERATE);
    public static final ResourceKey<FrogVariant> WARM = FrogVariants.createKey(TemperatureVariants.WARM);
    public static final ResourceKey<FrogVariant> COLD = FrogVariants.createKey(TemperatureVariants.COLD);

    private static ResourceKey<FrogVariant> createKey(ResourceLocation p_399726_) {
        return ResourceKey.create(Registries.FROG_VARIANT, p_399726_);
    }

    public static void bootstrap(BootstrapContext<FrogVariant> p_399856_) {
        FrogVariants.register(p_399856_, TEMPERATE, "entity/frog/temperate_frog", SpawnPrioritySelectors.fallback(0));
        FrogVariants.register(p_399856_, WARM, "entity/frog/warm_frog", BiomeTags.SPAWNS_WARM_VARIANT_FROGS);
        FrogVariants.register(p_399856_, COLD, "entity/frog/cold_frog", BiomeTags.SPAWNS_COLD_VARIANT_FROGS);
    }

    private static void register(BootstrapContext<FrogVariant> p_400026_, ResourceKey<FrogVariant> p_399464_, String p_399971_, TagKey<Biome> p_399473_) {
        HolderSet.Named<Biome> holderset = p_400026_.lookup(Registries.BIOME).getOrThrow(p_399473_);
        FrogVariants.register(p_400026_, p_399464_, p_399971_, SpawnPrioritySelectors.single(new BiomeCheck(holderset), 1));
    }

    private static void register(BootstrapContext<FrogVariant> p_399696_, ResourceKey<FrogVariant> p_399649_, String p_400239_, SpawnPrioritySelectors p_399940_) {
        p_399696_.register(p_399649_, new FrogVariant(new ClientAsset(ResourceLocation.withDefaultNamespace(p_400239_)), p_399940_));
    }
}

