/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.animal.PigVariant;
import net.minecraft.world.entity.animal.TemperatureVariants;
import net.minecraft.world.entity.variant.BiomeCheck;
import net.minecraft.world.entity.variant.ModelAndTexture;
import net.minecraft.world.entity.variant.SpawnPrioritySelectors;
import net.minecraft.world.level.biome.Biome;

public class PigVariants {
    public static final ResourceKey<PigVariant> TEMPERATE = PigVariants.createKey(TemperatureVariants.TEMPERATE);
    public static final ResourceKey<PigVariant> WARM = PigVariants.createKey(TemperatureVariants.WARM);
    public static final ResourceKey<PigVariant> COLD = PigVariants.createKey(TemperatureVariants.COLD);
    public static final ResourceKey<PigVariant> DEFAULT = TEMPERATE;

    private static ResourceKey<PigVariant> createKey(ResourceLocation p_399569_) {
        return ResourceKey.create(Registries.PIG_VARIANT, p_399569_);
    }

    public static void bootstrap(BootstrapContext<PigVariant> p_393508_) {
        PigVariants.register(p_393508_, TEMPERATE, PigVariant.ModelType.NORMAL, "temperate_pig", SpawnPrioritySelectors.fallback(0));
        PigVariants.register(p_393508_, WARM, PigVariant.ModelType.NORMAL, "warm_pig", BiomeTags.SPAWNS_WARM_VARIANT_FARM_ANIMALS);
        PigVariants.register(p_393508_, COLD, PigVariant.ModelType.COLD, "cold_pig", BiomeTags.SPAWNS_COLD_VARIANT_FARM_ANIMALS);
    }

    private static void register(BootstrapContext<PigVariant> p_393614_, ResourceKey<PigVariant> p_394526_, PigVariant.ModelType p_394644_, String p_394391_, TagKey<Biome> p_394321_) {
        HolderSet.Named<Biome> holderset = p_393614_.lookup(Registries.BIOME).getOrThrow(p_394321_);
        PigVariants.register(p_393614_, p_394526_, p_394644_, p_394391_, SpawnPrioritySelectors.single(new BiomeCheck(holderset), 1));
    }

    private static void register(BootstrapContext<PigVariant> p_393468_, ResourceKey<PigVariant> p_393702_, PigVariant.ModelType p_393507_, String p_394122_, SpawnPrioritySelectors p_400293_) {
        ResourceLocation resourcelocation = ResourceLocation.withDefaultNamespace("entity/pig/" + p_394122_);
        p_393468_.register(p_393702_, new PigVariant(new ModelAndTexture<PigVariant.ModelType>(p_393507_, resourcelocation), p_400293_));
    }
}

