/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.mojang.serialization.Dynamic;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.game.ClientboundEntityPositionSyncPacket;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.HappyGhastAi;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class HappyGhast
extends Animal {
    public static final float BABY_SCALE = 0.2375f;
    public static final int WANDER_GROUND_DISTANCE = 16;
    public static final int SMALL_RESTRICTION_RADIUS = 32;
    public static final int LARGE_RESTRICTION_RADIUS = 64;
    public static final int RESTRICTION_RADIUS_BUFFER = 16;
    public static final int FAST_HEALING_TICKS = 20;
    public static final int SLOW_HEALING_TICKS = 600;
    public static final int MAX_PASSANGERS = 4;
    private static final int STILL_TIMEOUT_ON_LOAD_GRACE_PERIOD = 60;
    private static final int MAX_STILL_TIMEOUT = 10;
    public static final float SPEED_MULTIPLIER_WHEN_PANICKING = 2.0f;
    public static final Predicate<ItemStack> IS_FOOD = p_416206_ -> p_416206_.is(ItemTags.HAPPY_GHAST_FOOD);
    private int leashHolderTime = 0;
    private int serverStillTimeout;
    private static final EntityDataAccessor<Boolean> IS_LEASH_HOLDER = SynchedEntityData.defineId(HappyGhast.class, EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> STAYS_STILL = SynchedEntityData.defineId(HappyGhast.class, EntityDataSerializers.BOOLEAN);
    private static final float MAX_SCALE = 1.0f;

    public HappyGhast(EntityType<? extends HappyGhast> p_416120_, Level p_415604_) {
        super((EntityType<? extends Animal>)p_416120_, p_415604_);
        this.moveControl = new Ghast.GhastMoveControl(this, true, this::isOnStillTimeout);
        this.lookControl = new HappyGhastLookControl();
    }

    private void setServerStillTimeout(int p_428379_) {
        Level level;
        if (this.serverStillTimeout <= 0 && p_428379_ > 0 && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            this.syncPacketPositionCodec(this.getX(), this.getY(), this.getZ());
            serverlevel.getChunkSource().chunkMap.broadcast(this, ClientboundEntityPositionSyncPacket.of(this));
        }
        this.serverStillTimeout = p_428379_;
        this.syncStayStillFlag();
    }

    private PathNavigation createBabyNavigation(Level p_416140_) {
        return new BabyFlyingPathNavigation(this, p_416140_);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(3, new HappyGhastFloatGoal());
        this.goalSelector.addGoal(4, new TemptGoal.ForNonPathfinders((Mob)this, 1.0, p_427073_ -> !this.isWearingBodyArmor() && !this.isBaby() ? p_427073_.is(ItemTags.HAPPY_GHAST_TEMPT_ITEMS) : IS_FOOD.test((ItemStack)p_427073_), false, 7.0));
        this.goalSelector.addGoal(5, new Ghast.RandomFloatAroundGoal(this, 16));
    }

    private void adultGhastSetup() {
        this.moveControl = new Ghast.GhastMoveControl(this, true, this::isOnStillTimeout);
        this.lookControl = new HappyGhastLookControl();
        this.navigation = this.createNavigation(this.level());
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            this.removeAllGoals(p_416103_ -> true);
            this.registerGoals();
            this.brain.stopAll(serverlevel, this);
            this.brain.clearMemories();
        }
    }

    private void babyGhastSetup() {
        this.moveControl = new FlyingMoveControl(this, 180, true);
        this.lookControl = new LookControl(this);
        this.navigation = this.createBabyNavigation(this.level());
        this.setServerStillTimeout(0);
        this.removeAllGoals(p_416715_ -> true);
    }

    @Override
    protected void ageBoundaryReached() {
        if (this.isBaby()) {
            this.babyGhastSetup();
        } else {
            this.adultGhastSetup();
        }
        super.ageBoundaryReached();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createAnimalAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.TEMPT_RANGE, 16.0).add(Attributes.FLYING_SPEED, 0.05).add(Attributes.MOVEMENT_SPEED, 0.05).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.CAMERA_DISTANCE, 8.0);
    }

    @Override
    protected float sanitizeScale(float p_423595_) {
        return Math.min(p_423595_, 1.0f);
    }

    @Override
    protected void checkFallDamage(double p_415661_, boolean p_416292_, BlockState p_416145_, BlockPos p_416322_) {
    }

    @Override
    public boolean onClimbable() {
        return false;
    }

    @Override
    public void travel(Vec3 p_415625_) {
        float f = (float)this.getAttributeValue(Attributes.FLYING_SPEED) * 5.0f / 3.0f;
        this.travelFlying(p_415625_, f, f, f);
    }

    @Override
    public float getWalkTargetValue(BlockPos p_415671_, LevelReader p_416275_) {
        if (!p_416275_.isEmptyBlock(p_415671_)) {
            return 0.0f;
        }
        return p_416275_.isEmptyBlock(p_415671_.below()) && !p_416275_.isEmptyBlock(p_415671_.below(2)) ? 10.0f : 5.0f;
    }

    @Override
    public boolean canBreatheUnderwater() {
        return this.isBaby() ? true : super.canBreatheUnderwater();
    }

    @Override
    protected boolean shouldStayCloseToLeashHolder() {
        return false;
    }

    @Override
    protected void playStepSound(BlockPos p_418048_, BlockState p_418140_) {
    }

    @Override
    public float getVoicePitch() {
        return 1.0f;
    }

    @Override
    public SoundSource getSoundSource() {
        return SoundSource.NEUTRAL;
    }

    @Override
    public int getAmbientSoundInterval() {
        int i = super.getAmbientSoundInterval();
        return this.isVehicle() ? i * 6 : i;
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return this.isBaby() ? SoundEvents.GHASTLING_AMBIENT : SoundEvents.HAPPY_GHAST_AMBIENT;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource p_416586_) {
        return this.isBaby() ? SoundEvents.GHASTLING_HURT : SoundEvents.HAPPY_GHAST_HURT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return this.isBaby() ? SoundEvents.GHASTLING_DEATH : SoundEvents.HAPPY_GHAST_DEATH;
    }

    @Override
    public int getMaxSpawnClusterSize() {
        return 1;
    }

    @Override
    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel p_416321_, AgeableMob p_415790_) {
        return EntityType.HAPPY_GHAST.create(p_416321_, EntitySpawnReason.BREEDING);
    }

    @Override
    public boolean canFallInLove() {
        return false;
    }

    @Override
    public float getAgeScale() {
        return this.isBaby() ? 0.2375f : 1.0f;
    }

    @Override
    public boolean isFood(ItemStack p_415992_) {
        return IS_FOOD.test(p_415992_);
    }

    @Override
    public boolean canUseSlot(EquipmentSlot p_416032_) {
        return p_416032_ != EquipmentSlot.BODY ? super.canUseSlot(p_416032_) : this.isAlive() && !this.isBaby();
    }

    @Override
    protected boolean canDispenserEquipIntoSlot(EquipmentSlot p_419719_) {
        return p_419719_ == EquipmentSlot.BODY;
    }

    @Override
    public InteractionResult mobInteract(Player p_416280_, InteractionHand p_416599_) {
        InteractionResult interactionresult;
        if (this.isBaby()) {
            return super.mobInteract(p_416280_, p_416599_);
        }
        ItemStack itemstack = p_416280_.getItemInHand(p_416599_);
        if (!itemstack.isEmpty() && (interactionresult = itemstack.interactLivingEntity(p_416280_, this, p_416599_)).consumesAction()) {
            return interactionresult;
        }
        if (this.isWearingBodyArmor() && !p_416280_.isSecondaryUseActive()) {
            this.doPlayerRide(p_416280_);
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(p_416280_, p_416599_);
    }

    private void doPlayerRide(Player p_415979_) {
        if (!this.level().isClientSide) {
            p_415979_.startRiding(this);
        }
    }

    @Override
    protected void addPassenger(Entity p_416440_) {
        if (!this.isVehicle()) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.HARNESS_GOGGLES_DOWN, this.getSoundSource(), 1.0f, 1.0f);
        }
        super.addPassenger(p_416440_);
        if (!this.level().isClientSide) {
            if (!this.scanPlayerAboveGhast()) {
                this.setServerStillTimeout(0);
            } else if (this.serverStillTimeout > 10) {
                this.setServerStillTimeout(10);
            }
        }
    }

    @Override
    protected void removePassenger(Entity p_415575_) {
        super.removePassenger(p_415575_);
        if (!this.level().isClientSide) {
            this.setServerStillTimeout(10);
        }
        if (!this.isVehicle()) {
            this.clearHome();
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.HARNESS_GOGGLES_UP, this.getSoundSource(), 1.0f, 1.0f);
        }
    }

    @Override
    protected boolean canAddPassenger(Entity p_416701_) {
        return this.getPassengers().size() < 4;
    }

    @Override
    @Nullable
    public LivingEntity getControllingPassenger() {
        LivingEntity livingEntity;
        Entity entity;
        if (this.isWearingBodyArmor() && !this.isOnStillTimeout() && (entity = this.getFirstPassenger()) instanceof Player) {
            Player player = (Player)entity;
            livingEntity = player;
        } else {
            livingEntity = super.getControllingPassenger();
        }
        return livingEntity;
    }

    @Override
    protected Vec3 getRiddenInput(Player p_415905_, Vec3 p_416391_) {
        float f = p_415905_.xxa;
        float f1 = 0.0f;
        float f2 = 0.0f;
        if (p_415905_.zza != 0.0f) {
            float f3 = Mth.cos(p_415905_.getXRot() * ((float)Math.PI / 180));
            float f4 = -Mth.sin(p_415905_.getXRot() * ((float)Math.PI / 180));
            if (p_415905_.zza < 0.0f) {
                f3 *= -0.5f;
                f4 *= -0.5f;
            }
            f2 = f4;
            f1 = f3;
        }
        if (p_415905_.isJumping()) {
            f2 += 0.5f;
        }
        return new Vec3(f, f2, f1).scale((double)3.9f * this.getAttributeValue(Attributes.FLYING_SPEED));
    }

    protected Vec2 getRiddenRotation(LivingEntity p_416565_) {
        return new Vec2(p_416565_.getXRot() * 0.5f, p_416565_.getYRot());
    }

    @Override
    protected void tickRidden(Player p_415788_, Vec3 p_415718_) {
        super.tickRidden(p_415788_, p_415718_);
        Vec2 vec2 = this.getRiddenRotation(p_415788_);
        float f = this.getYRot();
        float f1 = Mth.wrapDegrees(vec2.y - f);
        float f2 = 0.08f;
        this.setRot(f += f1 * 0.08f, vec2.x);
        this.yBodyRot = this.yHeadRot = f;
        this.yRotO = this.yHeadRot;
    }

    protected Brain.Provider<HappyGhast> brainProvider() {
        return HappyGhastAi.brainProvider();
    }

    @Override
    protected Brain<?> makeBrain(Dynamic<?> p_415876_) {
        return HappyGhastAi.makeBrain(this.brainProvider().makeBrain(p_415876_));
    }

    @Override
    protected void customServerAiStep(ServerLevel p_415734_) {
        if (this.isBaby()) {
            ProfilerFiller profilerfiller = Profiler.get();
            profilerfiller.push("happyGhastBrain");
            this.brain.tick(p_415734_, this);
            profilerfiller.pop();
            profilerfiller.push("happyGhastActivityUpdate");
            HappyGhastAi.updateActivity(this);
            profilerfiller.pop();
        }
        this.checkRestriction();
        super.customServerAiStep(p_415734_);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide()) {
            if (this.leashHolderTime > 0) {
                --this.leashHolderTime;
            }
            this.setLeashHolder(this.leashHolderTime > 0);
            if (this.serverStillTimeout > 0) {
                if (this.tickCount > 60) {
                    --this.serverStillTimeout;
                }
                this.setServerStillTimeout(this.serverStillTimeout);
            }
            if (this.scanPlayerAboveGhast()) {
                this.setServerStillTimeout(10);
            }
        }
    }

    @Override
    public void aiStep() {
        if (!this.level().isClientSide) {
            this.setRequiresPrecisePosition(this.isOnStillTimeout());
        }
        super.aiStep();
        this.continuousHeal();
    }

    private int getHappyGhastRestrictionRadius() {
        return !this.isBaby() && this.getItemBySlot(EquipmentSlot.BODY).isEmpty() ? 64 : 32;
    }

    private void checkRestriction() {
        if (!this.isLeashed() && !this.isVehicle()) {
            int i = this.getHappyGhastRestrictionRadius();
            if (!this.hasHome() || !this.getHomePosition().closerThan(this.blockPosition(), i + 16) || i != this.getHomeRadius()) {
                this.setHomeTo(this.blockPosition(), i);
            }
        }
    }

    private void continuousHeal() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            boolean flag;
            ServerLevel serverlevel = (ServerLevel)level;
            if (this.isAlive() && this.deathTime == 0 && this.getMaxHealth() != this.getHealth() && this.tickCount % ((flag = serverlevel.dimensionType().natural() && (this.isInClouds() || serverlevel.precipitationAt(this.blockPosition()) != Biome.Precipitation.NONE)) ? 20 : 600) == 0) {
                this.heal(1.0f);
            }
        }
    }

    @Override
    protected void sendDebugPackets() {
        super.sendDebugPackets();
        DebugPackets.sendEntityBrain(this);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_418455_) {
        super.defineSynchedData(p_418455_);
        p_418455_.define(IS_LEASH_HOLDER, false);
        p_418455_.define(STAYS_STILL, false);
    }

    private void setLeashHolder(boolean p_418010_) {
        this.entityData.set(IS_LEASH_HOLDER, p_418010_);
    }

    public boolean isLeashHolder() {
        return this.entityData.get(IS_LEASH_HOLDER);
    }

    private void syncStayStillFlag() {
        this.entityData.set(STAYS_STILL, this.serverStillTimeout > 0);
    }

    public boolean staysStill() {
        return this.entityData.get(STAYS_STILL);
    }

    @Override
    public boolean supportQuadLeashAsHolder() {
        return true;
    }

    @Override
    public Vec3[] getQuadLeashHolderOffsets() {
        return Leashable.createQuadLeashOffsets(this, -0.03125, 0.4375, 0.46875, 0.03125);
    }

    @Override
    public Vec3 getLeashOffset() {
        return Vec3.ZERO;
    }

    @Override
    public double leashElasticDistance() {
        return 10.0;
    }

    @Override
    public double leashSnapDistance() {
        return 16.0;
    }

    @Override
    public void onElasticLeashPull() {
        super.onElasticLeashPull();
        this.getMoveControl().setWait();
    }

    @Override
    public void notifyLeashHolder(Leashable p_418430_) {
        if (p_418430_.supportQuadLeash()) {
            this.leashHolderTime = 5;
        }
    }

    @Override
    public void addAdditionalSaveData(ValueOutput p_423551_) {
        super.addAdditionalSaveData(p_423551_);
        p_423551_.putInt("still_timeout", this.serverStillTimeout);
    }

    @Override
    public void readAdditionalSaveData(ValueInput p_423487_) {
        super.readAdditionalSaveData(p_423487_);
        this.setServerStillTimeout(p_423487_.getIntOr("still_timeout", 0));
    }

    public boolean isOnStillTimeout() {
        return this.staysStill() || this.serverStillTimeout > 0;
    }

    private boolean scanPlayerAboveGhast() {
        AABB aabb = this.getBoundingBox();
        AABB aabb1 = new AABB(aabb.minX - 1.0, aabb.maxY - (double)1.0E-5f, aabb.minZ - 1.0, aabb.maxX + 1.0, aabb.maxY + aabb.getYsize() / 2.0, aabb.maxZ + 1.0);
        for (Player player : this.level().players()) {
            Entity entity;
            if (player.isSpectator() || (entity = player.getRootVehicle()) instanceof HappyGhast || !aabb1.contains(entity.position())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected BodyRotationControl createBodyControl() {
        return new HappyGhastBodyRotationControl();
    }

    @Override
    public boolean canBeCollidedWith(@Nullable Entity p_423679_) {
        if (!this.isBaby() && this.isAlive()) {
            if (this.level().isClientSide() && p_423679_ instanceof Player && p_423679_.position().y >= this.getBoundingBox().maxY) {
                return true;
            }
            return this.isVehicle() && p_423679_ instanceof HappyGhast ? true : this.isOnStillTimeout();
        }
        return false;
    }

    @Override
    public boolean isFlyingVehicle() {
        return !this.isBaby();
    }

    class HappyGhastLookControl
    extends LookControl {
        HappyGhastLookControl() {
            super(HappyGhast.this);
        }

        @Override
        public void tick() {
            if (HappyGhast.this.isOnStillTimeout()) {
                float f = HappyGhastLookControl.wrapDegrees90(HappyGhast.this.getYRot());
                HappyGhast.this.setYRot(HappyGhast.this.getYRot() - f);
                HappyGhast.this.setYHeadRot(HappyGhast.this.getYRot());
            } else if (this.lookAtCooldown > 0) {
                --this.lookAtCooldown;
                double d0 = this.wantedX - HappyGhast.this.getX();
                double d1 = this.wantedZ - HappyGhast.this.getZ();
                HappyGhast.this.setYRot(-((float)Mth.atan2(d0, d1)) * 57.295776f);
                HappyGhast.this.yHeadRot = HappyGhast.this.yBodyRot = HappyGhast.this.getYRot();
            } else {
                Ghast.faceMovementDirection(this.mob);
            }
        }

        public static float wrapDegrees90(float p_416435_) {
            float f = p_416435_ % 90.0f;
            if (f >= 45.0f) {
                f -= 90.0f;
            }
            if (f < -45.0f) {
                f += 90.0f;
            }
            return f;
        }
    }

    static class BabyFlyingPathNavigation
    extends FlyingPathNavigation {
        public BabyFlyingPathNavigation(HappyGhast p_416056_, Level p_416673_) {
            super(p_416056_, p_416673_);
            this.setCanOpenDoors(false);
            this.setCanFloat(true);
            this.setRequiredPathLength(48.0f);
        }

        @Override
        protected boolean canMoveDirectly(Vec3 p_415802_, Vec3 p_416007_) {
            return BabyFlyingPathNavigation.isClearForMovementBetween(this.mob, p_415802_, p_416007_, false);
        }
    }

    class HappyGhastFloatGoal
    extends FloatGoal {
        public HappyGhastFloatGoal() {
            super(HappyGhast.this);
        }

        @Override
        public boolean canUse() {
            return !HappyGhast.this.isOnStillTimeout() && super.canUse();
        }
    }

    class HappyGhastBodyRotationControl
    extends BodyRotationControl {
        public HappyGhastBodyRotationControl() {
            super(HappyGhast.this);
        }

        @Override
        public void clientTick() {
            if (HappyGhast.this.isVehicle()) {
                HappyGhast.this.yBodyRot = HappyGhast.this.yHeadRot = HappyGhast.this.getYRot();
            }
            super.clientTick();
        }
    }
}

