/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.animal.AbstractCow;
import net.minecraft.world.entity.animal.CowVariant;
import net.minecraft.world.entity.animal.CowVariants;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class Cow
extends AbstractCow {
    private static final EntityDataAccessor<Holder<CowVariant>> DATA_VARIANT_ID = SynchedEntityData.defineId(Cow.class, EntityDataSerializers.COW_VARIANT);

    public Cow(EntityType<? extends Cow> p_28285_, Level p_28286_) {
        super((EntityType<? extends AbstractCow>)p_28285_, p_28286_);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_401390_) {
        super.defineSynchedData(p_401390_);
        p_401390_.define(DATA_VARIANT_ID, VariantUtils.getDefaultOrAny(this.registryAccess(), CowVariants.TEMPERATE));
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput p_421958_) {
        super.addAdditionalSaveData(p_421958_);
        VariantUtils.writeVariant(p_421958_, this.getVariant());
    }

    @Override
    protected void readAdditionalSaveData(ValueInput p_422129_) {
        super.readAdditionalSaveData(p_422129_);
        VariantUtils.readVariant(p_422129_, Registries.COW_VARIANT).ifPresent(this::setVariant);
    }

    @Override
    @Nullable
    public Cow getBreedOffspring(ServerLevel p_148890_, AgeableMob p_148891_) {
        Cow cow = EntityType.COW.create(p_148890_, EntitySpawnReason.BREEDING);
        if (cow != null && p_148891_ instanceof Cow) {
            Cow cow1 = (Cow)p_148891_;
            cow.setVariant(this.random.nextBoolean() ? this.getVariant() : cow1.getVariant());
        }
        return cow;
    }

    @Override
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_401024_, DifficultyInstance p_401230_, EntitySpawnReason p_401413_, @Nullable SpawnGroupData p_401109_) {
        VariantUtils.selectVariantToSpawn(SpawnContext.create(p_401024_, this.blockPosition()), Registries.COW_VARIANT).ifPresent(this::setVariant);
        return super.finalizeSpawn(p_401024_, p_401230_, p_401413_, p_401109_);
    }

    public void setVariant(Holder<CowVariant> p_401019_) {
        this.entityData.set(DATA_VARIANT_ID, p_401019_);
    }

    public Holder<CowVariant> getVariant() {
        return this.entityData.get(DATA_VARIANT_ID);
    }

    @Override
    @Nullable
    public <T> T get(DataComponentType<? extends T> p_401147_) {
        return p_401147_ == DataComponents.COW_VARIANT ? Cow.castComponentValue(p_401147_, this.getVariant()) : super.get(p_401147_);
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter p_401126_) {
        this.applyImplicitComponentIfPresent(p_401126_, DataComponents.COW_VARIANT);
        super.applyImplicitComponents(p_401126_);
    }

    @Override
    protected <T> boolean applyImplicitComponent(DataComponentType<T> p_401334_, T p_401008_) {
        if (p_401334_ == DataComponents.COW_VARIANT) {
            this.setVariant(Cow.castComponentValue(DataComponents.COW_VARIANT, p_401008_));
            return true;
        }
        return super.applyImplicitComponent(p_401334_, p_401008_);
    }
}

