/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.ShoulderRidingEntity;

public class LandOnOwnersShoulderGoal
extends Goal {
    private final ShoulderRidingEntity entity;
    private boolean isSittingOnShoulder;

    public LandOnOwnersShoulderGoal(ShoulderRidingEntity p_25483_) {
        this.entity = p_25483_;
    }

    @Override
    public boolean canUse() {
        LivingEntity livingEntity = this.entity.getOwner();
        if (!(livingEntity instanceof ServerPlayer)) {
            return false;
        }
        ServerPlayer serverplayer = (ServerPlayer)livingEntity;
        boolean flag = !serverplayer.isSpectator() && !serverplayer.getAbilities().flying && !serverplayer.isInWater() && !serverplayer.isInPowderSnow;
        return !this.entity.isOrderedToSit() && flag && this.entity.canSitOnShoulder();
    }

    @Override
    public boolean isInterruptable() {
        return !this.isSittingOnShoulder;
    }

    @Override
    public void start() {
        this.isSittingOnShoulder = false;
    }

    @Override
    public void tick() {
        LivingEntity livingEntity;
        if (!this.isSittingOnShoulder && !this.entity.isInSittingPose() && !this.entity.isLeashed() && (livingEntity = this.entity.getOwner()) instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)livingEntity;
            if (this.entity.getBoundingBox().intersects(serverplayer.getBoundingBox())) {
                this.isSittingOnShoulder = this.entity.setEntityOnShoulder(serverplayer);
            }
        }
    }
}

