/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.control;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.Control;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MoveControl
implements Control {
    public static final float MIN_SPEED = 5.0E-4f;
    public static final float MIN_SPEED_SQR = 2.5000003E-7f;
    protected static final int MAX_TURN = 90;
    protected final Mob mob;
    protected double wantedX;
    protected double wantedY;
    protected double wantedZ;
    protected double speedModifier;
    protected float strafeForwards;
    protected float strafeRight;
    protected Operation operation = Operation.WAIT;

    public MoveControl(Mob p_24983_) {
        this.mob = p_24983_;
    }

    public boolean hasWanted() {
        return this.operation == Operation.MOVE_TO;
    }

    public double getSpeedModifier() {
        return this.speedModifier;
    }

    public void setWantedPosition(double p_24984_, double p_24985_, double p_24986_, double p_24987_) {
        this.wantedX = p_24984_;
        this.wantedY = p_24985_;
        this.wantedZ = p_24986_;
        this.speedModifier = p_24987_;
        if (this.operation != Operation.JUMPING) {
            this.operation = Operation.MOVE_TO;
        }
    }

    public void strafe(float p_24989_, float p_24990_) {
        this.operation = Operation.STRAFE;
        this.strafeForwards = p_24989_;
        this.strafeRight = p_24990_;
        this.speedModifier = 0.25;
    }

    public void tick() {
        if (this.operation == Operation.STRAFE) {
            float f8;
            float f = (float)this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED);
            float f1 = (float)this.speedModifier * f;
            float f2 = this.strafeForwards;
            float f3 = this.strafeRight;
            float f4 = Mth.sqrt(f2 * f2 + f3 * f3);
            if (f4 < 1.0f) {
                f4 = 1.0f;
            }
            f4 = f1 / f4;
            float f5 = Mth.sin(this.mob.getYRot() * ((float)Math.PI / 180));
            float f6 = Mth.cos(this.mob.getYRot() * ((float)Math.PI / 180));
            float f7 = (f2 *= f4) * f6 - (f3 *= f4) * f5;
            if (!this.isWalkable(f7, f8 = f3 * f6 + f2 * f5)) {
                this.strafeForwards = 1.0f;
                this.strafeRight = 0.0f;
            }
            this.mob.setSpeed(f1);
            this.mob.setZza(this.strafeForwards);
            this.mob.setXxa(this.strafeRight);
            this.operation = Operation.WAIT;
        } else if (this.operation == Operation.MOVE_TO) {
            this.operation = Operation.WAIT;
            double d0 = this.wantedX - this.mob.getX();
            double d1 = this.wantedZ - this.mob.getZ();
            double d2 = this.wantedY - this.mob.getY();
            double d3 = d0 * d0 + d2 * d2 + d1 * d1;
            if (d3 < 2.500000277905201E-7) {
                this.mob.setZza(0.0f);
                return;
            }
            float f9 = (float)(Mth.atan2(d1, d0) * 180.0 / 3.1415927410125732) - 90.0f;
            this.mob.setYRot(this.rotlerp(this.mob.getYRot(), f9, 90.0f));
            this.mob.setSpeed((float)(this.speedModifier * this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED)));
            BlockPos blockpos = this.mob.blockPosition();
            BlockState blockstate = this.mob.level().getBlockState(blockpos);
            VoxelShape voxelshape = blockstate.getCollisionShape(this.mob.level(), blockpos);
            if (d2 > (double)this.mob.maxUpStep() && d0 * d0 + d1 * d1 < (double)Math.max(1.0f, this.mob.getBbWidth()) || !voxelshape.isEmpty() && this.mob.getY() < voxelshape.max(Direction.Axis.Y) + (double)blockpos.getY() && !blockstate.is(BlockTags.DOORS) && !blockstate.is(BlockTags.FENCES)) {
                this.mob.getJumpControl().jump();
                this.operation = Operation.JUMPING;
            }
        } else if (this.operation == Operation.JUMPING) {
            this.mob.setSpeed((float)(this.speedModifier * this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED)));
            if (this.mob.onGround() || this.mob.isInLiquid() && this.mob.isAffectedByFluids()) {
                this.operation = Operation.WAIT;
            }
        } else {
            this.mob.setZza(0.0f);
        }
    }

    private boolean isWalkable(float p_24997_, float p_24998_) {
        NodeEvaluator nodeevaluator;
        PathNavigation pathnavigation = this.mob.getNavigation();
        return pathnavigation == null || (nodeevaluator = pathnavigation.getNodeEvaluator()) == null || nodeevaluator.getPathType(this.mob, BlockPos.containing(this.mob.getX() + (double)p_24997_, this.mob.getBlockY(), this.mob.getZ() + (double)p_24998_)) == PathType.WALKABLE;
    }

    protected float rotlerp(float p_24992_, float p_24993_, float p_24994_) {
        float f1;
        float f = Mth.wrapDegrees(p_24993_ - p_24992_);
        if (f > p_24994_) {
            f = p_24994_;
        }
        if (f < -p_24994_) {
            f = -p_24994_;
        }
        if ((f1 = p_24992_ + f) < 0.0f) {
            f1 += 360.0f;
        } else if (f1 > 360.0f) {
            f1 -= 360.0f;
        }
        return f1;
    }

    public double getWantedX() {
        return this.wantedX;
    }

    public double getWantedY() {
        return this.wantedY;
    }

    public double getWantedZ() {
        return this.wantedZ;
    }

    public void setWait() {
        this.operation = Operation.WAIT;
    }

    protected static enum Operation {
        WAIT,
        MOVE_TO,
        STRAFE,
        JUMPING;

    }
}

