/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior.declarative;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.kinds.Const;
import com.mojang.datafixers.kinds.IdF;
import com.mojang.datafixers.kinds.K1;
import com.mojang.datafixers.kinds.OptionalBox;
import com.mojang.datafixers.util.Function3;
import com.mojang.datafixers.util.Function4;
import com.mojang.datafixers.util.Unit;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.declarative.MemoryAccessor;
import net.minecraft.world.entity.ai.behavior.declarative.MemoryCondition;
import net.minecraft.world.entity.ai.behavior.declarative.Trigger;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;

public class BehaviorBuilder<E extends LivingEntity, M>
implements App<Mu<E>, M> {
    private final TriggerWithResult<E, M> trigger;

    public static <E extends LivingEntity, M> BehaviorBuilder<E, M> unbox(App<Mu<E>, M> p_259593_) {
        return (BehaviorBuilder)p_259593_;
    }

    public static <E extends LivingEntity> Instance<E> instance() {
        return new Instance();
    }

    public static <E extends LivingEntity> OneShot<E> create(Function<Instance<E>, ? extends App<Mu<E>, Trigger<E>>> p_259386_) {
        final TriggerWithResult<E, Trigger<E>> triggerwithresult = BehaviorBuilder.get(p_259386_.apply(BehaviorBuilder.instance()));
        return new OneShot<E>(){

            @Override
            public boolean trigger(ServerLevel p_259385_, E p_260003_, long p_259194_) {
                Trigger trigger = (Trigger)triggerwithresult.tryTrigger(p_259385_, p_260003_, p_259194_);
                return trigger == null ? false : trigger.trigger(p_259385_, p_260003_, p_259194_);
            }

            @Override
            public String debugString() {
                return "OneShot[" + triggerwithresult.debugString() + "]";
            }

            public String toString() {
                return this.debugString();
            }
        };
    }

    public static <E extends LivingEntity> OneShot<E> sequence(Trigger<? super E> p_260174_, Trigger<? super E> p_259134_) {
        return BehaviorBuilder.create((Instance<E> p_259495_) -> p_259495_.group(p_259495_.ifTriggered(p_260174_)).apply((Applicative)p_259495_, p_260322_ -> p_259134_::trigger));
    }

    public static <E extends LivingEntity> OneShot<E> triggerIf(Predicate<E> p_260059_, OneShot<? super E> p_259640_) {
        return BehaviorBuilder.sequence(BehaviorBuilder.triggerIf(p_260059_), p_259640_);
    }

    public static <E extends LivingEntity> OneShot<E> triggerIf(Predicate<E> p_260112_) {
        return BehaviorBuilder.create((Instance<E> p_260353_) -> p_260353_.point((p_259280_, p_259428_, p_259845_) -> p_260112_.test(p_259428_)));
    }

    public static <E extends LivingEntity> OneShot<E> triggerIf(BiPredicate<ServerLevel, E> p_259227_) {
        return BehaviorBuilder.create((Instance<E> p_260191_) -> p_260191_.point((p_259079_, p_259093_, p_260140_) -> p_259227_.test(p_259079_, p_259093_)));
    }

    static <E extends LivingEntity, M> TriggerWithResult<E, M> get(App<Mu<E>, M> p_259615_) {
        return BehaviorBuilder.unbox(p_259615_).trigger;
    }

    BehaviorBuilder(TriggerWithResult<E, M> p_260164_) {
        this.trigger = p_260164_;
    }

    static <E extends LivingEntity, M> BehaviorBuilder<E, M> create(TriggerWithResult<E, M> p_259575_) {
        return new BehaviorBuilder<E, M>(p_259575_);
    }

    public static final class Instance<E extends LivingEntity>
    implements Applicative<net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder$Mu<E>, Mu<E>> {
        public <Value> Optional<Value> tryGet(MemoryAccessor<OptionalBox.Mu, Value> p_259352_) {
            return OptionalBox.unbox(p_259352_.value());
        }

        public <Value> Value get(MemoryAccessor<IdF.Mu, Value> p_259206_) {
            return (Value)IdF.get(p_259206_.value());
        }

        public <Value> BehaviorBuilder<E, MemoryAccessor<OptionalBox.Mu, Value>> registered(MemoryModuleType<Value> p_259477_) {
            return new PureMemory(new MemoryCondition.Registered<Value>(p_259477_));
        }

        public <Value> BehaviorBuilder<E, MemoryAccessor<IdF.Mu, Value>> present(MemoryModuleType<Value> p_259673_) {
            return new PureMemory(new MemoryCondition.Present<Value>(p_259673_));
        }

        public <Value> BehaviorBuilder<E, MemoryAccessor<Const.Mu<Unit>, Value>> absent(MemoryModuleType<Value> p_260198_) {
            return new PureMemory(new MemoryCondition.Absent<Value>(p_260198_));
        }

        public BehaviorBuilder<E, Unit> ifTriggered(Trigger<? super E> p_260247_) {
            return new TriggerWrapper<E>(p_260247_);
        }

        public <A> BehaviorBuilder<E, A> point(A p_259634_) {
            return new Constant(p_259634_);
        }

        public <A> BehaviorBuilder<E, A> point(Supplier<String> p_260070_, A p_260295_) {
            return new Constant(p_260295_, p_260070_);
        }

        public <A, R> Function<App<net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder$Mu<E>, A>, App<net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder$Mu<E>, R>> lift1(App<net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder$Mu<E>, Function<A, R>> p_259294_) {
            return p_259751_ -> {
                final TriggerWithResult triggerwithresult = BehaviorBuilder.get(p_259751_);
                final TriggerWithResult triggerwithresult1 = BehaviorBuilder.get(p_259294_);
                return BehaviorBuilder.create(new TriggerWithResult<E, R>(){

                    @Override
                    public R tryTrigger(ServerLevel p_259603_, E p_260233_, long p_259654_) {
                        Object a = triggerwithresult.tryTrigger(p_259603_, p_260233_, p_259654_);
                        if (a == null) {
                            return null;
                        }
                        Function function = (Function)triggerwithresult1.tryTrigger(p_259603_, p_260233_, p_259654_);
                        return function == null ? null : (Object)function.apply(a);
                    }

                    @Override
                    public String debugString() {
                        return triggerwithresult1.debugString() + " * " + triggerwithresult.debugString();
                    }

                    public String toString() {
                        return this.debugString();
                    }
                });
            };
        }

        public <T, R> BehaviorBuilder<E, R> map(final Function<? super T, ? extends R> p_259963_, App<net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder$Mu<E>, T> p_260355_) {
            final TriggerWithResult<E, T> triggerwithresult = BehaviorBuilder.get(p_260355_);
            return BehaviorBuilder.create(new TriggerWithResult<E, R>(){

                @Override
                public R tryTrigger(ServerLevel p_259755_, E p_259656_, long p_259300_) {
                    Object t = triggerwithresult.tryTrigger(p_259755_, p_259656_, p_259300_);
                    return t == null ? null : (Object)p_259963_.apply(t);
                }

                @Override
                public String debugString() {
                    return triggerwithresult.debugString() + ".map[" + String.valueOf(p_259963_) + "]";
                }

                public String toString() {
                    return this.debugString();
                }
            });
        }

        public <A, B, R> BehaviorBuilder<E, R> ap2(App<net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder$Mu<E>, BiFunction<A, B, R>> p_259535_, App<net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder$Mu<E>, A> p_259162_, App<net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder$Mu<E>, B> p_259733_) {
            final TriggerWithResult<E, A> triggerwithresult = BehaviorBuilder.get(p_259162_);
            final TriggerWithResult<E, B> triggerwithresult1 = BehaviorBuilder.get(p_259733_);
            final TriggerWithResult<E, BiFunction<A, B, R>> triggerwithresult2 = BehaviorBuilder.get(p_259535_);
            return BehaviorBuilder.create(new TriggerWithResult<E, R>(){

                @Override
                public R tryTrigger(ServerLevel p_259274_, E p_259817_, long p_259820_) {
                    Object a = triggerwithresult.tryTrigger(p_259274_, p_259817_, p_259820_);
                    if (a == null) {
                        return null;
                    }
                    Object b = triggerwithresult1.tryTrigger(p_259274_, p_259817_, p_259820_);
                    if (b == null) {
                        return null;
                    }
                    BiFunction bifunction = (BiFunction)triggerwithresult2.tryTrigger(p_259274_, p_259817_, p_259820_);
                    return bifunction == null ? null : (Object)bifunction.apply(a, b);
                }

                @Override
                public String debugString() {
                    return triggerwithresult2.debugString() + " * " + triggerwithresult.debugString() + " * " + triggerwithresult1.debugString();
                }

                public String toString() {
                    return this.debugString();
                }
            });
        }

        public <T1, T2, T3, R> BehaviorBuilder<E, R> ap3(App<net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder$Mu<E>, Function3<T1, T2, T3, R>> p_260239_, App<net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder$Mu<E>, T1> p_259239_, App<net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder$Mu<E>, T2> p_259638_, App<net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder$Mu<E>, T3> p_259969_) {
            final TriggerWithResult<E, T1> triggerwithresult = BehaviorBuilder.get(p_259239_);
            final TriggerWithResult<E, T2> triggerwithresult1 = BehaviorBuilder.get(p_259638_);
            final TriggerWithResult<E, T3> triggerwithresult2 = BehaviorBuilder.get(p_259969_);
            final TriggerWithResult<E, Function3<T1, T2, T3, R>> triggerwithresult3 = BehaviorBuilder.get(p_260239_);
            return BehaviorBuilder.create(new TriggerWithResult<E, R>(){

                @Override
                public R tryTrigger(ServerLevel p_259096_, E p_260221_, long p_259035_) {
                    Object t1 = triggerwithresult.tryTrigger(p_259096_, p_260221_, p_259035_);
                    if (t1 == null) {
                        return null;
                    }
                    Object t2 = triggerwithresult1.tryTrigger(p_259096_, p_260221_, p_259035_);
                    if (t2 == null) {
                        return null;
                    }
                    Object t3 = triggerwithresult2.tryTrigger(p_259096_, p_260221_, p_259035_);
                    if (t3 == null) {
                        return null;
                    }
                    Function3 function3 = (Function3)triggerwithresult3.tryTrigger(p_259096_, p_260221_, p_259035_);
                    return function3 == null ? null : function3.apply(t1, t2, t3);
                }

                @Override
                public String debugString() {
                    return triggerwithresult3.debugString() + " * " + triggerwithresult.debugString() + " * " + triggerwithresult1.debugString() + " * " + triggerwithresult2.debugString();
                }

                public String toString() {
                    return this.debugString();
                }
            });
        }

        public <T1, T2, T3, T4, R> BehaviorBuilder<E, R> ap4(App<net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder$Mu<E>, Function4<T1, T2, T3, T4, R>> p_259519_, App<net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder$Mu<E>, T1> p_259829_, App<net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder$Mu<E>, T2> p_259314_, App<net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder$Mu<E>, T3> p_260089_, App<net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder$Mu<E>, T4> p_259136_) {
            final TriggerWithResult<E, T1> triggerwithresult = BehaviorBuilder.get(p_259829_);
            final TriggerWithResult<E, T2> triggerwithresult1 = BehaviorBuilder.get(p_259314_);
            final TriggerWithResult<E, T3> triggerwithresult2 = BehaviorBuilder.get(p_260089_);
            final TriggerWithResult<E, T4> triggerwithresult3 = BehaviorBuilder.get(p_259136_);
            final TriggerWithResult<E, Function4<T1, T2, T3, T4, R>> triggerwithresult4 = BehaviorBuilder.get(p_259519_);
            return BehaviorBuilder.create(new TriggerWithResult<E, R>(){

                @Override
                public R tryTrigger(ServerLevel p_259537_, E p_259581_, long p_259423_) {
                    Object t1 = triggerwithresult.tryTrigger(p_259537_, p_259581_, p_259423_);
                    if (t1 == null) {
                        return null;
                    }
                    Object t2 = triggerwithresult1.tryTrigger(p_259537_, p_259581_, p_259423_);
                    if (t2 == null) {
                        return null;
                    }
                    Object t3 = triggerwithresult2.tryTrigger(p_259537_, p_259581_, p_259423_);
                    if (t3 == null) {
                        return null;
                    }
                    Object t4 = triggerwithresult3.tryTrigger(p_259537_, p_259581_, p_259423_);
                    if (t4 == null) {
                        return null;
                    }
                    Function4 function4 = (Function4)triggerwithresult4.tryTrigger(p_259537_, p_259581_, p_259423_);
                    return function4 == null ? null : function4.apply(t1, t2, t3, t4);
                }

                @Override
                public String debugString() {
                    return triggerwithresult4.debugString() + " * " + triggerwithresult.debugString() + " * " + triggerwithresult1.debugString() + " * " + triggerwithresult2.debugString() + " * " + triggerwithresult3.debugString();
                }

                public String toString() {
                    return this.debugString();
                }
            });
        }

        static final class Mu<E extends LivingEntity>
        implements Applicative.Mu {
            private Mu() {
            }
        }
    }

    static interface TriggerWithResult<E extends LivingEntity, R> {
        @Nullable
        public R tryTrigger(ServerLevel var1, E var2, long var3);

        public String debugString();
    }

    static final class TriggerWrapper<E extends LivingEntity>
    extends BehaviorBuilder<E, Unit> {
        TriggerWrapper(final Trigger<? super E> p_259310_) {
            super(new TriggerWithResult<E, Unit>(){

                @Override
                @Nullable
                public Unit tryTrigger(ServerLevel p_259397_, E p_260169_, long p_259155_) {
                    return p_259310_.trigger(p_259397_, p_260169_, p_259155_) ? Unit.INSTANCE : null;
                }

                @Override
                public String debugString() {
                    return "T[" + String.valueOf(p_259310_) + "]";
                }
            });
        }
    }

    static final class PureMemory<E extends LivingEntity, F extends K1, Value>
    extends BehaviorBuilder<E, MemoryAccessor<F, Value>> {
        PureMemory(final MemoryCondition<F, Value> p_259776_) {
            super(new TriggerWithResult<E, MemoryAccessor<F, Value>>(){

                @Override
                public MemoryAccessor<F, Value> tryTrigger(ServerLevel p_259899_, E p_259558_, long p_259793_) {
                    Brain<?> brain = ((LivingEntity)p_259558_).getBrain();
                    Optional optional = brain.getMemoryInternal(p_259776_.memory());
                    return optional == null ? null : p_259776_.createAccessor(brain, optional);
                }

                @Override
                public String debugString() {
                    return "M[" + String.valueOf(p_259776_) + "]";
                }

                public String toString() {
                    return this.debugString();
                }
            });
        }
    }

    public static final class Mu<E extends LivingEntity>
    implements K1 {
    }

    static final class Constant<E extends LivingEntity, A>
    extends BehaviorBuilder<E, A> {
        Constant(A p_259906_) {
            this(p_259906_, () -> "C[" + String.valueOf(p_259906_) + "]");
        }

        Constant(final A p_259514_, final Supplier<String> p_259950_) {
            super(new TriggerWithResult<E, A>(){

                @Override
                public A tryTrigger(ServerLevel p_259561_, E p_259467_, long p_259297_) {
                    return p_259514_;
                }

                @Override
                public String debugString() {
                    return (String)p_259950_.get();
                }

                public String toString() {
                    return this.debugString();
                }
            });
        }
    }
}

