/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;

public class LookAndFollowTradingPlayerSink
extends Behavior<Villager> {
    private final float speedModifier;

    public LookAndFollowTradingPlayerSink(float p_23434_) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.REGISTERED)), Integer.MAX_VALUE);
        this.speedModifier = p_23434_;
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel p_23445_, Villager p_23446_) {
        Player player = p_23446_.getTradingPlayer();
        return p_23446_.isAlive() && player != null && !p_23446_.isInWater() && !p_23446_.hurtMarked && p_23446_.distanceToSqr(player) <= 16.0 && player.containerMenu != null;
    }

    @Override
    protected boolean canStillUse(ServerLevel p_23448_, Villager p_23449_, long p_23450_) {
        return this.checkExtraStartConditions(p_23448_, p_23449_);
    }

    @Override
    protected void start(ServerLevel p_23458_, Villager p_23459_, long p_23460_) {
        this.followPlayer(p_23459_);
    }

    @Override
    protected void stop(ServerLevel p_23466_, Villager p_23467_, long p_23468_) {
        Brain<Villager> brain = p_23467_.getBrain();
        brain.eraseMemory(MemoryModuleType.WALK_TARGET);
        brain.eraseMemory(MemoryModuleType.LOOK_TARGET);
    }

    @Override
    protected void tick(ServerLevel p_23474_, Villager p_23475_, long p_23476_) {
        this.followPlayer(p_23475_);
    }

    @Override
    protected boolean timedOut(long p_23436_) {
        return false;
    }

    private void followPlayer(Villager p_23452_) {
        Brain<Villager> brain = p_23452_.getBrain();
        brain.setMemory(MemoryModuleType.WALK_TARGET, new WalkTarget(new EntityTracker(p_23452_.getTradingPlayer(), false), this.speedModifier, 2));
        brain.setMemory(MemoryModuleType.LOOK_TARGET, new EntityTracker(p_23452_.getTradingPlayer(), true));
    }
}

