/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;

public class AnimalPanic<E extends PathfinderMob>
extends Behavior<E> {
    private static final int PANIC_MIN_DURATION = 100;
    private static final int PANIC_MAX_DURATION = 120;
    private static final int PANIC_DISTANCE_HORIZONTAL = 5;
    private static final int PANIC_DISTANCE_VERTICAL = 4;
    private final float speedMultiplier;
    private final Function<PathfinderMob, TagKey<DamageType>> panicCausingDamageTypes;
    private final Function<E, Vec3> positionGetter;

    public AnimalPanic(float p_147385_) {
        this(p_147385_, p_349992_ -> DamageTypeTags.PANIC_CAUSES, p_415099_ -> LandRandomPos.getPos(p_415099_, 5, 4));
    }

    public AnimalPanic(float p_416201_, int p_416512_) {
        this(p_416201_, p_415100_ -> DamageTypeTags.PANIC_CAUSES, p_415102_ -> AirAndWaterRandomPos.getPos(p_415102_, 5, 4, p_416512_, p_415102_.getViewVector((float)0.0f).x, p_415102_.getViewVector((float)0.0f).z, 1.5707963705062866));
    }

    public AnimalPanic(float p_275357_, Function<PathfinderMob, TagKey<DamageType>> p_350957_) {
        this(p_275357_, p_350957_, p_415098_ -> LandRandomPos.getPos(p_415098_, 5, 4));
    }

    public AnimalPanic(float p_415539_, Function<PathfinderMob, TagKey<DamageType>> p_415969_, Function<E, Vec3> p_415777_) {
        super(Map.of(MemoryModuleType.IS_PANICKING, MemoryStatus.REGISTERED, MemoryModuleType.HURT_BY, MemoryStatus.REGISTERED), 100, 120);
        this.speedMultiplier = p_415539_;
        this.panicCausingDamageTypes = p_415969_;
        this.positionGetter = p_415777_;
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel p_275286_, E p_275721_) {
        return ((LivingEntity)p_275721_).getBrain().getMemory(MemoryModuleType.HURT_BY).map(p_349994_ -> p_349994_.is(this.panicCausingDamageTypes.apply((PathfinderMob)p_275721_))).orElse(false) != false || ((LivingEntity)p_275721_).getBrain().hasMemoryValue(MemoryModuleType.IS_PANICKING);
    }

    @Override
    protected boolean canStillUse(ServerLevel p_147391_, E p_147392_, long p_147393_) {
        return true;
    }

    @Override
    protected void start(ServerLevel p_147399_, E p_147400_, long p_147401_) {
        ((LivingEntity)p_147400_).getBrain().setMemory(MemoryModuleType.IS_PANICKING, true);
        ((LivingEntity)p_147400_).getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        ((Mob)p_147400_).getNavigation().stop();
    }

    @Override
    protected void stop(ServerLevel p_217118_, E p_217119_, long p_217120_) {
        Brain<?> brain = ((LivingEntity)p_217119_).getBrain();
        brain.eraseMemory(MemoryModuleType.IS_PANICKING);
    }

    @Override
    protected void tick(ServerLevel p_147403_, E p_147404_, long p_147405_) {
        Vec3 vec3;
        if (((Mob)p_147404_).getNavigation().isDone() && (vec3 = this.getPanicPos(p_147404_, p_147403_)) != null) {
            ((LivingEntity)p_147404_).getBrain().setMemory(MemoryModuleType.WALK_TARGET, new WalkTarget(vec3, this.speedMultiplier, 0));
        }
    }

    @Nullable
    private Vec3 getPanicPos(E p_196639_, ServerLevel p_196640_) {
        Optional<Vec3> optional;
        if (((Entity)p_196639_).isOnFire() && (optional = this.lookForWater(p_196640_, (Entity)p_196639_).map(Vec3::atBottomCenterOf)).isPresent()) {
            return optional.get();
        }
        return this.positionGetter.apply(p_196639_);
    }

    private Optional<BlockPos> lookForWater(BlockGetter p_196642_, Entity p_196643_) {
        BlockPos blockpos = p_196643_.blockPosition();
        if (!p_196642_.getBlockState(blockpos).getCollisionShape(p_196642_, blockpos).isEmpty()) {
            return Optional.empty();
        }
        Predicate<BlockPos> predicate = Mth.ceil(p_196643_.getBbWidth()) == 2 ? p_284705_ -> BlockPos.squareOutSouthEast(p_284705_).allMatch(p_196646_ -> p_196642_.getFluidState((BlockPos)p_196646_).is(FluidTags.WATER)) : p_284707_ -> p_196642_.getFluidState((BlockPos)p_284707_).is(FluidTags.WATER);
        return BlockPos.findClosestMatch(blockpos, 5, 1, predicate);
    }
}

