/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.attributes;

import com.mojang.serialization.Codec;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.neoforged.neoforge.common.extensions.IAttributeExtension;

public class Attribute
implements IAttributeExtension {
    public static final Codec<Holder<Attribute>> CODEC = BuiltInRegistries.ATTRIBUTE.holderByNameCodec();
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<Attribute>> STREAM_CODEC = ByteBufCodecs.holderRegistry(Registries.ATTRIBUTE);
    private final double defaultValue;
    private boolean syncable;
    private final String descriptionId;
    private Sentiment sentiment = Sentiment.POSITIVE;
    protected static final TextColor MERGED_RED = TextColor.fromRgb(16331057);
    protected static final TextColor MERGED_BLUE = TextColor.fromRgb(8026873);
    protected static final TextColor MERGED_GRAY = TextColor.fromRgb(0xCCCCCC);

    protected Attribute(String p_22080_, double p_22081_) {
        this.defaultValue = p_22081_;
        this.descriptionId = p_22080_;
    }

    public double getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isClientSyncable() {
        return this.syncable;
    }

    public Attribute setSyncable(boolean p_22085_) {
        this.syncable = p_22085_;
        return this;
    }

    public Attribute setSentiment(Sentiment p_347714_) {
        this.sentiment = p_347714_;
        return this;
    }

    public double sanitizeValue(double p_22083_) {
        return p_22083_;
    }

    public String getDescriptionId() {
        return this.descriptionId;
    }

    public ChatFormatting getStyle(boolean p_347715_) {
        return this.sentiment.getStyle(p_347715_);
    }

    public TextColor getMergedStyle(boolean isPositive) {
        return switch (this.sentiment.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (isPositive) {
                    yield MERGED_BLUE;
                }
                yield MERGED_RED;
            }
            case 2 -> {
                if (isPositive) {
                    yield MERGED_RED;
                }
                yield MERGED_BLUE;
            }
            case 1 -> MERGED_GRAY;
        };
    }

    public static enum Sentiment {
        POSITIVE,
        NEUTRAL,
        NEGATIVE;


        public ChatFormatting getStyle(boolean p_347500_) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    if (p_347500_) {
                        yield ChatFormatting.BLUE;
                    }
                    yield ChatFormatting.RED;
                }
                case 1 -> ChatFormatting.GRAY;
                case 2 -> p_347500_ ? ChatFormatting.RED : ChatFormatting.BLUE;
            };
        }
    }
}

