/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;

public interface SpawnPlacementTypes {
    public static final SpawnPlacementType NO_RESTRICTIONS = (p_321554_, p_321832_, p_321540_) -> true;
    public static final SpawnPlacementType IN_WATER = (p_425271_, p_425272_, p_425273_) -> {
        if (p_425273_ != null && p_425271_.getWorldBorder().isWithinBounds(p_425272_)) {
            BlockPos blockpos = p_425272_.above();
            return p_425271_.getFluidState(p_425272_).is(FluidTags.WATER) && !p_425271_.getBlockState(blockpos).isRedstoneConductor(p_425271_, blockpos);
        }
        return false;
    };
    public static final SpawnPlacementType IN_LAVA = (p_425274_, p_425275_, p_425276_) -> p_425276_ != null && p_425274_.getWorldBorder().isWithinBounds(p_425275_) ? p_425274_.getFluidState(p_425275_).is(FluidTags.LAVA) : false;
    public static final SpawnPlacementType ON_GROUND = new SpawnPlacementType(){

        @Override
        public boolean isSpawnPositionOk(LevelReader p_321666_, BlockPos p_321783_, @Nullable EntityType<?> p_321839_) {
            if (p_321839_ != null && p_321666_.getWorldBorder().isWithinBounds(p_321783_)) {
                BlockPos blockpos = p_321783_.above();
                BlockPos blockpos1 = p_321783_.below();
                BlockState blockstate = p_321666_.getBlockState(blockpos1);
                return !blockstate.isValidSpawn(p_321666_, blockpos1, p_321839_) ? false : this.isValidEmptySpawnBlock(p_321666_, p_321783_, p_321839_) && this.isValidEmptySpawnBlock(p_321666_, blockpos, p_321839_);
            }
            return false;
        }

        private boolean isValidEmptySpawnBlock(LevelReader p_321512_, BlockPos p_321822_, EntityType<?> p_321785_) {
            BlockState blockstate = p_321512_.getBlockState(p_321822_);
            return NaturalSpawner.isValidEmptySpawnBlock(p_321512_, p_321822_, blockstate, blockstate.getFluidState(), p_321785_);
        }

        @Override
        public BlockPos adjustSpawnPosition(LevelReader p_321527_, BlockPos p_321602_) {
            BlockPos blockpos = p_321602_.below();
            return p_321527_.getBlockState(blockpos).isPathfindable(PathComputationType.LAND) ? blockpos : p_321602_;
        }
    };
}

