/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.Container;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.DropChances;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentTable;
import net.minecraft.world.entity.EquipmentUser;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.Targeting;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.JumpControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.sensing.Sensing;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.providers.VanillaEnchantmentProviders;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.ticks.ContainerSingleItem;
import net.neoforged.neoforge.attachment.AttachmentHolder;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.ApiStatus;

public abstract class Mob
extends LivingEntity
implements EquipmentUser,
Leashable,
Targeting {
    private static final EntityDataAccessor<Byte> DATA_MOB_FLAGS_ID = SynchedEntityData.defineId(Mob.class, EntityDataSerializers.BYTE);
    private static final int MOB_FLAG_NO_AI = 1;
    private static final int MOB_FLAG_LEFTHANDED = 2;
    private static final int MOB_FLAG_AGGRESSIVE = 4;
    protected static final int PICKUP_REACH = 1;
    private static final Vec3i ITEM_PICKUP_REACH = new Vec3i(1, 0, 1);
    private static final List<EquipmentSlot> EQUIPMENT_POPULATION_ORDER = List.of(EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET);
    public static final float MAX_WEARING_ARMOR_CHANCE = 0.15f;
    public static final float MAX_PICKUP_LOOT_CHANCE = 0.55f;
    public static final float MAX_ENCHANTED_ARMOR_CHANCE = 0.5f;
    public static final float MAX_ENCHANTED_WEAPON_CHANCE = 0.25f;
    public static final int UPDATE_GOAL_SELECTOR_EVERY_N_TICKS = 2;
    private static final double DEFAULT_ATTACK_REACH = Math.sqrt(2.04f) - (double)0.6f;
    private static final boolean DEFAULT_CAN_PICK_UP_LOOT = false;
    private static final boolean DEFAULT_PERSISTENCE_REQUIRED = false;
    private static final boolean DEFAULT_LEFT_HANDED = false;
    private static final boolean DEFAULT_NO_AI = false;
    protected static final ResourceLocation RANDOM_SPAWN_BONUS_ID = ResourceLocation.withDefaultNamespace("random_spawn_bonus");
    public static final String TAG_DROP_CHANCES = "drop_chances";
    public static final String TAG_LEFT_HANDED = "LeftHanded";
    public static final String TAG_CAN_PICK_UP_LOOT = "CanPickUpLoot";
    public static final String TAG_NO_AI = "NoAI";
    public int ambientSoundTime;
    protected int xpReward;
    protected LookControl lookControl;
    protected MoveControl moveControl;
    protected JumpControl jumpControl;
    private final BodyRotationControl bodyRotationControl;
    protected PathNavigation navigation;
    public final GoalSelector goalSelector;
    public final GoalSelector targetSelector;
    @Nullable
    private LivingEntity target;
    private final Sensing sensing;
    private DropChances dropChances = DropChances.DEFAULT;
    private boolean canPickUpLoot = false;
    private boolean persistenceRequired = false;
    private final Map<PathType, Float> pathfindingMalus = Maps.newEnumMap(PathType.class);
    private Optional<ResourceKey<LootTable>> lootTable = Optional.empty();
    private long lootTableSeed;
    @Nullable
    private Leashable.LeashData leashData;
    private BlockPos homePosition = BlockPos.ZERO;
    private int homeRadius = -1;
    @Nullable
    private EntitySpawnReason spawnType;
    private boolean spawnCancelled = false;
    protected boolean preventConversionSpawns = false;

    protected Mob(EntityType<? extends Mob> p_21368_, Level p_21369_) {
        super((EntityType<? extends LivingEntity>)p_21368_, p_21369_);
        this.goalSelector = new GoalSelector();
        this.targetSelector = new GoalSelector();
        this.lookControl = new LookControl(this);
        this.moveControl = new MoveControl(this);
        this.jumpControl = new JumpControl(this);
        this.bodyRotationControl = this.createBodyControl();
        this.navigation = this.createNavigation(p_21369_);
        this.sensing = new Sensing(this);
        if (p_21369_ instanceof ServerLevel) {
            this.registerGoals();
        }
    }

    protected void registerGoals() {
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.FOLLOW_RANGE, 16.0);
    }

    protected PathNavigation createNavigation(Level p_21480_) {
        return new GroundPathNavigation(this, p_21480_);
    }

    protected boolean shouldPassengersInheritMalus() {
        return false;
    }

    public float getPathfindingMalus(PathType p_326934_) {
        Mob mob1;
        Entity entity = this.getControlledVehicle();
        Mob mob = entity instanceof Mob && (mob1 = (Mob)entity).shouldPassengersInheritMalus() ? mob1 : this;
        Float f = mob.pathfindingMalus.get((Object)p_326934_);
        return f == null ? p_326934_.getMalus() : f.floatValue();
    }

    public void setPathfindingMalus(PathType p_326826_, float p_21443_) {
        this.pathfindingMalus.put(p_326826_, Float.valueOf(p_21443_));
    }

    public void onPathfindingStart() {
    }

    public void onPathfindingDone() {
    }

    protected BodyRotationControl createBodyControl() {
        return new BodyRotationControl(this);
    }

    public LookControl getLookControl() {
        return this.lookControl;
    }

    public MoveControl getMoveControl() {
        MoveControl moveControl;
        Entity entity = this.getControlledVehicle();
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            moveControl = mob.getMoveControl();
        } else {
            moveControl = this.moveControl;
        }
        return moveControl;
    }

    public JumpControl getJumpControl() {
        return this.jumpControl;
    }

    public PathNavigation getNavigation() {
        PathNavigation pathNavigation;
        Entity entity = this.getControlledVehicle();
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            pathNavigation = mob.getNavigation();
        } else {
            pathNavigation = this.navigation;
        }
        return pathNavigation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public LivingEntity getControllingPassenger() {
        Entity entity = this.getFirstPassenger();
        if (this.isNoAi()) return null;
        if (!(entity instanceof Mob)) return null;
        Mob mob = (Mob)entity;
        if (!entity.canControlVehicle()) return null;
        Mob mob2 = mob;
        return mob2;
    }

    public Sensing getSensing() {
        return this.sensing;
    }

    @Override
    @Nullable
    public LivingEntity getTarget() {
        return this.target;
    }

    @Nullable
    protected final LivingEntity getTargetFromBrain() {
        return this.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
    }

    public void setTarget(@Nullable LivingEntity p_21544_) {
        LivingChangeTargetEvent changeTargetEvent = CommonHooks.onLivingChangeTarget((LivingEntity)this, (LivingEntity)p_21544_, (LivingChangeTargetEvent.ILivingTargetType)LivingChangeTargetEvent.LivingTargetType.MOB_TARGET);
        if (!changeTargetEvent.isCanceled()) {
            this.target = changeTargetEvent.getNewAboutToBeSetTarget();
        }
    }

    @Override
    public boolean canAttackType(EntityType<?> p_21399_) {
        return p_21399_ != EntityType.GHAST;
    }

    public boolean canFireProjectileWeapon(ProjectileWeaponItem p_21430_) {
        return false;
    }

    public void ate() {
        this.gameEvent(GameEvent.EAT);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_326499_) {
        super.defineSynchedData(p_326499_);
        p_326499_.define(DATA_MOB_FLAGS_ID, (byte)0);
    }

    public int getAmbientSoundInterval() {
        return 80;
    }

    public void playAmbientSound() {
        this.makeSound(this.getAmbientSound());
    }

    @Override
    public void baseTick() {
        super.baseTick();
        ProfilerFiller profilerfiller = Profiler.get();
        profilerfiller.push("mobBaseTick");
        if (this.isAlive() && this.random.nextInt(1000) < this.ambientSoundTime++) {
            this.resetAmbientSoundTime();
            this.playAmbientSound();
        }
        profilerfiller.pop();
    }

    @Override
    protected void playHurtSound(DamageSource p_21493_) {
        this.resetAmbientSoundTime();
        super.playHurtSound(p_21493_);
    }

    private void resetAmbientSoundTime() {
        this.ambientSoundTime = -this.getAmbientSoundInterval();
    }

    @Override
    protected int getBaseExperienceReward(ServerLevel p_376894_) {
        if (this.xpReward > 0) {
            int i = this.xpReward;
            for (EquipmentSlot equipmentslot : EquipmentSlot.VALUES) {
                ItemStack itemstack;
                if (!equipmentslot.canIncreaseExperience() || (itemstack = this.getItemBySlot(equipmentslot)).isEmpty() || !(this.dropChances.byEquipment(equipmentslot) <= 1.0f)) continue;
                i += 1 + this.random.nextInt(3);
            }
            return i;
        }
        return this.xpReward;
    }

    public void spawnAnim() {
        if (this.level().isClientSide) {
            this.makePoofParticles();
        } else {
            this.level().broadcastEntityEvent(this, (byte)20);
        }
    }

    @Override
    public void handleEntityEvent(byte p_21375_) {
        if (p_21375_ == 20) {
            this.spawnAnim();
        } else {
            super.handleEntityEvent(p_21375_);
        }
    }

    @Override
    public void tick() {
        ItemStack stack;
        super.tick();
        if (!this.level().isClientSide && this.tickCount % 5 == 0) {
            this.updateControlFlags();
        }
        if (this.canUseSlot(EquipmentSlot.BODY) && (stack = this.getBodyArmorItem()).has(DataComponents.EQUIPPABLE)) {
            stack.onAnimalArmorTick(this.level(), this);
        }
    }

    protected void updateControlFlags() {
        boolean flag = !(this.getControllingPassenger() instanceof Mob);
        boolean flag1 = !(this.getVehicle() instanceof AbstractBoat);
        this.goalSelector.setControlFlag(Goal.Flag.MOVE, flag);
        this.goalSelector.setControlFlag(Goal.Flag.JUMP, flag && flag1);
        this.goalSelector.setControlFlag(Goal.Flag.LOOK, flag);
    }

    @Override
    protected void tickHeadTurn(float p_21538_) {
        this.bodyRotationControl.clientTick();
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return null;
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput p_421640_) {
        super.addAdditionalSaveData(p_421640_);
        p_421640_.putBoolean(TAG_CAN_PICK_UP_LOOT, this.canPickUpLoot());
        p_421640_.putBoolean("PersistenceRequired", this.persistenceRequired);
        if (!this.dropChances.equals(DropChances.DEFAULT)) {
            p_421640_.store(TAG_DROP_CHANCES, DropChances.CODEC, this.dropChances);
        }
        this.writeLeashData(p_421640_, this.leashData);
        if (this.hasHome()) {
            p_421640_.putInt("home_radius", this.homeRadius);
            p_421640_.store("home_pos", BlockPos.CODEC, this.homePosition);
        }
        p_421640_.putBoolean(TAG_LEFT_HANDED, this.isLeftHanded());
        this.lootTable.ifPresent(p_421366_ -> p_421640_.store("DeathLootTable", LootTable.KEY_CODEC, p_421366_));
        if (this.lootTableSeed != 0L) {
            p_421640_.putLong("DeathLootTableSeed", this.lootTableSeed);
        }
        if (this.isNoAi()) {
            p_421640_.putBoolean(TAG_NO_AI, this.isNoAi());
        }
        if (this.spawnType != null) {
            p_421640_.putString("neoforge:spawn_type", this.spawnType.name());
        }
    }

    @Override
    protected void readAdditionalSaveData(ValueInput p_422339_) {
        super.readAdditionalSaveData(p_422339_);
        this.setCanPickUpLoot(p_422339_.getBooleanOr(TAG_CAN_PICK_UP_LOOT, false));
        this.persistenceRequired = p_422339_.getBooleanOr("PersistenceRequired", false);
        this.dropChances = p_422339_.read(TAG_DROP_CHANCES, DropChances.CODEC).orElse(DropChances.DEFAULT);
        this.readLeashData(p_422339_);
        this.homeRadius = p_422339_.getIntOr("home_radius", -1);
        if (this.homeRadius >= 0) {
            this.homePosition = p_422339_.read("home_pos", BlockPos.CODEC).orElse(BlockPos.ZERO);
        }
        this.setLeftHanded(p_422339_.getBooleanOr(TAG_LEFT_HANDED, false));
        this.lootTable = p_422339_.read("DeathLootTable", LootTable.KEY_CODEC);
        this.lootTableSeed = p_422339_.getLongOr("DeathLootTableSeed", 0L);
        this.setNoAi(p_422339_.getBooleanOr(TAG_NO_AI, false));
        p_422339_.getString("neoforge:spawn_type").ifPresent(spawnType -> {
            try {
                this.spawnType = EntitySpawnReason.valueOf(spawnType);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    @Override
    protected void dropFromLootTable(ServerLevel p_376326_, DamageSource p_21389_, boolean p_21390_) {
        super.dropFromLootTable(p_376326_, p_21389_, p_21390_);
        this.lootTable = Optional.empty();
    }

    @Override
    public final Optional<ResourceKey<LootTable>> getLootTable() {
        return this.lootTable.isPresent() ? this.lootTable : super.getLootTable();
    }

    @Override
    public long getLootTableSeed() {
        return this.lootTableSeed;
    }

    public void setZza(float p_21565_) {
        this.zza = p_21565_;
    }

    public void setYya(float p_21568_) {
        this.yya = p_21568_;
    }

    public void setXxa(float p_21571_) {
        this.xxa = p_21571_;
    }

    @Override
    public void setSpeed(float p_21556_) {
        super.setSpeed(p_21556_);
        this.setZza(p_21556_);
    }

    public void stopInPlace() {
        this.getNavigation().stop();
        this.setXxa(0.0f);
        this.setYya(0.0f);
        this.setSpeed(0.0f);
        this.setDeltaMovement(0.0, 0.0, 0.0);
        this.resetAngularLeashMomentum();
    }

    @Override
    public void aiStep() {
        super.aiStep();
        ProfilerFiller profilerfiller = Profiler.get();
        profilerfiller.push("looting");
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            if (this.canPickUpLoot() && this.isAlive() && !this.dead && EventHooks.canEntityGrief((ServerLevel)serverlevel, (Entity)this)) {
                Vec3i vec3i = this.getPickupReach();
                for (ItemEntity itementity : this.level().getEntitiesOfClass(ItemEntity.class, this.getBoundingBox().inflate(vec3i.getX(), vec3i.getY(), vec3i.getZ()))) {
                    if (itementity.isRemoved() || itementity.getItem().isEmpty() || itementity.hasPickUpDelay() || !this.wantsToPickUp(serverlevel, itementity.getItem())) continue;
                    this.pickUpItem(serverlevel, itementity);
                }
            }
        }
        profilerfiller.pop();
    }

    protected Vec3i getPickupReach() {
        return ITEM_PICKUP_REACH;
    }

    protected void pickUpItem(ServerLevel p_376779_, ItemEntity p_21471_) {
        ItemStack itemstack = p_21471_.getItem();
        ItemStack itemstack1 = this.equipItemIfPossible(p_376779_, itemstack.copy());
        if (!itemstack1.isEmpty()) {
            this.onItemPickup(p_21471_);
            this.take(p_21471_, itemstack1.getCount());
            itemstack.shrink(itemstack1.getCount());
            if (itemstack.isEmpty()) {
                p_21471_.discard();
            }
        }
    }

    public ItemStack equipItemIfPossible(ServerLevel p_376644_, ItemStack p_255842_) {
        EquipmentSlot equipmentslot = this.getEquipmentSlotForItem(p_255842_);
        if (!this.isEquippableInSlot(p_255842_, equipmentslot)) {
            return ItemStack.EMPTY;
        }
        ItemStack itemstack = this.getItemBySlot(equipmentslot);
        boolean flag = this.canReplaceCurrentItem(p_255842_, itemstack, equipmentslot);
        if (equipmentslot.isArmor() && !flag) {
            equipmentslot = EquipmentSlot.MAINHAND;
            itemstack = this.getItemBySlot(equipmentslot);
            flag = itemstack.isEmpty();
        }
        if (flag && this.canHoldItem(p_255842_)) {
            double d0 = this.dropChances.byEquipment(equipmentslot);
            if (!itemstack.isEmpty() && (double)Math.max(this.random.nextFloat() - 0.1f, 0.0f) < d0) {
                this.spawnAtLocation(p_376644_, itemstack);
            }
            ItemStack itemstack1 = equipmentslot.limit(p_255842_);
            this.setItemSlotAndDropWhenKilled(equipmentslot, itemstack1);
            return itemstack1;
        }
        return ItemStack.EMPTY;
    }

    protected void setItemSlotAndDropWhenKilled(EquipmentSlot p_21469_, ItemStack p_21470_) {
        this.setItemSlot(p_21469_, p_21470_);
        this.setGuaranteedDrop(p_21469_);
        this.persistenceRequired = true;
    }

    protected boolean canShearEquipment(Player p_426143_) {
        return !this.isVehicle();
    }

    public void setGuaranteedDrop(EquipmentSlot p_21509_) {
        this.dropChances = this.dropChances.withGuaranteedDrop(p_21509_);
    }

    protected boolean canReplaceCurrentItem(ItemStack p_21428_, ItemStack p_21429_, EquipmentSlot p_371540_) {
        if (p_21429_.isEmpty()) {
            return true;
        }
        if (p_371540_.isArmor()) {
            return this.compareArmor(p_21428_, p_21429_, p_371540_);
        }
        return p_371540_ == EquipmentSlot.MAINHAND ? this.compareWeapons(p_21428_, p_21429_, p_371540_) : false;
    }

    private boolean compareArmor(ItemStack p_388622_, ItemStack p_388471_, EquipmentSlot p_386926_) {
        if (EnchantmentHelper.has(p_388471_, EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE)) {
            return false;
        }
        double d0 = this.getApproximateAttributeWith(p_388622_, Attributes.ARMOR, p_386926_);
        double d1 = this.getApproximateAttributeWith(p_388471_, Attributes.ARMOR, p_386926_);
        double d2 = this.getApproximateAttributeWith(p_388622_, Attributes.ARMOR_TOUGHNESS, p_386926_);
        double d3 = this.getApproximateAttributeWith(p_388471_, Attributes.ARMOR_TOUGHNESS, p_386926_);
        if (d0 != d1) {
            return d0 > d1;
        }
        return d2 != d3 ? d2 > d3 : this.canReplaceEqualItem(p_388622_, p_388471_);
    }

    private boolean compareWeapons(ItemStack p_386619_, ItemStack p_387764_, EquipmentSlot p_387859_) {
        double d1;
        double d0;
        TagKey<Item> tagkey = this.getPreferredWeaponType();
        if (tagkey != null) {
            if (p_387764_.is(tagkey) && !p_386619_.is(tagkey)) {
                return false;
            }
            if (!p_387764_.is(tagkey) && p_386619_.is(tagkey)) {
                return true;
            }
        }
        return (d0 = this.getApproximateAttributeWith(p_386619_, Attributes.ATTACK_DAMAGE, p_387859_)) != (d1 = this.getApproximateAttributeWith(p_387764_, Attributes.ATTACK_DAMAGE, p_387859_)) ? d0 > d1 : this.canReplaceEqualItem(p_386619_, p_387764_);
    }

    private double getApproximateAttributeWith(ItemStack p_371461_, Holder<Attribute> p_371421_, EquipmentSlot p_371891_) {
        double d0 = this.getAttributes().hasAttribute(p_371421_) ? this.getAttributeBaseValue(p_371421_) : 0.0;
        ItemAttributeModifiers itemattributemodifiers = p_371461_.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, ItemAttributeModifiers.EMPTY);
        itemattributemodifiers = p_371461_.getAttributeModifiers();
        return itemattributemodifiers.compute(d0, p_371891_);
    }

    public boolean canReplaceEqualItem(ItemStack p_21478_, ItemStack p_21479_) {
        int j;
        Set<Object2IntMap.Entry<Holder<Enchantment>>> set = p_21479_.getOrDefault(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY).entrySet();
        Set<Object2IntMap.Entry<Holder<Enchantment>>> set1 = p_21478_.getOrDefault(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY).entrySet();
        if (set1.size() != set.size()) {
            return set1.size() > set.size();
        }
        int i = p_21478_.getDamageValue();
        return i != (j = p_21479_.getDamageValue()) ? i < j : p_21478_.has(DataComponents.CUSTOM_NAME) && !p_21479_.has(DataComponents.CUSTOM_NAME);
    }

    public boolean canHoldItem(ItemStack p_21545_) {
        return true;
    }

    public boolean wantsToPickUp(ServerLevel p_376139_, ItemStack p_21546_) {
        return this.canHoldItem(p_21546_);
    }

    @Nullable
    public TagKey<Item> getPreferredWeaponType() {
        return null;
    }

    public boolean removeWhenFarAway(double p_21542_) {
        return true;
    }

    public boolean requiresCustomPersistence() {
        return this.isPassenger();
    }

    protected boolean shouldDespawnInPeaceful() {
        return false;
    }

    @Override
    public void checkDespawn() {
        if (EventHooks.checkMobDespawn((Mob)this)) {
            return;
        }
        if (this.level().getDifficulty() == Difficulty.PEACEFUL && this.shouldDespawnInPeaceful()) {
            this.discard();
        } else if (!this.isPersistenceRequired() && !this.requiresCustomPersistence()) {
            Player entity = this.level().getNearestPlayer(this, -1.0);
            if (entity != null) {
                int i;
                int j;
                double d0 = entity.distanceToSqr(this);
                if (d0 > (double)(j = (i = this.getType().getCategory().getDespawnDistance()) * i) && this.removeWhenFarAway(d0)) {
                    this.discard();
                }
                int k = this.getType().getCategory().getNoDespawnDistance();
                int l = k * k;
                if (this.noActionTime > 600 && this.random.nextInt(800) == 0 && d0 > (double)l && this.removeWhenFarAway(d0)) {
                    this.discard();
                } else if (d0 < (double)l) {
                    this.noActionTime = 0;
                }
            }
        } else {
            this.noActionTime = 0;
        }
    }

    @Override
    protected final void serverAiStep() {
        ++this.noActionTime;
        ProfilerFiller profilerfiller = Profiler.get();
        profilerfiller.push("sensing");
        this.sensing.tick();
        profilerfiller.pop();
        int i = this.tickCount + this.getId();
        if (i % 2 != 0 && this.tickCount > 1) {
            profilerfiller.push("targetSelector");
            this.targetSelector.tickRunningGoals(false);
            profilerfiller.pop();
            profilerfiller.push("goalSelector");
            this.goalSelector.tickRunningGoals(false);
            profilerfiller.pop();
        } else {
            profilerfiller.push("targetSelector");
            this.targetSelector.tick();
            profilerfiller.pop();
            profilerfiller.push("goalSelector");
            this.goalSelector.tick();
            profilerfiller.pop();
        }
        profilerfiller.push("navigation");
        this.navigation.tick();
        profilerfiller.pop();
        profilerfiller.push("mob tick");
        this.customServerAiStep((ServerLevel)this.level());
        profilerfiller.pop();
        profilerfiller.push("controls");
        profilerfiller.push("move");
        this.moveControl.tick();
        profilerfiller.popPush("look");
        this.lookControl.tick();
        profilerfiller.popPush("jump");
        this.jumpControl.tick();
        profilerfiller.pop();
        profilerfiller.pop();
        this.sendDebugPackets();
    }

    protected void sendDebugPackets() {
        DebugPackets.sendGoalSelector(this.level(), this, this.goalSelector);
    }

    protected void customServerAiStep(ServerLevel p_376725_) {
    }

    public int getMaxHeadXRot() {
        return 40;
    }

    public int getMaxHeadYRot() {
        return 75;
    }

    protected void clampHeadRotationToBody() {
        float f = this.getMaxHeadYRot();
        float f1 = this.getYHeadRot();
        float f2 = Mth.wrapDegrees(this.yBodyRot - f1);
        float f3 = Mth.clamp(Mth.wrapDegrees(this.yBodyRot - f1), -f, f);
        float f4 = f1 + f2 - f3;
        this.setYHeadRot(f4);
    }

    public int getHeadRotSpeed() {
        return 10;
    }

    public void lookAt(Entity p_21392_, float p_21393_, float p_21394_) {
        double d1;
        double d0 = p_21392_.getX() - this.getX();
        double d2 = p_21392_.getZ() - this.getZ();
        if (p_21392_ instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)p_21392_;
            d1 = livingentity.getEyeY() - this.getEyeY();
        } else {
            d1 = (p_21392_.getBoundingBox().minY + p_21392_.getBoundingBox().maxY) / 2.0 - this.getEyeY();
        }
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        float f = (float)(Mth.atan2(d2, d0) * 180.0 / 3.1415927410125732) - 90.0f;
        float f1 = (float)(-(Mth.atan2(d1, d3) * 180.0 / 3.1415927410125732));
        this.setXRot(this.rotlerp(this.getXRot(), f1, p_21394_));
        this.setYRot(this.rotlerp(this.getYRot(), f, p_21393_));
    }

    private float rotlerp(float p_21377_, float p_21378_, float p_21379_) {
        float f = Mth.wrapDegrees(p_21378_ - p_21377_);
        if (f > p_21379_) {
            f = p_21379_;
        }
        if (f < -p_21379_) {
            f = -p_21379_;
        }
        return p_21377_ + f;
    }

    public static boolean checkMobSpawnRules(EntityType<? extends Mob> p_217058_, LevelAccessor p_217059_, EntitySpawnReason p_365247_, BlockPos p_217061_, RandomSource p_217062_) {
        BlockPos blockpos = p_217061_.below();
        return EntitySpawnReason.isSpawner(p_365247_) || p_217059_.getBlockState(blockpos).isValidSpawn(p_217059_, blockpos, p_217058_);
    }

    public boolean checkSpawnRules(LevelAccessor p_21431_, EntitySpawnReason p_360512_) {
        return true;
    }

    public boolean checkSpawnObstruction(LevelReader p_21433_) {
        return !p_21433_.containsAnyLiquid(this.getBoundingBox()) && p_21433_.isUnobstructed(this);
    }

    public int getMaxSpawnClusterSize() {
        return 4;
    }

    public boolean isMaxGroupSizeReached(int p_21489_) {
        return false;
    }

    @Override
    public int getMaxFallDistance() {
        if (this.getTarget() == null) {
            return this.getComfortableFallDistance(0.0f);
        }
        int i = (int)(this.getHealth() - this.getMaxHealth() * 0.33f);
        if ((i -= (3 - this.level().getDifficulty().getId()) * 4) < 0) {
            i = 0;
        }
        return this.getComfortableFallDistance(i);
    }

    public ItemStack getBodyArmorItem() {
        return this.getItemBySlot(EquipmentSlot.BODY);
    }

    public boolean isSaddled() {
        return this.hasValidEquippableItemForSlot(EquipmentSlot.SADDLE);
    }

    public boolean isWearingBodyArmor() {
        return this.hasValidEquippableItemForSlot(EquipmentSlot.BODY);
    }

    private boolean hasValidEquippableItemForSlot(EquipmentSlot p_419938_) {
        return this.hasItemInSlot(p_419938_) && this.isEquippableInSlot(this.getItemBySlot(p_419938_), p_419938_);
    }

    public void setBodyArmorItem(ItemStack p_323721_) {
        this.setItemSlotAndDropWhenKilled(EquipmentSlot.BODY, p_323721_);
    }

    public Container createEquipmentSlotContainer(final EquipmentSlot p_397086_) {
        return new ContainerSingleItem(){

            @Override
            public ItemStack getTheItem() {
                return Mob.this.getItemBySlot(p_397086_);
            }

            @Override
            public void setTheItem(ItemStack p_396982_) {
                Mob.this.setItemSlot(p_397086_, p_396982_);
                if (!p_396982_.isEmpty()) {
                    Mob.this.setGuaranteedDrop(p_397086_);
                    Mob.this.setPersistenceRequired();
                }
            }

            @Override
            public void setChanged() {
            }

            @Override
            public boolean stillValid(Player p_397156_) {
                return p_397156_.getVehicle() == Mob.this || p_397156_.canInteractWithEntity(Mob.this, 4.0);
            }
        };
    }

    @Override
    protected void dropCustomDeathLoot(ServerLevel p_348683_, DamageSource p_21385_, boolean p_21387_) {
        super.dropCustomDeathLoot(p_348683_, p_21385_, p_21387_);
        for (EquipmentSlot equipmentslot : EquipmentSlot.VALUES) {
            ItemStack itemstack = this.getItemBySlot(equipmentslot);
            float f = this.dropChances.byEquipment(equipmentslot);
            if (f == 0.0f) continue;
            boolean flag = this.dropChances.isPreserved(equipmentslot);
            AttachmentHolder attachmentHolder = p_21385_.getEntity();
            if (attachmentHolder instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)attachmentHolder;
                attachmentHolder = this.level();
                if (attachmentHolder instanceof ServerLevel) {
                    ServerLevel serverlevel = (ServerLevel)attachmentHolder;
                    f = EnchantmentHelper.processEquipmentDropChance(serverlevel, livingentity, p_21385_, f);
                }
            }
            if (itemstack.isEmpty() || EnchantmentHelper.has(itemstack, EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP) || !p_21387_ && !flag || !(this.random.nextFloat() < f)) continue;
            if (!flag && itemstack.isDamageableItem()) {
                itemstack.setDamageValue(itemstack.getMaxDamage() - this.random.nextInt(1 + this.random.nextInt(Math.max(itemstack.getMaxDamage() - 3, 1))));
            }
            this.spawnAtLocation(p_348683_, itemstack);
            this.setItemSlot(equipmentslot, ItemStack.EMPTY);
        }
    }

    public DropChances getDropChances() {
        return this.dropChances;
    }

    public void dropPreservedEquipment(ServerLevel p_376214_) {
        this.dropPreservedEquipment(p_376214_, p_352412_ -> true);
    }

    public Set<EquipmentSlot> dropPreservedEquipment(ServerLevel p_376128_, Predicate<ItemStack> p_352191_) {
        HashSet<EquipmentSlot> set = new HashSet<EquipmentSlot>();
        for (EquipmentSlot equipmentslot : EquipmentSlot.VALUES) {
            ItemStack itemstack = this.getItemBySlot(equipmentslot);
            if (itemstack.isEmpty()) continue;
            if (!p_352191_.test(itemstack)) {
                set.add(equipmentslot);
                continue;
            }
            if (!this.dropChances.isPreserved(equipmentslot)) continue;
            this.setItemSlot(equipmentslot, ItemStack.EMPTY);
            this.spawnAtLocation(p_376128_, itemstack);
        }
        return set;
    }

    private LootParams createEquipmentParams(ServerLevel p_338758_) {
        return new LootParams.Builder(p_338758_).withParameter(LootContextParams.ORIGIN, this.position()).withParameter(LootContextParams.THIS_ENTITY, this).create(LootContextParamSets.EQUIPMENT);
    }

    public void equip(EquipmentTable p_341198_) {
        this.equip(p_341198_.lootTable(), p_341198_.slotDropChances());
    }

    public void equip(ResourceKey<LootTable> p_340912_, Map<EquipmentSlot, Float> p_340996_) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            this.equip(p_340912_, this.createEquipmentParams(serverlevel), p_340996_);
        }
    }

    protected void populateDefaultEquipmentSlots(RandomSource p_217055_, DifficultyInstance p_217056_) {
        if (p_217055_.nextFloat() < 0.15f * p_217056_.getSpecialMultiplier()) {
            float f;
            int i = p_217055_.nextInt(2);
            float f2 = f = this.level().getDifficulty() == Difficulty.HARD ? 0.1f : 0.25f;
            if (p_217055_.nextFloat() < 0.095f) {
                ++i;
            }
            if (p_217055_.nextFloat() < 0.095f) {
                ++i;
            }
            if (p_217055_.nextFloat() < 0.095f) {
                ++i;
            }
            boolean flag = true;
            for (EquipmentSlot equipmentslot : EQUIPMENT_POPULATION_ORDER) {
                Item item;
                ItemStack itemstack = this.getItemBySlot(equipmentslot);
                if (!flag && p_217055_.nextFloat() < f) break;
                flag = false;
                if (!itemstack.isEmpty() || (item = Mob.getEquipmentForSlot(equipmentslot, i)) == null) continue;
                this.setItemSlot(equipmentslot, new ItemStack(item));
            }
        }
    }

    @Nullable
    public static Item getEquipmentForSlot(EquipmentSlot p_21413_, int p_21414_) {
        switch (p_21413_) {
            case HEAD: {
                if (p_21414_ == 0) {
                    return Items.LEATHER_HELMET;
                }
                if (p_21414_ == 1) {
                    return Items.GOLDEN_HELMET;
                }
                if (p_21414_ == 2) {
                    return Items.CHAINMAIL_HELMET;
                }
                if (p_21414_ == 3) {
                    return Items.IRON_HELMET;
                }
                if (p_21414_ == 4) {
                    return Items.DIAMOND_HELMET;
                }
            }
            case CHEST: {
                if (p_21414_ == 0) {
                    return Items.LEATHER_CHESTPLATE;
                }
                if (p_21414_ == 1) {
                    return Items.GOLDEN_CHESTPLATE;
                }
                if (p_21414_ == 2) {
                    return Items.CHAINMAIL_CHESTPLATE;
                }
                if (p_21414_ == 3) {
                    return Items.IRON_CHESTPLATE;
                }
                if (p_21414_ == 4) {
                    return Items.DIAMOND_CHESTPLATE;
                }
            }
            case LEGS: {
                if (p_21414_ == 0) {
                    return Items.LEATHER_LEGGINGS;
                }
                if (p_21414_ == 1) {
                    return Items.GOLDEN_LEGGINGS;
                }
                if (p_21414_ == 2) {
                    return Items.CHAINMAIL_LEGGINGS;
                }
                if (p_21414_ == 3) {
                    return Items.IRON_LEGGINGS;
                }
                if (p_21414_ == 4) {
                    return Items.DIAMOND_LEGGINGS;
                }
            }
            case FEET: {
                if (p_21414_ == 0) {
                    return Items.LEATHER_BOOTS;
                }
                if (p_21414_ == 1) {
                    return Items.GOLDEN_BOOTS;
                }
                if (p_21414_ == 2) {
                    return Items.CHAINMAIL_BOOTS;
                }
                if (p_21414_ == 3) {
                    return Items.IRON_BOOTS;
                }
                if (p_21414_ != 4) break;
                return Items.DIAMOND_BOOTS;
            }
        }
        return null;
    }

    protected void populateDefaultEquipmentEnchantments(ServerLevelAccessor p_348529_, RandomSource p_217063_, DifficultyInstance p_217064_) {
        this.enchantSpawnedWeapon(p_348529_, p_217063_, p_217064_);
        for (EquipmentSlot equipmentslot : EquipmentSlot.VALUES) {
            if (equipmentslot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR) continue;
            this.enchantSpawnedArmor(p_348529_, p_217063_, equipmentslot, p_217064_);
        }
    }

    protected void enchantSpawnedWeapon(ServerLevelAccessor p_348685_, RandomSource p_217049_, DifficultyInstance p_348671_) {
        this.enchantSpawnedEquipment(p_348685_, EquipmentSlot.MAINHAND, p_217049_, 0.25f, p_348671_);
    }

    protected void enchantSpawnedArmor(ServerLevelAccessor p_348675_, RandomSource p_217052_, EquipmentSlot p_217054_, DifficultyInstance p_348681_) {
        this.enchantSpawnedEquipment(p_348675_, p_217054_, p_217052_, 0.5f, p_348681_);
    }

    private void enchantSpawnedEquipment(ServerLevelAccessor p_348676_, EquipmentSlot p_345506_, RandomSource p_345779_, float p_345423_, DifficultyInstance p_348488_) {
        ItemStack itemstack = this.getItemBySlot(p_345506_);
        if (!itemstack.isEmpty() && p_345779_.nextFloat() < p_345423_ * p_348488_.getSpecialMultiplier()) {
            EnchantmentHelper.enchantItemFromProvider(itemstack, p_348676_.registryAccess(), VanillaEnchantmentProviders.MOB_SPAWN_EQUIPMENT, p_348488_, p_345779_);
            this.setItemSlot(p_345506_, itemstack);
        }
    }

    @Deprecated
    @Nullable
    @ApiStatus.OverrideOnly
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_21434_, DifficultyInstance p_21435_, EntitySpawnReason p_363352_, @Nullable SpawnGroupData p_21437_) {
        RandomSource randomsource = p_21434_.getRandom();
        AttributeInstance attributeinstance = Objects.requireNonNull(this.getAttribute(Attributes.FOLLOW_RANGE));
        if (!attributeinstance.hasModifier(RANDOM_SPAWN_BONUS_ID)) {
            attributeinstance.addPermanentModifier(new AttributeModifier(RANDOM_SPAWN_BONUS_ID, randomsource.triangle(0.0, 0.11485000000000001), AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        }
        this.setLeftHanded(randomsource.nextFloat() < 0.05f);
        this.spawnType = p_363352_;
        return p_21437_;
    }

    public void setPersistenceRequired() {
        this.persistenceRequired = true;
    }

    @Override
    public void setDropChance(EquipmentSlot p_21410_, float p_21411_) {
        this.dropChances = this.dropChances.withEquipmentChance(p_21410_, p_21411_);
    }

    @Override
    public boolean canPickUpLoot() {
        return this.canPickUpLoot;
    }

    public void setCanPickUpLoot(boolean p_21554_) {
        this.canPickUpLoot = p_21554_;
    }

    @Override
    protected boolean canDispenserEquipIntoSlot(EquipmentSlot p_371241_) {
        return this.canPickUpLoot();
    }

    public boolean isPersistenceRequired() {
        return this.persistenceRequired;
    }

    @Override
    public final InteractionResult interact(Player p_21420_, InteractionHand p_21421_) {
        if (!this.isAlive()) {
            return InteractionResult.PASS;
        }
        InteractionResult interactionresult = this.checkAndHandleImportantInteractions(p_21420_, p_21421_);
        if (interactionresult.consumesAction()) {
            this.gameEvent(GameEvent.ENTITY_INTERACT, p_21420_);
            return interactionresult;
        }
        InteractionResult interactionresult1 = super.interact(p_21420_, p_21421_);
        if (interactionresult1 != InteractionResult.PASS) {
            return interactionresult1;
        }
        interactionresult = this.mobInteract(p_21420_, p_21421_);
        if (interactionresult.consumesAction()) {
            this.gameEvent(GameEvent.ENTITY_INTERACT, p_21420_);
            return interactionresult;
        }
        return InteractionResult.PASS;
    }

    private InteractionResult checkAndHandleImportantInteractions(Player p_21500_, InteractionHand p_21501_) {
        InteractionResult interactionresult;
        ItemStack itemstack = p_21500_.getItemInHand(p_21501_);
        if (itemstack.is(Items.NAME_TAG) && (interactionresult = itemstack.interactLivingEntity(p_21500_, this, p_21501_)).consumesAction()) {
            return interactionresult;
        }
        if (itemstack.getItem() instanceof SpawnEggItem) {
            if (this.level() instanceof ServerLevel) {
                SpawnEggItem spawneggitem = (SpawnEggItem)itemstack.getItem();
                Optional<Mob> optional = spawneggitem.spawnOffspringFromSpawnEgg(p_21500_, this, this.getType(), (ServerLevel)this.level(), this.position(), itemstack);
                optional.ifPresent(p_21476_ -> this.onOffspringSpawnedFromEgg(p_21500_, (Mob)p_21476_));
                if (optional.isEmpty()) {
                    return InteractionResult.PASS;
                }
            }
            return InteractionResult.SUCCESS_SERVER;
        }
        return InteractionResult.PASS;
    }

    protected void onOffspringSpawnedFromEgg(Player p_21422_, Mob p_21423_) {
    }

    protected InteractionResult mobInteract(Player p_21472_, InteractionHand p_21473_) {
        return InteractionResult.PASS;
    }

    public boolean isWithinHome() {
        return this.isWithinHome(this.blockPosition());
    }

    public boolean isWithinHome(BlockPos p_421748_) {
        return this.homeRadius == -1 ? true : this.homePosition.distSqr(p_421748_) < (double)(this.homeRadius * this.homeRadius);
    }

    public boolean isWithinHome(Vec3 p_422590_) {
        return this.homeRadius == -1 ? true : this.homePosition.distToCenterSqr(p_422590_) < (double)(this.homeRadius * this.homeRadius);
    }

    public void setHomeTo(BlockPos p_421733_, int p_422119_) {
        this.homePosition = p_421733_;
        this.homeRadius = p_422119_;
    }

    public BlockPos getHomePosition() {
        return this.homePosition;
    }

    public int getHomeRadius() {
        return this.homeRadius;
    }

    public void clearHome() {
        this.homeRadius = -1;
    }

    public boolean hasHome() {
        return this.homeRadius != -1;
    }

    @Nullable
    public <T extends Mob> T convertTo(EntityType<T> p_21407_, ConversionParams p_371709_, EntitySpawnReason p_371281_, ConversionParams.AfterConversion<T> p_371266_) {
        Level level;
        if (this.isRemoved()) {
            return null;
        }
        Mob t = (Mob)p_21407_.create(this.level(), p_371281_);
        if (t == null) {
            return null;
        }
        p_371709_.type().convert(this, t, p_371709_);
        p_371266_.finalizeConversion(t);
        if (!this.preventConversionSpawns && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            serverlevel.addFreshEntity(t);
        }
        if (p_371709_.type().shouldDiscardAfterConversion()) {
            this.discard();
        }
        return (T)t;
    }

    @Nullable
    public <T extends Mob> T convertTo(EntityType<T> p_371496_, ConversionParams p_371476_, ConversionParams.AfterConversion<T> p_371861_) {
        return this.convertTo(p_371496_, p_371476_, EntitySpawnReason.CONVERSION, p_371861_);
    }

    @Override
    @Nullable
    public Leashable.LeashData getLeashData() {
        return this.leashData;
    }

    private void resetAngularLeashMomentum() {
        if (this.leashData != null) {
            this.leashData.angularMomentum = 0.0;
        }
    }

    @Override
    public void setLeashData(@Nullable Leashable.LeashData p_352221_) {
        this.leashData = p_352221_;
    }

    @Override
    public void onLeashRemoved() {
        if (this.getLeashData() == null) {
            this.clearHome();
        }
    }

    @Override
    public void leashTooFarBehaviour() {
        Leashable.super.leashTooFarBehaviour();
        this.goalSelector.disableControlFlag(Goal.Flag.MOVE);
    }

    @Override
    public boolean canBeLeashed() {
        return !(this instanceof Enemy);
    }

    @Override
    public boolean startRiding(Entity p_21396_, boolean p_21397_) {
        boolean flag = super.startRiding(p_21396_, p_21397_);
        if (flag && this.isLeashed()) {
            this.dropLeash();
        }
        return flag;
    }

    @Override
    public boolean isEffectiveAi() {
        return super.isEffectiveAi() && !this.isNoAi();
    }

    public void setNoAi(boolean p_21558_) {
        byte b0 = this.entityData.get(DATA_MOB_FLAGS_ID);
        this.entityData.set(DATA_MOB_FLAGS_ID, p_21558_ ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE));
    }

    public void setLeftHanded(boolean p_21560_) {
        byte b0 = this.entityData.get(DATA_MOB_FLAGS_ID);
        this.entityData.set(DATA_MOB_FLAGS_ID, p_21560_ ? (byte)(b0 | 2) : (byte)(b0 & 0xFFFFFFFD));
    }

    public void setAggressive(boolean p_21562_) {
        byte b0 = this.entityData.get(DATA_MOB_FLAGS_ID);
        this.entityData.set(DATA_MOB_FLAGS_ID, p_21562_ ? (byte)(b0 | 4) : (byte)(b0 & 0xFFFFFFFB));
    }

    public boolean isNoAi() {
        return (this.entityData.get(DATA_MOB_FLAGS_ID) & 1) != 0;
    }

    public boolean isLeftHanded() {
        return (this.entityData.get(DATA_MOB_FLAGS_ID) & 2) != 0;
    }

    public boolean isAggressive() {
        return (this.entityData.get(DATA_MOB_FLAGS_ID) & 4) != 0;
    }

    public void setBaby(boolean p_21451_) {
    }

    @Override
    public HumanoidArm getMainArm() {
        return this.isLeftHanded() ? HumanoidArm.LEFT : HumanoidArm.RIGHT;
    }

    public boolean isWithinMeleeAttackRange(LivingEntity p_217067_) {
        return this.getAttackBoundingBox().intersects(p_217067_.getHitbox());
    }

    protected AABB getAttackBoundingBox() {
        AABB aabb;
        Entity entity = this.getVehicle();
        if (entity != null) {
            AABB aabb1 = entity.getBoundingBox();
            AABB aabb2 = this.getBoundingBox();
            aabb = new AABB(Math.min(aabb2.minX, aabb1.minX), aabb2.minY, Math.min(aabb2.minZ, aabb1.minZ), Math.max(aabb2.maxX, aabb1.maxX), aabb2.maxY, Math.max(aabb2.maxZ, aabb1.maxZ));
        } else {
            aabb = this.getBoundingBox();
        }
        return aabb.inflate(DEFAULT_ATTACK_REACH, 0.0, DEFAULT_ATTACK_REACH);
    }

    @Override
    public boolean doHurtTarget(ServerLevel p_376642_, Entity p_21372_) {
        boolean flag;
        float f = (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE);
        ItemStack itemstack = this.getWeaponItem();
        DamageSource damagesource = Optional.ofNullable(itemstack.getItem().getDamageSource(this)).orElse(this.damageSources().mobAttack(this));
        f = EnchantmentHelper.modifyDamage(p_376642_, itemstack, p_21372_, damagesource, f);
        if (flag = p_21372_.hurtServer(p_376642_, damagesource, f += itemstack.getItem().getAttackDamageBonus(p_21372_, f, damagesource))) {
            float f1 = this.getKnockback(p_21372_, damagesource);
            if (f1 > 0.0f && p_21372_ instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)p_21372_;
                livingentity.knockback(f1 * 0.5f, Mth.sin(this.getYRot() * ((float)Math.PI / 180)), -Mth.cos(this.getYRot() * ((float)Math.PI / 180)));
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.6, 1.0, 0.6));
            }
            if (p_21372_ instanceof LivingEntity) {
                LivingEntity livingentity1 = (LivingEntity)p_21372_;
                itemstack.hurtEnemy(livingentity1, this);
            }
            EnchantmentHelper.doPostAttackEffects(p_376642_, p_21372_, damagesource);
            this.setLastHurtMob(p_21372_);
            this.playAttackSound();
        }
        return flag;
    }

    protected void playAttackSound() {
    }

    protected boolean isSunBurnTick() {
        if (this.level().isBrightOutside() && !this.level().isClientSide) {
            boolean flag;
            float f = this.getLightLevelDependentMagicValue();
            BlockPos blockpos = BlockPos.containing(this.getX(), this.getEyeY(), this.getZ());
            boolean bl = flag = this.isInWaterOrRain() || this.isInPowderSnow || this.wasInPowderSnow;
            if (f > 0.5f && this.random.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && !flag && this.level().canSeeSky(blockpos)) {
                return true;
            }
        }
        return false;
    }

    @Override
    @Deprecated
    protected void jumpInLiquid(TagKey<Fluid> p_204045_) {
        this.jumpInLiquidInternal(() -> super.jumpInLiquid(p_204045_));
    }

    private void jumpInLiquidInternal(Runnable onSuper) {
        if (this.getNavigation().canFloat()) {
            onSuper.run();
        } else {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.3, 0.0));
        }
    }

    public void jumpInFluid(FluidType type) {
        this.jumpInLiquidInternal(() -> super.jumpInFluid(type));
    }

    @VisibleForTesting
    public void removeFreeWill() {
        this.removeAllGoals(p_351790_ -> true);
        this.getBrain().removeAllBehaviors();
    }

    public void removeAllGoals(Predicate<Goal> p_262667_) {
        this.goalSelector.removeAllGoals(p_262667_);
    }

    @Override
    protected void removeAfterChangingDimensions() {
        super.removeAfterChangingDimensions();
        for (EquipmentSlot equipmentslot : EquipmentSlot.VALUES) {
            ItemStack itemstack = this.getItemBySlot(equipmentslot);
            if (itemstack.isEmpty()) continue;
            itemstack.setCount(0);
        }
    }

    @Override
    @Nullable
    public ItemStack getPickResult() {
        SpawnEggItem spawneggitem = SpawnEggItem.byId(this.getType());
        return spawneggitem == null ? null : new ItemStack(spawneggitem);
    }

    @Override
    protected void onAttributeUpdated(Holder<Attribute> p_363635_) {
        super.onAttributeUpdated(p_363635_);
        if (p_363635_.is(Attributes.FOLLOW_RANGE) || p_363635_.is(Attributes.TEMPT_RANGE)) {
            this.getNavigation().updatePathfinderMaxVisitedNodes();
        }
    }

    @Nullable
    public final EntitySpawnReason getSpawnType() {
        return this.spawnType;
    }

    @ApiStatus.Internal
    public final boolean isSpawnCancelled() {
        return this.spawnCancelled;
    }

    @ApiStatus.Internal
    public final void setSpawnCancelled(boolean cancel) {
        if (this.isAddedToLevel()) {
            throw new UnsupportedOperationException("Late invocations of Mob#setSpawnCancelled are not permitted.");
        }
        this.spawnCancelled = cancel;
    }
}

