/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public interface Leashable {
    public static final String LEASH_TAG = "leash";
    public static final double LEASH_TOO_FAR_DIST = 12.0;
    public static final double LEASH_ELASTIC_DIST = 6.0;
    public static final double MAXIMUM_ALLOWED_LEASHED_DIST = 16.0;
    public static final Vec3 AXIS_SPECIFIC_ELASTICITY = new Vec3(0.8, 0.2, 0.8);
    public static final float SPRING_DAMPENING = 0.7f;
    public static final double TORSIONAL_ELASTICITY = 10.0;
    public static final double STIFFNESS = 0.11;
    public static final List<Vec3> ENTITY_ATTACHMENT_POINT = ImmutableList.of((Object)new Vec3(0.0, 0.5, 0.5));
    public static final List<Vec3> LEASHER_ATTACHMENT_POINT = ImmutableList.of((Object)new Vec3(0.0, 0.5, 0.0));
    public static final List<Vec3> SHARED_QUAD_ATTACHMENT_POINTS = ImmutableList.of((Object)new Vec3(-0.5, 0.5, 0.5), (Object)new Vec3(-0.5, 0.5, -0.5), (Object)new Vec3(0.5, 0.5, -0.5), (Object)new Vec3(0.5, 0.5, 0.5));

    @Nullable
    public LeashData getLeashData();

    public void setLeashData(@Nullable LeashData var1);

    default public boolean isLeashed() {
        return this.getLeashData() != null && this.getLeashData().leashHolder != null;
    }

    default public boolean mayBeLeashed() {
        return this.getLeashData() != null;
    }

    default public boolean canHaveALeashAttachedTo(Entity p_418026_) {
        if (this == p_418026_) {
            return false;
        }
        return this.leashDistanceTo(p_418026_) > this.leashSnapDistance() ? false : this.canBeLeashed();
    }

    default public double leashDistanceTo(Entity p_418359_) {
        return p_418359_.getBoundingBox().getCenter().distanceTo(((Entity)((Object)this)).getBoundingBox().getCenter());
    }

    default public boolean canBeLeashed() {
        return true;
    }

    default public void setDelayedLeashHolderId(int p_352387_) {
        this.setLeashData(new LeashData(p_352387_));
        Leashable.dropLeash((Entity)((Object)this), false, false);
    }

    default public void readLeashData(ValueInput p_422278_) {
        LeashData leashable$leashdata = p_422278_.read(LEASH_TAG, LeashData.CODEC).orElse(null);
        if (this.getLeashData() != null && leashable$leashdata == null) {
            this.removeLeash();
        }
        this.setLeashData(leashable$leashdata);
    }

    default public void writeLeashData(ValueOutput p_422090_, @Nullable LeashData p_352363_) {
        p_422090_.storeNullable(LEASH_TAG, LeashData.CODEC, p_352363_);
    }

    private static <E extends Entity> void restoreLeashFromSave(E p_352354_, LeashData p_352106_) {
        Level level;
        if (p_352106_.delayedLeashInfo != null && (level = p_352354_.level()) instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            Optional optional1 = p_352106_.delayedLeashInfo.left();
            Optional optional = p_352106_.delayedLeashInfo.right();
            if (optional1.isPresent()) {
                Entity entity = serverlevel.getEntity((UUID)optional1.get());
                if (entity != null) {
                    Leashable.setLeashedTo(p_352354_, entity, true);
                    return;
                }
            } else if (optional.isPresent()) {
                Leashable.setLeashedTo(p_352354_, LeashFenceKnotEntity.getOrCreateKnot(serverlevel, (BlockPos)optional.get()), true);
                return;
            }
            if (p_352354_.tickCount > 100) {
                p_352354_.spawnAtLocation(serverlevel, Items.LEAD);
                ((Leashable)((Object)p_352354_)).setLeashData(null);
            }
        }
    }

    default public void dropLeash() {
        Leashable.dropLeash((Entity)((Object)this), true, true);
    }

    default public void removeLeash() {
        Leashable.dropLeash((Entity)((Object)this), true, false);
    }

    default public void onLeashRemoved() {
    }

    private static <E extends Entity> void dropLeash(E p_352163_, boolean p_352286_, boolean p_352272_) {
        LeashData leashable$leashdata = ((Leashable)((Object)p_352163_)).getLeashData();
        if (leashable$leashdata != null && leashable$leashdata.leashHolder != null) {
            ((Leashable)((Object)p_352163_)).setLeashData(null);
            ((Leashable)((Object)p_352163_)).onLeashRemoved();
            Level level = p_352163_.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)level;
                if (p_352272_) {
                    p_352163_.spawnAtLocation(serverlevel, Items.LEAD);
                }
                if (p_352286_) {
                    serverlevel.getChunkSource().broadcast(p_352163_, new ClientboundSetEntityLinkPacket(p_352163_, null));
                }
                leashable$leashdata.leashHolder.notifyLeasheeRemoved((Leashable)((Object)p_352163_));
            }
        }
    }

    public static <E extends Entity> void tickLeash(ServerLevel p_376374_, E p_352082_) {
        LeashData leashable$leashdata = ((Leashable)((Object)p_352082_)).getLeashData();
        if (leashable$leashdata != null && leashable$leashdata.delayedLeashInfo != null) {
            Leashable.restoreLeashFromSave(p_352082_, leashable$leashdata);
        }
        if (leashable$leashdata != null && leashable$leashdata.leashHolder != null) {
            Entity entity;
            if (!p_352082_.isAlive() || !leashable$leashdata.leashHolder.isAlive()) {
                if (p_376374_.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                    ((Leashable)((Object)p_352082_)).dropLeash();
                } else {
                    ((Leashable)((Object)p_352082_)).removeLeash();
                }
            }
            if ((entity = ((Leashable)((Object)p_352082_)).getLeashHolder()) != null && entity.level() == p_352082_.level()) {
                double d0 = ((Leashable)((Object)p_352082_)).leashDistanceTo(entity);
                ((Leashable)((Object)p_352082_)).whenLeashedTo(entity);
                if (d0 > ((Leashable)((Object)p_352082_)).leashSnapDistance()) {
                    p_376374_.playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.LEAD_BREAK, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    ((Leashable)((Object)p_352082_)).leashTooFarBehaviour();
                } else if (d0 > ((Leashable)((Object)p_352082_)).leashElasticDistance() - (double)entity.getBbWidth() - (double)p_352082_.getBbWidth() && ((Leashable)((Object)p_352082_)).checkElasticInteractions(entity, leashable$leashdata)) {
                    ((Leashable)((Object)p_352082_)).onElasticLeashPull();
                } else {
                    ((Leashable)((Object)p_352082_)).closeRangeLeashBehaviour(entity);
                }
                p_352082_.setYRot((float)((double)p_352082_.getYRot() - leashable$leashdata.angularMomentum));
                leashable$leashdata.angularMomentum *= (double)Leashable.angularFriction(p_352082_);
            }
        }
    }

    default public void onElasticLeashPull() {
        Entity entity = (Entity)((Object)this);
        entity.checkFallDistanceAccumulation();
    }

    default public double leashSnapDistance() {
        return 12.0;
    }

    default public double leashElasticDistance() {
        return 6.0;
    }

    public static <E extends Entity> float angularFriction(E p_418015_) {
        if (p_418015_.onGround()) {
            BlockPos groundPos = p_418015_.getBlockPosBelowThatAffectsMyMovement();
            return p_418015_.level().getBlockState(groundPos).getFriction(p_418015_.level(), groundPos, p_418015_) * 0.91f;
        }
        return p_418015_.isInLiquid() ? 0.8f : 0.91f;
    }

    default public void whenLeashedTo(Entity p_418473_) {
        p_418473_.notifyLeashHolder(this);
    }

    default public void leashTooFarBehaviour() {
        this.dropLeash();
    }

    default public void closeRangeLeashBehaviour(Entity p_352073_) {
    }

    default public boolean checkElasticInteractions(Entity p_418481_, LeashData p_418158_) {
        boolean flag = p_418481_.supportQuadLeashAsHolder() && this.supportQuadLeash();
        List<Wrench> list = Leashable.computeElasticInteraction((Entity)((Object)this), p_418481_, flag ? SHARED_QUAD_ATTACHMENT_POINTS : ENTITY_ATTACHMENT_POINT, flag ? SHARED_QUAD_ATTACHMENT_POINTS : LEASHER_ATTACHMENT_POINT);
        if (list.isEmpty()) {
            return false;
        }
        Wrench leashable$wrench = Wrench.accumulate(list).scale(flag ? 0.25 : 1.0);
        p_418158_.angularMomentum += 10.0 * leashable$wrench.torque();
        Vec3 vec3 = Leashable.getHolderMovement(p_418481_).subtract(((Entity)((Object)this)).getKnownMovement());
        ((Entity)((Object)this)).addDeltaMovement(leashable$wrench.force().multiply(AXIS_SPECIFIC_ELASTICITY).add(vec3.scale(0.11)));
        return true;
    }

    private static Vec3 getHolderMovement(Entity p_426117_) {
        Mob mob;
        return p_426117_ instanceof Mob && (mob = (Mob)p_426117_).isNoAi() ? Vec3.ZERO : p_426117_.getKnownMovement();
    }

    private static <E extends Entity> List<Wrench> computeElasticInteraction(E p_418297_, Entity p_418456_, List<Vec3> p_418351_, List<Vec3> p_418397_) {
        double d0 = ((Leashable)((Object)p_418297_)).leashElasticDistance();
        Vec3 vec3 = Leashable.getHolderMovement(p_418297_);
        float f = p_418297_.getYRot() * ((float)Math.PI / 180);
        Vec3 vec31 = new Vec3(p_418297_.getBbWidth(), p_418297_.getBbHeight(), p_418297_.getBbWidth());
        float f1 = p_418456_.getYRot() * ((float)Math.PI / 180);
        Vec3 vec32 = new Vec3(p_418456_.getBbWidth(), p_418456_.getBbHeight(), p_418456_.getBbWidth());
        ArrayList<Wrench> list = new ArrayList<Wrench>();
        for (int i = 0; i < p_418351_.size(); ++i) {
            Vec3 vec33 = p_418351_.get(i).multiply(vec31).yRot(-f);
            Vec3 vec34 = p_418297_.position().add(vec33);
            Vec3 vec35 = p_418397_.get(i).multiply(vec32).yRot(-f1);
            Vec3 vec36 = p_418456_.position().add(vec35);
            Leashable.computeDampenedSpringInteraction(vec36, vec34, d0, vec3, vec33).ifPresent(list::add);
        }
        return list;
    }

    private static Optional<Wrench> computeDampenedSpringInteraction(Vec3 p_418217_, Vec3 p_418024_, double p_418081_, Vec3 p_418190_, Vec3 p_418069_) {
        boolean flag;
        double d0 = p_418024_.distanceTo(p_418217_);
        if (d0 < p_418081_) {
            return Optional.empty();
        }
        Vec3 vec3 = p_418217_.subtract(p_418024_).normalize().scale(d0 - p_418081_);
        double d1 = Wrench.torqueFromForce(p_418069_, vec3);
        boolean bl = flag = p_418190_.dot(vec3) >= 0.0;
        if (flag) {
            vec3 = vec3.scale(0.3f);
        }
        return Optional.of(new Wrench(vec3, d1));
    }

    default public boolean supportQuadLeash() {
        return false;
    }

    default public Vec3[] getQuadLeashOffsets() {
        return Leashable.createQuadLeashOffsets((Entity)((Object)this), 0.0, 0.5, 0.5, 0.5);
    }

    public static Vec3[] createQuadLeashOffsets(Entity p_418142_, double p_418244_, double p_418078_, double p_418298_, double p_418121_) {
        float f = p_418142_.getBbWidth();
        double d0 = p_418244_ * (double)f;
        double d1 = p_418078_ * (double)f;
        double d2 = p_418298_ * (double)f;
        double d3 = p_418121_ * (double)p_418142_.getBbHeight();
        return new Vec3[]{new Vec3(-d2, d3, d1 + d0), new Vec3(-d2, d3, -d1 + d0), new Vec3(d2, d3, -d1 + d0), new Vec3(d2, d3, d1 + d0)};
    }

    default public Vec3 getLeashOffset(float p_418480_) {
        return this.getLeashOffset();
    }

    default public Vec3 getLeashOffset() {
        Entity entity = (Entity)((Object)this);
        return new Vec3(0.0, entity.getEyeHeight(), entity.getBbWidth() * 0.4f);
    }

    default public void setLeashedTo(Entity p_352411_, boolean p_352183_) {
        if (this != p_352411_) {
            Leashable.setLeashedTo((Entity)((Object)this), p_352411_, p_352183_);
        }
    }

    private static <E extends Entity> void setLeashedTo(E p_352280_, Entity p_352109_, boolean p_352239_) {
        Level level;
        LeashData leashable$leashdata = ((Leashable)((Object)p_352280_)).getLeashData();
        if (leashable$leashdata == null) {
            leashable$leashdata = new LeashData(p_352109_);
            ((Leashable)((Object)p_352280_)).setLeashData(leashable$leashdata);
        } else {
            Entity entity = leashable$leashdata.leashHolder;
            leashable$leashdata.setLeashHolder(p_352109_);
            if (entity != null && entity != p_352109_) {
                entity.notifyLeasheeRemoved((Leashable)((Object)p_352280_));
            }
        }
        if (p_352239_ && (level = p_352280_.level()) instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            serverlevel.getChunkSource().broadcast(p_352280_, new ClientboundSetEntityLinkPacket(p_352280_, p_352109_));
        }
        if (p_352280_.isPassenger()) {
            p_352280_.stopRiding();
        }
    }

    @Nullable
    default public Entity getLeashHolder() {
        return Leashable.getLeashHolder((Entity)((Object)this));
    }

    @Nullable
    private static <E extends Entity> Entity getLeashHolder(E p_352466_) {
        Entity entity;
        LeashData leashable$leashdata = ((Leashable)((Object)p_352466_)).getLeashData();
        if (leashable$leashdata == null) {
            return null;
        }
        if (leashable$leashdata.delayedLeashHolderId != 0 && p_352466_.level().isClientSide && (entity = p_352466_.level().getEntity(leashable$leashdata.delayedLeashHolderId)) instanceof Entity) {
            leashable$leashdata.setLeashHolder(entity);
        }
        return leashable$leashdata.leashHolder;
    }

    public static List<Leashable> leashableLeashedTo(Entity p_418021_) {
        return Leashable.leashableInArea(p_418021_, p_418528_ -> p_418528_.getLeashHolder() == p_418021_);
    }

    public static List<Leashable> leashableInArea(Entity p_418133_, Predicate<Leashable> p_418334_) {
        return Leashable.leashableInArea(p_418133_.level(), p_418133_.getBoundingBox().getCenter(), p_418334_);
    }

    public static List<Leashable> leashableInArea(Level p_418478_, Vec3 p_418494_, Predicate<Leashable> p_418347_) {
        double d0 = 32.0;
        AABB aabb = AABB.ofSize(p_418494_, 32.0, 32.0, 32.0);
        return p_418478_.getEntitiesOfClass(Entity.class, aabb, p_418131_ -> {
            Leashable leashable;
            return p_418131_ instanceof Leashable && p_418347_.test(leashable = (Leashable)((Object)p_418131_));
        }).stream().map(Leashable.class::cast).toList();
    }

    public static final class LeashData {
        public static final Codec<LeashData> CODEC = Codec.xor((Codec)UUIDUtil.CODEC.fieldOf("UUID").codec(), BlockPos.CODEC).xmap(LeashData::new, p_412912_ -> {
            Entity patt0$temp = p_412912_.leashHolder;
            if (patt0$temp instanceof LeashFenceKnotEntity) {
                LeashFenceKnotEntity leashfenceknotentity = (LeashFenceKnotEntity)patt0$temp;
                return Either.right((Object)leashfenceknotentity.getPos());
            }
            return p_412912_.leashHolder != null ? Either.left((Object)p_412912_.leashHolder.getUUID()) : Objects.requireNonNull(p_412912_.delayedLeashInfo, "Invalid LeashData had no attachment");
        });
        int delayedLeashHolderId;
        @Nullable
        public Entity leashHolder;
        @Nullable
        public Either<UUID, BlockPos> delayedLeashInfo;
        public double angularMomentum;

        private LeashData(Either<UUID, BlockPos> p_352282_) {
            this.delayedLeashInfo = p_352282_;
        }

        LeashData(Entity p_352066_) {
            this.leashHolder = p_352066_;
        }

        LeashData(int p_352297_) {
            this.delayedLeashHolderId = p_352297_;
        }

        public void setLeashHolder(Entity p_352464_) {
            this.leashHolder = p_352464_;
            this.delayedLeashInfo = null;
            this.delayedLeashHolderId = 0;
        }
    }

    public record Wrench(Vec3 force, double torque) {
        static Wrench ZERO = new Wrench(Vec3.ZERO, 0.0);

        static double torqueFromForce(Vec3 p_418322_, Vec3 p_418094_) {
            return p_418322_.z * p_418094_.x - p_418322_.x * p_418094_.z;
        }

        static Wrench accumulate(List<Wrench> p_418210_) {
            if (p_418210_.isEmpty()) {
                return ZERO;
            }
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            for (Wrench leashable$wrench : p_418210_) {
                Vec3 vec3 = leashable$wrench.force;
                d0 += vec3.x;
                d1 += vec3.y;
                d2 += vec3.z;
                d3 += leashable$wrench.torque;
            }
            return new Wrench(new Vec3(d0, d1, d2), d3);
        }

        public Wrench scale(double p_418466_) {
            return new Wrench(this.force.scale(p_418466_), this.torque * p_418466_);
        }
    }
}

