/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.UUIDLookup;
import net.minecraft.world.level.entity.UniquelyIdentifyable;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public final class EntityReference<StoredEntityType extends UniquelyIdentifyable> {
    private static final Codec<? extends EntityReference<?>> CODEC = UUIDUtil.CODEC.xmap(EntityReference::new, EntityReference::getUUID);
    private static final StreamCodec<ByteBuf, ? extends EntityReference<?>> STREAM_CODEC = UUIDUtil.STREAM_CODEC.map(EntityReference::new, EntityReference::getUUID);
    private Either<UUID, StoredEntityType> entity;

    public static <Type extends UniquelyIdentifyable> Codec<EntityReference<Type>> codec() {
        return CODEC;
    }

    public static <Type extends UniquelyIdentifyable> StreamCodec<ByteBuf, EntityReference<Type>> streamCodec() {
        return STREAM_CODEC;
    }

    public EntityReference(StoredEntityType p_394384_) {
        this.entity = Either.right(p_394384_);
    }

    public EntityReference(UUID p_394483_) {
        this.entity = Either.left((Object)p_394483_);
    }

    public UUID getUUID() {
        return (UUID)this.entity.map(p_394562_ -> p_394562_, UniquelyIdentifyable::getUUID);
    }

    @Nullable
    public StoredEntityType getEntity(UUIDLookup<? super StoredEntityType> p_394375_, Class<StoredEntityType> p_394097_) {
        StoredEntityType storedentitytype1;
        Optional optional1;
        Optional optional = this.entity.right();
        if (optional.isPresent()) {
            UniquelyIdentifyable storedentitytype = (UniquelyIdentifyable)optional.get();
            if (!storedentitytype.isRemoved()) {
                return (StoredEntityType)storedentitytype;
            }
            this.entity = Either.left((Object)storedentitytype.getUUID());
        }
        if ((optional1 = this.entity.left()).isPresent() && (storedentitytype1 = this.resolve((UniquelyIdentifyable)p_394375_.getEntity((UUID)optional1.get()), p_394097_)) != null && !storedentitytype1.isRemoved()) {
            this.entity = Either.right(storedentitytype1);
            return storedentitytype1;
        }
        return null;
    }

    @Nullable
    private StoredEntityType resolve(@Nullable UniquelyIdentifyable p_394069_, Class<StoredEntityType> p_394131_) {
        return (StoredEntityType)(p_394069_ != null && p_394131_.isAssignableFrom(p_394069_.getClass()) ? (UniquelyIdentifyable)p_394131_.cast(p_394069_) : null);
    }

    public boolean matches(StoredEntityType p_394272_) {
        return this.getUUID().equals(p_394272_.getUUID());
    }

    public void store(ValueOutput p_422692_, String p_393486_) {
        p_422692_.store(p_393486_, UUIDUtil.CODEC, this.getUUID());
    }

    public static void store(@Nullable EntityReference<?> p_423520_, ValueOutput p_423510_, String p_423668_) {
        if (p_423520_ != null) {
            p_423520_.store(p_423510_, p_423668_);
        }
    }

    @Nullable
    public static <StoredEntityType extends UniquelyIdentifyable> StoredEntityType get(@Nullable EntityReference<StoredEntityType> p_393467_, UUIDLookup<? super StoredEntityType> p_393924_, Class<StoredEntityType> p_394473_) {
        return p_393467_ != null ? (StoredEntityType)p_393467_.getEntity(p_393924_, p_394473_) : null;
    }

    @Nullable
    public static <StoredEntityType extends UniquelyIdentifyable> EntityReference<StoredEntityType> read(ValueInput p_421654_, String p_394012_) {
        return p_421654_.read(p_394012_, EntityReference.codec()).orElse(null);
    }

    @Nullable
    public static <StoredEntityType extends UniquelyIdentifyable> EntityReference<StoredEntityType> readWithOldOwnerConversion(ValueInput p_422383_, String p_394543_, Level p_393661_) {
        Optional<UUID> optional = p_422383_.read(p_394543_, UUIDUtil.CODEC);
        return optional.isPresent() ? new EntityReference(optional.get()) : (EntityReference)p_422383_.getString(p_394543_).map(p_409192_ -> OldUsersConverter.convertMobOwnerIfNecessary(p_393661_.getServer(), p_409192_)).map(EntityReference::new).orElse(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object p_423529_) {
        if (p_423529_ == this) {
            return true;
        }
        if (!(p_423529_ instanceof EntityReference)) return false;
        EntityReference entityreference = (EntityReference)p_423529_;
        if (!this.getUUID().equals(entityreference.getUUID())) return false;
        return true;
    }

    public int hashCode() {
        return this.getUUID().hashCode();
    }
}

