/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class ElytraAnimationState {
    private static final float DEFAULT_X_ROT = 0.2617994f;
    private static final float DEFAULT_Z_ROT = -0.2617994f;
    private float rotX;
    private float rotY;
    private float rotZ;
    private float rotXOld;
    private float rotYOld;
    private float rotZOld;
    private final LivingEntity entity;

    public ElytraAnimationState(LivingEntity p_363430_) {
        this.entity = p_363430_;
    }

    public void tick() {
        float f2;
        float f1;
        float f;
        this.rotXOld = this.rotX;
        this.rotYOld = this.rotY;
        this.rotZOld = this.rotZ;
        if (this.entity.isFallFlying()) {
            float f3 = 1.0f;
            Vec3 vec3 = this.entity.getDeltaMovement();
            if (vec3.y < 0.0) {
                Vec3 vec31 = vec3.normalize();
                f3 = 1.0f - (float)Math.pow(-vec31.y, 1.5);
            }
            f = Mth.lerp(f3, 0.2617994f, 0.34906584f);
            f1 = Mth.lerp(f3, -0.2617994f, -1.5707964f);
            f2 = 0.0f;
        } else if (this.entity.isCrouching()) {
            f = 0.6981317f;
            f1 = -0.7853982f;
            f2 = 0.08726646f;
        } else {
            f = 0.2617994f;
            f1 = -0.2617994f;
            f2 = 0.0f;
        }
        this.rotX += (f - this.rotX) * 0.3f;
        this.rotY += (f2 - this.rotY) * 0.3f;
        this.rotZ += (f1 - this.rotZ) * 0.3f;
    }

    public float getRotX(float p_363765_) {
        return Mth.lerp(p_363765_, this.rotXOld, this.rotX);
    }

    public float getRotY(float p_361072_) {
        return Mth.lerp(p_361072_, this.rotYOld, this.rotY);
    }

    public float getRotZ(float p_364912_) {
        return Mth.lerp(p_364912_, this.rotZOld, this.rotZ);
    }
}

