/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.EquipmentSlot;

public record DropChances(Map<EquipmentSlot, Float> byEquipment) {
    public static final float DEFAULT_EQUIPMENT_DROP_CHANCE = 0.085f;
    public static final float PRESERVE_ITEM_DROP_CHANCE_THRESHOLD = 1.0f;
    public static final int PRESERVE_ITEM_DROP_CHANCE = 2;
    public static final DropChances DEFAULT = new DropChances(Util.makeEnumMap(EquipmentSlot.class, p_393572_ -> Float.valueOf(0.085f)));
    public static final Codec<DropChances> CODEC = Codec.unboundedMap(EquipmentSlot.CODEC, ExtraCodecs.NON_NEGATIVE_FLOAT).xmap(DropChances::toEnumMap, DropChances::filterDefaultValues).xmap(DropChances::new, DropChances::byEquipment);

    private static Map<EquipmentSlot, Float> filterDefaultValues(Map<EquipmentSlot, Float> p_394014_) {
        HashMap<EquipmentSlot, Float> map = new HashMap<EquipmentSlot, Float>(p_394014_);
        map.values().removeIf(p_393748_ -> p_393748_.floatValue() == 0.085f);
        return map;
    }

    private static Map<EquipmentSlot, Float> toEnumMap(Map<EquipmentSlot, Float> p_393876_) {
        return Util.makeEnumMap(EquipmentSlot.class, p_394429_ -> p_393876_.getOrDefault(p_394429_, Float.valueOf(0.085f)));
    }

    public DropChances withGuaranteedDrop(EquipmentSlot p_394388_) {
        return this.withEquipmentChance(p_394388_, 2.0f);
    }

    public DropChances withEquipmentChance(EquipmentSlot p_394616_, float p_394553_) {
        if (p_394553_ < 0.0f) {
            throw new IllegalArgumentException("Tried to set invalid equipment chance " + p_394553_ + " for " + String.valueOf(p_394616_));
        }
        return this.byEquipment(p_394616_) == p_394553_ ? this : new DropChances(Util.makeEnumMap(EquipmentSlot.class, p_393769_ -> Float.valueOf(p_393769_ == p_394616_ ? p_394553_ : this.byEquipment((EquipmentSlot)p_393769_))));
    }

    public float byEquipment(EquipmentSlot p_394232_) {
        return this.byEquipment.getOrDefault(p_394232_, Float.valueOf(0.085f)).floatValue();
    }

    public boolean isPreserved(EquipmentSlot p_394426_) {
        return this.byEquipment(p_394426_) > 1.0f;
    }
}

