/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import net.minecraft.world.item.ItemStack;

public class Crackiness {
    public static final Crackiness GOLEM = new Crackiness(0.75f, 0.5f, 0.25f);
    public static final Crackiness WOLF_ARMOR = new Crackiness(0.95f, 0.69f, 0.32f);
    private final float fractionLow;
    private final float fractionMedium;
    private final float fractionHigh;

    private Crackiness(float p_330512_, float p_330332_, float p_330467_) {
        this.fractionLow = p_330512_;
        this.fractionMedium = p_330332_;
        this.fractionHigh = p_330467_;
    }

    public Level byFraction(float p_331959_) {
        if (p_331959_ < this.fractionHigh) {
            return Level.HIGH;
        }
        if (p_331959_ < this.fractionMedium) {
            return Level.MEDIUM;
        }
        return p_331959_ < this.fractionLow ? Level.LOW : Level.NONE;
    }

    public Level byDamage(ItemStack p_331331_) {
        return !p_331331_.isDamageableItem() ? Level.NONE : this.byDamage(p_331331_.getDamageValue(), p_331331_.getMaxDamage());
    }

    public Level byDamage(int p_330780_, int p_330215_) {
        return this.byFraction((float)(p_330215_ - p_330780_) / (float)p_330215_);
    }

    public static enum Level {
        NONE,
        LOW,
        MEDIUM,
        HIGH;

    }
}

