/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.damagesource;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;

public class CombatRules {
    public static final float MAX_ARMOR = 20.0f;
    public static final float ARMOR_PROTECTION_DIVIDER = 25.0f;
    public static final float BASE_ARMOR_TOUGHNESS = 2.0f;
    public static final float MIN_ARMOR_RATIO = 0.2f;
    private static final int NUM_ARMOR_ITEMS = 4;

    public static float getDamageAfterAbsorb(LivingEntity p_345376_, float p_19273_, DamageSource p_338892_, float p_19274_, float p_19275_) {
        float f3;
        Level level;
        float f = 2.0f + p_19275_ / 4.0f;
        float f1 = Mth.clamp(p_19274_ - p_19273_ / f, p_19274_ * 0.2f, 20.0f);
        float f2 = f1 / 25.0f;
        ItemStack itemstack = p_338892_.getWeaponItem();
        if (itemstack != null && (level = p_345376_.level()) instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            f3 = Mth.clamp(EnchantmentHelper.modifyArmorEffectiveness(serverlevel, itemstack, p_345376_, p_338892_, f2), 0.0f, 1.0f);
        } else {
            f3 = f2;
        }
        float f4 = 1.0f - f3;
        return p_19273_ * f4;
    }

    public static float getDamageAfterMagicAbsorb(float p_19270_, float p_19271_) {
        float f = Mth.clamp(p_19271_, 0.0f, 20.0f);
        return p_19270_ * (1.0f - f / 25.0f);
    }
}

