/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;

public class RandomSequence {
    public static final Codec<RandomSequence> CODEC = RecordCodecBuilder.create(p_287586_ -> p_287586_.group((App)XoroshiroRandomSource.CODEC.fieldOf("source").forGetter(p_287757_ -> p_287757_.source)).apply((Applicative)p_287586_, RandomSequence::new));
    private final XoroshiroRandomSource source;

    public RandomSequence(XoroshiroRandomSource p_287597_) {
        this.source = p_287597_;
    }

    public RandomSequence(long p_287592_, ResourceLocation p_287762_) {
        this(RandomSequence.createSequence(p_287592_, Optional.of(p_287762_)));
    }

    public RandomSequence(long p_295115_, Optional<ResourceLocation> p_295306_) {
        this(RandomSequence.createSequence(p_295115_, p_295306_));
    }

    private static XoroshiroRandomSource createSequence(long p_289567_, Optional<ResourceLocation> p_294573_) {
        RandomSupport.Seed128bit randomsupport$seed128bit = RandomSupport.upgradeSeedTo128bitUnmixed(p_289567_);
        if (p_294573_.isPresent()) {
            randomsupport$seed128bit = randomsupport$seed128bit.xor(RandomSequence.seedForKey(p_294573_.get()));
        }
        return new XoroshiroRandomSource(randomsupport$seed128bit.mixed());
    }

    public static RandomSupport.Seed128bit seedForKey(ResourceLocation p_288989_) {
        return RandomSupport.seedFromHashOf(p_288989_.toString());
    }

    public RandomSource random() {
        return this.source;
    }
}

