/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Clearable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public interface Container
extends Clearable,
Iterable<ItemStack> {
    public static final float DEFAULT_DISTANCE_BUFFER = 4.0f;

    public int getContainerSize();

    public boolean isEmpty();

    public ItemStack getItem(int var1);

    public ItemStack removeItem(int var1, int var2);

    public ItemStack removeItemNoUpdate(int var1);

    public void setItem(int var1, ItemStack var2);

    default public int getMaxStackSize() {
        return 99;
    }

    default public int getMaxStackSize(ItemStack p_335963_) {
        return Math.min(this.getMaxStackSize(), p_335963_.getMaxStackSize());
    }

    public void setChanged();

    public boolean stillValid(Player var1);

    default public void startOpen(Player p_18955_) {
    }

    default public void stopOpen(Player p_18954_) {
    }

    default public boolean canPlaceItem(int p_18952_, ItemStack p_18953_) {
        return true;
    }

    default public boolean canTakeItem(Container p_273520_, int p_272681_, ItemStack p_273702_) {
        return true;
    }

    default public int countItem(Item p_18948_) {
        int i = 0;
        for (ItemStack itemstack : this) {
            if (!itemstack.getItem().equals(p_18948_)) continue;
            i += itemstack.getCount();
        }
        return i;
    }

    default public boolean hasAnyOf(Set<Item> p_18950_) {
        return this.hasAnyMatching(p_216873_ -> !p_216873_.isEmpty() && p_18950_.contains(p_216873_.getItem()));
    }

    default public boolean hasAnyMatching(Predicate<ItemStack> p_216875_) {
        for (ItemStack itemstack : this) {
            if (!p_216875_.test(itemstack)) continue;
            return true;
        }
        return false;
    }

    public static boolean stillValidBlockEntity(BlockEntity p_273154_, Player p_273222_) {
        return Container.stillValidBlockEntity(p_273154_, p_273222_, 4.0f);
    }

    public static boolean stillValidBlockEntity(BlockEntity p_272877_, Player p_272670_, float p_320837_) {
        Level level = p_272877_.getLevel();
        BlockPos blockpos = p_272877_.getBlockPos();
        if (level == null) {
            return false;
        }
        return level.getBlockEntity(blockpos) != p_272877_ ? false : p_272670_.canInteractWithBlock(blockpos, p_320837_);
    }

    @Override
    default public Iterator<ItemStack> iterator() {
        return new ContainerIterator(this);
    }

    public static class ContainerIterator
    implements Iterator<ItemStack> {
        private final Container container;
        private int index;
        private final int size;

        public ContainerIterator(Container p_401886_) {
            this.container = p_401886_;
            this.size = p_401886_.getContainerSize();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.size;
        }

        @Override
        public ItemStack next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.container.getItem(this.index++);
        }
    }
}

