/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.parsing.packrat.commands;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.util.parsing.packrat.DelayedException;
import net.minecraft.util.parsing.packrat.Dictionary;
import net.minecraft.util.parsing.packrat.ErrorCollector;
import net.minecraft.util.parsing.packrat.ErrorEntry;
import net.minecraft.util.parsing.packrat.NamedRule;
import net.minecraft.util.parsing.packrat.ParseState;
import net.minecraft.util.parsing.packrat.SuggestionSupplier;
import net.minecraft.util.parsing.packrat.commands.CommandArgumentParser;
import net.minecraft.util.parsing.packrat.commands.ResourceSuggestion;
import net.minecraft.util.parsing.packrat.commands.StringReaderParserState;

public record Grammar<T>(Dictionary<StringReader> rules, NamedRule<StringReader, T> top) implements CommandArgumentParser<T>
{
    public Grammar {
        rules.checkAllBound();
    }

    public Optional<T> parse(ParseState<StringReader> p_335989_) {
        return p_335989_.parseTopRule(this.top);
    }

    @Override
    public T parseForCommands(StringReader p_336148_) throws CommandSyntaxException {
        Object r;
        ErrorCollector.LongestOnly<StringReader> longestonly = new ErrorCollector.LongestOnly<StringReader>();
        StringReaderParserState stringreaderparserstate = new StringReaderParserState(longestonly, p_336148_);
        Optional<T> optional = this.parse(stringreaderparserstate);
        if (optional.isPresent()) {
            return optional.get();
        }
        List<ErrorEntry<StringReader>> list = longestonly.entries();
        List list1 = list.stream().mapMulti((p_409181_, p_409182_) -> {
            Object patt0$temp = p_409181_.reason();
            if (patt0$temp instanceof DelayedException) {
                DelayedException delayedexception = (DelayedException)patt0$temp;
                p_409182_.accept(delayedexception.create(p_336148_.getString(), p_409181_.cursor()));
            } else {
                Object patt1$temp = p_409181_.reason();
                if (patt1$temp instanceof Exception) {
                    Exception exception1 = (Exception)patt1$temp;
                    p_409182_.accept(exception1);
                }
            }
        }).toList();
        for (Exception exception : list1) {
            if (!(exception instanceof CommandSyntaxException)) continue;
            CommandSyntaxException commandsyntaxexception = (CommandSyntaxException)((Object)exception);
            throw commandsyntaxexception;
        }
        if (list1.size() == 1 && (r = list1.get(0)) instanceof RuntimeException) {
            RuntimeException runtimeexception = (RuntimeException)r;
            throw runtimeexception;
        }
        throw new IllegalStateException("Failed to parse: " + list.stream().map(ErrorEntry::toString).collect(Collectors.joining(", ")));
    }

    @Override
    public CompletableFuture<Suggestions> parseForSuggestions(SuggestionsBuilder p_335783_) {
        StringReader stringreader = new StringReader(p_335783_.getInput());
        stringreader.setCursor(p_335783_.getStart());
        ErrorCollector.LongestOnly<StringReader> longestonly = new ErrorCollector.LongestOnly<StringReader>();
        StringReaderParserState stringreaderparserstate = new StringReaderParserState(longestonly, stringreader);
        this.parse(stringreaderparserstate);
        List<ErrorEntry<StringReader>> list = longestonly.entries();
        if (list.isEmpty()) {
            return p_335783_.buildFuture();
        }
        SuggestionsBuilder suggestionsbuilder = p_335783_.createOffset(longestonly.cursor());
        for (ErrorEntry<StringReader> errorentry : list) {
            SuggestionSupplier<StringReader> suggestionSupplier = errorentry.suggestions();
            if (suggestionSupplier instanceof ResourceSuggestion) {
                ResourceSuggestion resourcesuggestion = (ResourceSuggestion)suggestionSupplier;
                SharedSuggestionProvider.suggestResource(resourcesuggestion.possibleResources(), suggestionsbuilder);
                continue;
            }
            SharedSuggestionProvider.suggest(errorentry.suggestions().possibleValues(stringreaderparserstate), suggestionsbuilder);
        }
        return suggestionsbuilder.buildFuture();
    }
}

