/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.parsing.packrat;

import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.util.parsing.packrat.Atom;
import net.minecraft.util.parsing.packrat.Control;
import net.minecraft.util.parsing.packrat.ErrorCollector;
import net.minecraft.util.parsing.packrat.NamedRule;
import net.minecraft.util.parsing.packrat.ParseState;
import net.minecraft.util.parsing.packrat.Scope;

public abstract class CachedParseState<S>
implements ParseState<S> {
    private PositionCache[] positionCache = new PositionCache[256];
    private final ErrorCollector<S> errorCollector;
    private final Scope scope = new Scope();
    private SimpleControl[] controlCache = new SimpleControl[16];
    private int nextControlToReturn;
    private final Silent silent = new Silent();

    protected CachedParseState(ErrorCollector<S> p_410265_) {
        this.errorCollector = p_410265_;
    }

    @Override
    public Scope scope() {
        return this.scope;
    }

    @Override
    public ErrorCollector<S> errorCollector() {
        return this.errorCollector;
    }

    @Override
    @Nullable
    public <T> T parse(NamedRule<S, T> p_410365_) {
        CacheEntry cacheentry1;
        T t;
        int i = this.mark();
        PositionCache cachedparsestate$positioncache = this.getCacheForPosition(i);
        int j = cachedparsestate$positioncache.findKeyIndex(p_410365_.name());
        if (j != -1) {
            CacheEntry cacheentry = cachedparsestate$positioncache.getValue(j);
            if (cacheentry != null) {
                if (cacheentry == CacheEntry.NEGATIVE) {
                    return null;
                }
                this.restore(cacheentry.markAfterParse);
                return cacheentry.value;
            }
        } else {
            j = cachedparsestate$positioncache.allocateNewEntry(p_410365_.name());
        }
        if ((t = p_410365_.value().parse(this)) == null) {
            cacheentry1 = CacheEntry.negativeEntry();
        } else {
            int k = this.mark();
            cacheentry1 = new CacheEntry<T>(t, k);
        }
        cachedparsestate$positioncache.setValue(j, cacheentry1);
        return t;
    }

    private PositionCache getCacheForPosition(int p_410075_) {
        PositionCache cachedparsestate$positioncache;
        int i = this.positionCache.length;
        if (p_410075_ >= i) {
            int j = Util.growByHalf(i, p_410075_ + 1);
            PositionCache[] acachedparsestate$positioncache = new PositionCache[j];
            System.arraycopy(this.positionCache, 0, acachedparsestate$positioncache, 0, i);
            this.positionCache = acachedparsestate$positioncache;
        }
        if ((cachedparsestate$positioncache = this.positionCache[p_410075_]) == null) {
            this.positionCache[p_410075_] = cachedparsestate$positioncache = new PositionCache();
        }
        return cachedparsestate$positioncache;
    }

    @Override
    public Control acquireControl() {
        int k;
        SimpleControl cachedparsestate$simplecontrol;
        int i = this.controlCache.length;
        if (this.nextControlToReturn >= i) {
            int j = Util.growByHalf(i, this.nextControlToReturn + 1);
            SimpleControl[] acachedparsestate$simplecontrol = new SimpleControl[j];
            System.arraycopy(this.controlCache, 0, acachedparsestate$simplecontrol, 0, i);
            this.controlCache = acachedparsestate$simplecontrol;
        }
        if ((cachedparsestate$simplecontrol = this.controlCache[k = this.nextControlToReturn++]) == null) {
            this.controlCache[k] = cachedparsestate$simplecontrol = new SimpleControl();
        } else {
            cachedparsestate$simplecontrol.reset();
        }
        return cachedparsestate$simplecontrol;
    }

    @Override
    public void releaseControl() {
        --this.nextControlToReturn;
    }

    @Override
    public ParseState<S> silent() {
        return this.silent;
    }

    static class PositionCache {
        public static final int ENTRY_STRIDE = 2;
        private static final int NOT_FOUND = -1;
        private Object[] atomCache = new Object[16];
        private int nextKey;

        PositionCache() {
        }

        public int findKeyIndex(Atom<?> p_410592_) {
            for (int i = 0; i < this.nextKey; i += 2) {
                if (this.atomCache[i] != p_410592_) continue;
                return i;
            }
            return -1;
        }

        public int allocateNewEntry(Atom<?> p_410029_) {
            int i = this.nextKey;
            this.nextKey += 2;
            int j = i + 1;
            int k = this.atomCache.length;
            if (j >= k) {
                int l = Util.growByHalf(k, j + 1);
                Object[] aobject = new Object[l];
                System.arraycopy(this.atomCache, 0, aobject, 0, k);
                this.atomCache = aobject;
            }
            this.atomCache[i] = p_410029_;
            return i;
        }

        @Nullable
        public <T> CacheEntry<T> getValue(int p_410518_) {
            return (CacheEntry)this.atomCache[p_410518_ + 1];
        }

        public void setValue(int p_409757_, CacheEntry<?> p_410617_) {
            this.atomCache[p_409757_ + 1] = p_410617_;
        }
    }

    static class SimpleControl
    implements Control {
        private boolean hasCut;

        SimpleControl() {
        }

        @Override
        public void cut() {
            this.hasCut = true;
        }

        @Override
        public boolean hasCut() {
            return this.hasCut;
        }

        public void reset() {
            this.hasCut = false;
        }
    }

    class Silent
    implements ParseState<S> {
        private final ErrorCollector<S> silentCollector = new ErrorCollector.Nop();

        Silent() {
        }

        @Override
        public ErrorCollector<S> errorCollector() {
            return this.silentCollector;
        }

        @Override
        public Scope scope() {
            return CachedParseState.this.scope();
        }

        @Override
        @Nullable
        public <T> T parse(NamedRule<S, T> p_410584_) {
            return CachedParseState.this.parse(p_410584_);
        }

        @Override
        public S input() {
            return CachedParseState.this.input();
        }

        @Override
        public int mark() {
            return CachedParseState.this.mark();
        }

        @Override
        public void restore(int p_410357_) {
            CachedParseState.this.restore(p_410357_);
        }

        @Override
        public Control acquireControl() {
            return CachedParseState.this.acquireControl();
        }

        @Override
        public void releaseControl() {
            CachedParseState.this.releaseControl();
        }

        @Override
        public ParseState<S> silent() {
            return this;
        }
    }

    record CacheEntry<T>(@Nullable T value, int markAfterParse) {
        public static final CacheEntry<?> NEGATIVE = new CacheEntry<Object>(null, -1);

        public static <T> CacheEntry<T> negativeEntry() {
            return NEGATIVE;
        }
    }
}

