/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.eventlog;

import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import org.slf4j.Logger;

public class EventLogDirectory {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final int COMPRESS_BUFFER_SIZE = 4096;
    private static final String COMPRESSED_EXTENSION = ".gz";
    private final Path root;
    private final String extension;

    private EventLogDirectory(Path p_261546_, String p_261467_) {
        this.root = p_261546_;
        this.extension = p_261467_;
    }

    public static EventLogDirectory open(Path p_261743_, String p_261659_) throws IOException {
        Files.createDirectories(p_261743_, new FileAttribute[0]);
        return new EventLogDirectory(p_261743_, p_261659_);
    }

    public FileList listFiles() throws IOException {
        FileList eventlogdirectory$filelist;
        try (Stream<Path> stream = Files.list(this.root);){
            eventlogdirectory$filelist = new FileList(stream.filter(p_262170_ -> Files.isRegularFile(p_262170_, new LinkOption[0])).map(this::parseFile).filter(Objects::nonNull).toList());
        }
        return eventlogdirectory$filelist;
    }

    @Nullable
    private File parseFile(Path p_261985_) {
        String s = p_261985_.getFileName().toString();
        int i = s.indexOf(46);
        if (i == -1) {
            return null;
        }
        FileId eventlogdirectory$fileid = FileId.parse(s.substring(0, i));
        if (eventlogdirectory$fileid != null) {
            String s1 = s.substring(i);
            if (s1.equals(this.extension)) {
                return new RawFile(p_261985_, eventlogdirectory$fileid);
            }
            if (s1.equals(this.extension + COMPRESSED_EXTENSION)) {
                return new CompressedFile(p_261985_, eventlogdirectory$fileid);
            }
        }
        return null;
    }

    static void tryCompress(Path p_261741_, Path p_262101_) throws IOException {
        if (Files.exists(p_262101_, new LinkOption[0])) {
            throw new IOException("Compressed target file already exists: " + String.valueOf(p_262101_));
        }
        try (FileChannel filechannel = FileChannel.open(p_261741_, StandardOpenOption.WRITE, StandardOpenOption.READ);){
            FileLock filelock = filechannel.tryLock();
            if (filelock == null) {
                throw new IOException("Raw log file is already locked, cannot compress: " + String.valueOf(p_261741_));
            }
            EventLogDirectory.writeCompressed(filechannel, p_262101_);
            filechannel.truncate(0L);
        }
        Files.delete(p_261741_);
    }

    private static void writeCompressed(ReadableByteChannel p_262066_, Path p_262054_) throws IOException {
        try (GZIPOutputStream outputstream = new GZIPOutputStream(Files.newOutputStream(p_262054_, new OpenOption[0]));){
            byte[] abyte = new byte[4096];
            ByteBuffer bytebuffer = ByteBuffer.wrap(abyte);
            while (p_262066_.read(bytebuffer) >= 0) {
                bytebuffer.flip();
                ((OutputStream)outputstream).write(abyte, 0, bytebuffer.limit());
                bytebuffer.clear();
            }
        }
    }

    public RawFile createNewFile(LocalDate p_261865_) throws IOException {
        FileId eventlogdirectory$fileid;
        int i = 1;
        Set<FileId> set = this.listFiles().ids();
        while (set.contains(eventlogdirectory$fileid = new FileId(p_261865_, i++))) {
        }
        RawFile eventlogdirectory$rawfile = new RawFile(this.root.resolve(eventlogdirectory$fileid.toFileName(this.extension)), eventlogdirectory$fileid);
        Files.createFile(eventlogdirectory$rawfile.path(), new FileAttribute[0]);
        return eventlogdirectory$rawfile;
    }

    public static class FileList
    implements Iterable<File> {
        private final List<File> files;

        FileList(List<File> p_261941_) {
            this.files = new ArrayList<File>(p_261941_);
        }

        public FileList prune(LocalDate p_261825_, int p_261918_) {
            this.files.removeIf(p_261494_ -> {
                FileId eventlogdirectory$fileid = p_261494_.id();
                LocalDate localdate = eventlogdirectory$fileid.date().plusDays(p_261918_);
                if (!p_261825_.isBefore(localdate)) {
                    try {
                        Files.delete(p_261494_.path());
                        return true;
                    }
                    catch (IOException ioexception) {
                        LOGGER.warn("Failed to delete expired event log file: {}", (Object)p_261494_.path(), (Object)ioexception);
                    }
                }
                return false;
            });
            return this;
        }

        public FileList compressAll() {
            ListIterator<File> listiterator = this.files.listIterator();
            while (listiterator.hasNext()) {
                File eventlogdirectory$file = listiterator.next();
                try {
                    listiterator.set(eventlogdirectory$file.compress());
                }
                catch (IOException ioexception) {
                    LOGGER.warn("Failed to compress event log file: {}", (Object)eventlogdirectory$file.path(), (Object)ioexception);
                }
            }
            return this;
        }

        @Override
        public Iterator<File> iterator() {
            return this.files.iterator();
        }

        public Stream<File> stream() {
            return this.files.stream();
        }

        public Set<FileId> ids() {
            return this.files.stream().map(File::id).collect(Collectors.toSet());
        }
    }

    public record FileId(LocalDate date, int index) {
        private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.BASIC_ISO_DATE;

        @Nullable
        public static FileId parse(String p_261762_) {
            int i = p_261762_.indexOf("-");
            if (i == -1) {
                return null;
            }
            String s = p_261762_.substring(0, i);
            String s1 = p_261762_.substring(i + 1);
            try {
                return new FileId(LocalDate.parse(s, DATE_FORMATTER), Integer.parseInt(s1));
            }
            catch (NumberFormatException | DateTimeParseException numberformatexception) {
                return null;
            }
        }

        @Override
        public String toString() {
            return DATE_FORMATTER.format(this.date) + "-" + this.index;
        }

        public String toFileName(String p_261982_) {
            return String.valueOf(this) + p_261982_;
        }
    }

    public record RawFile(Path path, FileId id) implements File
    {
        public FileChannel openChannel() throws IOException {
            return FileChannel.open(this.path, StandardOpenOption.WRITE, StandardOpenOption.READ);
        }

        @Override
        @Nullable
        public Reader openReader() throws IOException {
            return Files.exists(this.path, new LinkOption[0]) ? Files.newBufferedReader(this.path) : null;
        }

        @Override
        public CompressedFile compress() throws IOException {
            Path path = this.path.resolveSibling(this.path.getFileName().toString() + EventLogDirectory.COMPRESSED_EXTENSION);
            EventLogDirectory.tryCompress(this.path, path);
            return new CompressedFile(path, this.id);
        }
    }

    public record CompressedFile(Path path, FileId id) implements File
    {
        @Override
        @Nullable
        public Reader openReader() throws IOException {
            return !Files.exists(this.path, new LinkOption[0]) ? null : new BufferedReader(new InputStreamReader(new GZIPInputStream(Files.newInputStream(this.path, new OpenOption[0]))));
        }

        @Override
        public CompressedFile compress() {
            return this;
        }
    }

    public static interface File {
        public Path path();

        public FileId id();

        @Nullable
        public Reader openReader() throws IOException;

        public CompressedFile compress() throws IOException;
    }
}

