/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.schemas;

import com.google.common.collect.Maps;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.Hook;
import com.mojang.datafixers.types.templates.TypeTemplate;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.util.datafix.schemas.NamespacedSchema;
import org.slf4j.Logger;

public class V99
extends Schema {
    private static final Logger LOGGER = LogUtils.getLogger();
    static final Map<String, String> ITEM_TO_BLOCKENTITY = (Map)DataFixUtils.make((Object)Maps.newHashMap(), p_145919_ -> {
        p_145919_.put("minecraft:furnace", "Furnace");
        p_145919_.put("minecraft:lit_furnace", "Furnace");
        p_145919_.put("minecraft:chest", "Chest");
        p_145919_.put("minecraft:trapped_chest", "Chest");
        p_145919_.put("minecraft:ender_chest", "EnderChest");
        p_145919_.put("minecraft:jukebox", "RecordPlayer");
        p_145919_.put("minecraft:dispenser", "Trap");
        p_145919_.put("minecraft:dropper", "Dropper");
        p_145919_.put("minecraft:sign", "Sign");
        p_145919_.put("minecraft:mob_spawner", "MobSpawner");
        p_145919_.put("minecraft:noteblock", "Music");
        p_145919_.put("minecraft:brewing_stand", "Cauldron");
        p_145919_.put("minecraft:enhanting_table", "EnchantTable");
        p_145919_.put("minecraft:command_block", "CommandBlock");
        p_145919_.put("minecraft:beacon", "Beacon");
        p_145919_.put("minecraft:skull", "Skull");
        p_145919_.put("minecraft:daylight_detector", "DLDetector");
        p_145919_.put("minecraft:hopper", "Hopper");
        p_145919_.put("minecraft:banner", "Banner");
        p_145919_.put("minecraft:flower_pot", "FlowerPot");
        p_145919_.put("minecraft:repeating_command_block", "CommandBlock");
        p_145919_.put("minecraft:chain_command_block", "CommandBlock");
        p_145919_.put("minecraft:standing_sign", "Sign");
        p_145919_.put("minecraft:wall_sign", "Sign");
        p_145919_.put("minecraft:piston_head", "Piston");
        p_145919_.put("minecraft:daylight_detector_inverted", "DLDetector");
        p_145919_.put("minecraft:unpowered_comparator", "Comparator");
        p_145919_.put("minecraft:powered_comparator", "Comparator");
        p_145919_.put("minecraft:wall_banner", "Banner");
        p_145919_.put("minecraft:standing_banner", "Banner");
        p_145919_.put("minecraft:structure_block", "Structure");
        p_145919_.put("minecraft:end_portal", "Airportal");
        p_145919_.put("minecraft:end_gateway", "EndGateway");
        p_145919_.put("minecraft:shield", "Banner");
    });
    public static final Map<String, String> ITEM_TO_ENTITY = Map.of("minecraft:armor_stand", "ArmorStand", "minecraft:painting", "Painting");
    protected static final Hook.HookFunction ADD_NAMES = new Hook.HookFunction(){

        public <T> T apply(DynamicOps<T> p_18312_, T p_18313_) {
            return V99.addNames(new Dynamic(p_18312_, p_18313_), ITEM_TO_BLOCKENTITY, ITEM_TO_ENTITY);
        }
    };

    public V99(int p_18185_, Schema p_18186_) {
        super(p_18185_, p_18186_);
    }

    protected static void registerThrowableProjectile(Schema p_18225_, Map<String, Supplier<TypeTemplate>> p_18226_, String p_18227_) {
        p_18225_.register(p_18226_, p_18227_, () -> DSL.optionalFields((String)"inTile", (TypeTemplate)References.BLOCK_NAME.in(p_18225_)));
    }

    protected static void registerMinecart(Schema p_18237_, Map<String, Supplier<TypeTemplate>> p_18238_, String p_18239_) {
        p_18237_.register(p_18238_, p_18239_, () -> DSL.optionalFields((String)"DisplayTile", (TypeTemplate)References.BLOCK_NAME.in(p_18237_)));
    }

    protected static void registerInventory(Schema p_18247_, Map<String, Supplier<TypeTemplate>> p_18248_, String p_18249_) {
        p_18247_.register(p_18248_, p_18249_, () -> DSL.optionalFields((String)"Items", (TypeTemplate)DSL.list((TypeTemplate)References.ITEM_STACK.in(p_18247_))));
    }

    public Map<String, Supplier<TypeTemplate>> registerEntities(Schema p_18305_) {
        HashMap map = Maps.newHashMap();
        p_18305_.register((Map)map, "Item", p_18301_ -> DSL.optionalFields((String)"Item", (TypeTemplate)References.ITEM_STACK.in(p_18305_)));
        p_18305_.registerSimple((Map)map, "XPOrb");
        V99.registerThrowableProjectile(p_18305_, map, "ThrownEgg");
        p_18305_.registerSimple((Map)map, "LeashKnot");
        p_18305_.registerSimple((Map)map, "Painting");
        p_18305_.register((Map)map, "Arrow", p_18295_ -> DSL.optionalFields((String)"inTile", (TypeTemplate)References.BLOCK_NAME.in(p_18305_)));
        p_18305_.register((Map)map, "TippedArrow", p_18292_ -> DSL.optionalFields((String)"inTile", (TypeTemplate)References.BLOCK_NAME.in(p_18305_)));
        p_18305_.register((Map)map, "SpectralArrow", p_397755_ -> DSL.optionalFields((String)"inTile", (TypeTemplate)References.BLOCK_NAME.in(p_18305_)));
        V99.registerThrowableProjectile(p_18305_, map, "Snowball");
        V99.registerThrowableProjectile(p_18305_, map, "Fireball");
        V99.registerThrowableProjectile(p_18305_, map, "SmallFireball");
        V99.registerThrowableProjectile(p_18305_, map, "ThrownEnderpearl");
        p_18305_.registerSimple((Map)map, "EyeOfEnderSignal");
        p_18305_.register((Map)map, "ThrownPotion", p_18289_ -> DSL.optionalFields((String)"inTile", (TypeTemplate)References.BLOCK_NAME.in(p_18305_), (String)"Potion", (TypeTemplate)References.ITEM_STACK.in(p_18305_)));
        V99.registerThrowableProjectile(p_18305_, map, "ThrownExpBottle");
        p_18305_.register((Map)map, "ItemFrame", p_18284_ -> DSL.optionalFields((String)"Item", (TypeTemplate)References.ITEM_STACK.in(p_18305_)));
        V99.registerThrowableProjectile(p_18305_, map, "WitherSkull");
        p_18305_.registerSimple((Map)map, "PrimedTnt");
        p_18305_.register((Map)map, "FallingSand", p_18279_ -> DSL.optionalFields((String)"Block", (TypeTemplate)References.BLOCK_NAME.in(p_18305_), (String)"TileEntityData", (TypeTemplate)References.BLOCK_ENTITY.in(p_18305_)));
        p_18305_.register((Map)map, "FireworksRocketEntity", p_18274_ -> DSL.optionalFields((String)"FireworksItem", (TypeTemplate)References.ITEM_STACK.in(p_18305_)));
        p_18305_.registerSimple((Map)map, "Boat");
        p_18305_.register((Map)map, "Minecart", () -> DSL.optionalFields((String)"DisplayTile", (TypeTemplate)References.BLOCK_NAME.in(p_18305_), (String)"Items", (TypeTemplate)DSL.list((TypeTemplate)References.ITEM_STACK.in(p_18305_))));
        V99.registerMinecart(p_18305_, map, "MinecartRideable");
        p_18305_.register((Map)map, "MinecartChest", p_18269_ -> DSL.optionalFields((String)"DisplayTile", (TypeTemplate)References.BLOCK_NAME.in(p_18305_), (String)"Items", (TypeTemplate)DSL.list((TypeTemplate)References.ITEM_STACK.in(p_18305_))));
        V99.registerMinecart(p_18305_, map, "MinecartFurnace");
        V99.registerMinecart(p_18305_, map, "MinecartTNT");
        p_18305_.register((Map)map, "MinecartSpawner", () -> DSL.optionalFields((String)"DisplayTile", (TypeTemplate)References.BLOCK_NAME.in(p_18305_), (TypeTemplate)References.UNTAGGED_SPAWNER.in(p_18305_)));
        p_18305_.register((Map)map, "MinecartHopper", p_18264_ -> DSL.optionalFields((String)"DisplayTile", (TypeTemplate)References.BLOCK_NAME.in(p_18305_), (String)"Items", (TypeTemplate)DSL.list((TypeTemplate)References.ITEM_STACK.in(p_18305_))));
        p_18305_.register((Map)map, "MinecartCommandBlock", () -> DSL.optionalFields((String)"DisplayTile", (TypeTemplate)References.BLOCK_NAME.in(p_18305_), (String)"LastOutput", (TypeTemplate)References.TEXT_COMPONENT.in(p_18305_)));
        p_18305_.registerSimple((Map)map, "ArmorStand");
        p_18305_.registerSimple((Map)map, "Creeper");
        p_18305_.registerSimple((Map)map, "Skeleton");
        p_18305_.registerSimple((Map)map, "Spider");
        p_18305_.registerSimple((Map)map, "Giant");
        p_18305_.registerSimple((Map)map, "Zombie");
        p_18305_.registerSimple((Map)map, "Slime");
        p_18305_.registerSimple((Map)map, "Ghast");
        p_18305_.registerSimple((Map)map, "PigZombie");
        p_18305_.register((Map)map, "Enderman", p_18298_ -> DSL.optionalFields((String)"carried", (TypeTemplate)References.BLOCK_NAME.in(p_18305_)));
        p_18305_.registerSimple((Map)map, "CaveSpider");
        p_18305_.registerSimple((Map)map, "Silverfish");
        p_18305_.registerSimple((Map)map, "Blaze");
        p_18305_.registerSimple((Map)map, "LavaSlime");
        p_18305_.registerSimple((Map)map, "EnderDragon");
        p_18305_.registerSimple((Map)map, "WitherBoss");
        p_18305_.registerSimple((Map)map, "Bat");
        p_18305_.registerSimple((Map)map, "Witch");
        p_18305_.registerSimple((Map)map, "Endermite");
        p_18305_.registerSimple((Map)map, "Guardian");
        p_18305_.registerSimple((Map)map, "Pig");
        p_18305_.registerSimple((Map)map, "Sheep");
        p_18305_.registerSimple((Map)map, "Cow");
        p_18305_.registerSimple((Map)map, "Chicken");
        p_18305_.registerSimple((Map)map, "Squid");
        p_18305_.registerSimple((Map)map, "Wolf");
        p_18305_.registerSimple((Map)map, "MushroomCow");
        p_18305_.registerSimple((Map)map, "SnowMan");
        p_18305_.registerSimple((Map)map, "Ozelot");
        p_18305_.registerSimple((Map)map, "VillagerGolem");
        p_18305_.register((Map)map, "EntityHorse", p_396663_ -> DSL.optionalFields((String)"Items", (TypeTemplate)DSL.list((TypeTemplate)References.ITEM_STACK.in(p_18305_)), (String)"ArmorItem", (TypeTemplate)References.ITEM_STACK.in(p_18305_), (String)"SaddleItem", (TypeTemplate)References.ITEM_STACK.in(p_18305_)));
        p_18305_.registerSimple((Map)map, "Rabbit");
        p_18305_.register((Map)map, "Villager", p_396658_ -> DSL.optionalFields((String)"Inventory", (TypeTemplate)DSL.list((TypeTemplate)References.ITEM_STACK.in(p_18305_)), (String)"Offers", (TypeTemplate)DSL.optionalFields((String)"Recipes", (TypeTemplate)DSL.list((TypeTemplate)References.VILLAGER_TRADE.in(p_18305_)))));
        p_18305_.registerSimple((Map)map, "EnderCrystal");
        p_18305_.register((Map)map, "AreaEffectCloud", p_340704_ -> DSL.optionalFields((String)"Particle", (TypeTemplate)References.PARTICLE.in(p_18305_)));
        p_18305_.registerSimple((Map)map, "ShulkerBullet");
        p_18305_.registerSimple((Map)map, "DragonFireball");
        p_18305_.registerSimple((Map)map, "Shulker");
        return map;
    }

    public Map<String, Supplier<TypeTemplate>> registerBlockEntities(Schema p_18303_) {
        HashMap map = Maps.newHashMap();
        V99.registerInventory(p_18303_, map, "Furnace");
        V99.registerInventory(p_18303_, map, "Chest");
        p_18303_.registerSimple((Map)map, "EnderChest");
        p_18303_.register((Map)map, "RecordPlayer", p_18235_ -> DSL.optionalFields((String)"RecordItem", (TypeTemplate)References.ITEM_STACK.in(p_18303_)));
        V99.registerInventory(p_18303_, map, "Trap");
        V99.registerInventory(p_18303_, map, "Dropper");
        p_18303_.register((Map)map, "Sign", () -> V99.sign(p_18303_));
        p_18303_.register((Map)map, "MobSpawner", p_18223_ -> References.UNTAGGED_SPAWNER.in(p_18303_));
        p_18303_.registerSimple((Map)map, "Music");
        p_18303_.registerSimple((Map)map, "Piston");
        V99.registerInventory(p_18303_, map, "Cauldron");
        p_18303_.registerSimple((Map)map, "EnchantTable");
        p_18303_.registerSimple((Map)map, "Airportal");
        p_18303_.register((Map)map, "Control", () -> DSL.optionalFields((String)"LastOutput", (TypeTemplate)References.TEXT_COMPONENT.in(p_18303_)));
        p_18303_.registerSimple((Map)map, "Beacon");
        p_18303_.register((Map)map, "Skull", () -> DSL.optionalFields((String)"custom_name", (TypeTemplate)References.TEXT_COMPONENT.in(p_18303_)));
        p_18303_.registerSimple((Map)map, "DLDetector");
        V99.registerInventory(p_18303_, map, "Hopper");
        p_18303_.registerSimple((Map)map, "Comparator");
        p_18303_.register((Map)map, "FlowerPot", p_18192_ -> DSL.optionalFields((String)"Item", (TypeTemplate)DSL.or((TypeTemplate)DSL.constType((Type)DSL.intType()), (TypeTemplate)References.ITEM_NAME.in(p_18303_))));
        p_18303_.register((Map)map, "Banner", () -> DSL.optionalFields((String)"CustomName", (TypeTemplate)References.TEXT_COMPONENT.in(p_18303_)));
        p_18303_.registerSimple((Map)map, "Structure");
        p_18303_.registerSimple((Map)map, "EndGateway");
        return map;
    }

    public static TypeTemplate sign(Schema p_393704_) {
        return DSL.optionalFields((Pair[])new Pair[]{Pair.of((Object)"Text1", (Object)References.TEXT_COMPONENT.in(p_393704_)), Pair.of((Object)"Text2", (Object)References.TEXT_COMPONENT.in(p_393704_)), Pair.of((Object)"Text3", (Object)References.TEXT_COMPONENT.in(p_393704_)), Pair.of((Object)"Text4", (Object)References.TEXT_COMPONENT.in(p_393704_)), Pair.of((Object)"FilteredText1", (Object)References.TEXT_COMPONENT.in(p_393704_)), Pair.of((Object)"FilteredText2", (Object)References.TEXT_COMPONENT.in(p_393704_)), Pair.of((Object)"FilteredText3", (Object)References.TEXT_COMPONENT.in(p_393704_)), Pair.of((Object)"FilteredText4", (Object)References.TEXT_COMPONENT.in(p_393704_))});
    }

    public void registerTypes(Schema p_18307_, Map<String, Supplier<TypeTemplate>> p_18308_, Map<String, Supplier<TypeTemplate>> p_18309_) {
        p_18307_.registerType(false, References.LEVEL, () -> DSL.optionalFields((String)"CustomBossEvents", (TypeTemplate)DSL.compoundList((TypeTemplate)DSL.optionalFields((String)"Name", (TypeTemplate)References.TEXT_COMPONENT.in(p_18307_))), (TypeTemplate)References.LIGHTWEIGHT_LEVEL.in(p_18307_)));
        p_18307_.registerType(false, References.LIGHTWEIGHT_LEVEL, DSL::remainder);
        p_18307_.registerType(false, References.PLAYER, () -> DSL.optionalFields((String)"Inventory", (TypeTemplate)DSL.list((TypeTemplate)References.ITEM_STACK.in(p_18307_)), (String)"EnderItems", (TypeTemplate)DSL.list((TypeTemplate)References.ITEM_STACK.in(p_18307_))));
        p_18307_.registerType(false, References.CHUNK, () -> DSL.fields((String)"Level", (TypeTemplate)DSL.optionalFields((String)"Entities", (TypeTemplate)DSL.list((TypeTemplate)References.ENTITY_TREE.in(p_18307_)), (String)"TileEntities", (TypeTemplate)DSL.list((TypeTemplate)DSL.or((TypeTemplate)References.BLOCK_ENTITY.in(p_18307_), (TypeTemplate)DSL.remainder())), (String)"TileTicks", (TypeTemplate)DSL.list((TypeTemplate)DSL.fields((String)"i", (TypeTemplate)References.BLOCK_NAME.in(p_18307_))))));
        p_18307_.registerType(true, References.BLOCK_ENTITY, () -> DSL.optionalFields((String)"components", (TypeTemplate)References.DATA_COMPONENTS.in(p_18307_), (TypeTemplate)DSL.taggedChoiceLazy((String)"id", (Type)DSL.string(), (Map)p_18309_)));
        p_18307_.registerType(true, References.ENTITY_TREE, () -> DSL.optionalFields((String)"Riding", (TypeTemplate)References.ENTITY_TREE.in(p_18307_), (TypeTemplate)References.ENTITY.in(p_18307_)));
        p_18307_.registerType(false, References.ENTITY_NAME, () -> DSL.constType(NamespacedSchema.namespacedString()));
        p_18307_.registerType(true, References.ENTITY, () -> DSL.and((TypeTemplate)References.ENTITY_EQUIPMENT.in(p_18307_), (TypeTemplate)DSL.optionalFields((String)"CustomName", (TypeTemplate)DSL.constType((Type)DSL.string()), (TypeTemplate)DSL.taggedChoiceLazy((String)"id", (Type)DSL.string(), (Map)p_18308_))));
        p_18307_.registerType(true, References.ITEM_STACK, () -> DSL.hook((TypeTemplate)DSL.optionalFields((String)"id", (TypeTemplate)DSL.or((TypeTemplate)DSL.constType((Type)DSL.intType()), (TypeTemplate)References.ITEM_NAME.in(p_18307_)), (String)"tag", (TypeTemplate)V99.itemStackTag(p_18307_)), (Hook.HookFunction)ADD_NAMES, (Hook.HookFunction)Hook.HookFunction.IDENTITY));
        p_18307_.registerType(false, References.OPTIONS, DSL::remainder);
        p_18307_.registerType(false, References.BLOCK_NAME, () -> DSL.or((TypeTemplate)DSL.constType((Type)DSL.intType()), (TypeTemplate)DSL.constType(NamespacedSchema.namespacedString())));
        p_18307_.registerType(false, References.ITEM_NAME, () -> DSL.constType(NamespacedSchema.namespacedString()));
        p_18307_.registerType(false, References.STATS, DSL::remainder);
        p_18307_.registerType(false, References.SAVED_DATA_COMMAND_STORAGE, DSL::remainder);
        p_18307_.registerType(false, References.SAVED_DATA_TICKETS, DSL::remainder);
        p_18307_.registerType(false, References.SAVED_DATA_MAP_DATA, () -> DSL.optionalFields((String)"data", (TypeTemplate)DSL.optionalFields((String)"banners", (TypeTemplate)DSL.list((TypeTemplate)DSL.optionalFields((String)"Name", (TypeTemplate)References.TEXT_COMPONENT.in(p_18307_))))));
        p_18307_.registerType(false, References.SAVED_DATA_MAP_INDEX, DSL::remainder);
        p_18307_.registerType(false, References.SAVED_DATA_RAIDS, DSL::remainder);
        p_18307_.registerType(false, References.SAVED_DATA_RANDOM_SEQUENCES, DSL::remainder);
        p_18307_.registerType(false, References.SAVED_DATA_SCOREBOARD, () -> DSL.optionalFields((String)"data", (TypeTemplate)DSL.optionalFields((String)"Objectives", (TypeTemplate)DSL.list((TypeTemplate)References.OBJECTIVE.in(p_18307_)), (String)"Teams", (TypeTemplate)DSL.list((TypeTemplate)References.TEAM.in(p_18307_)), (String)"PlayerScores", (TypeTemplate)DSL.list((TypeTemplate)DSL.optionalFields((String)"display", (TypeTemplate)References.TEXT_COMPONENT.in(p_18307_))))));
        p_18307_.registerType(false, References.SAVED_DATA_STRUCTURE_FEATURE_INDICES, () -> DSL.optionalFields((String)"data", (TypeTemplate)DSL.optionalFields((String)"Features", (TypeTemplate)DSL.compoundList((TypeTemplate)References.STRUCTURE_FEATURE.in(p_18307_)))));
        p_18307_.registerType(false, References.STRUCTURE_FEATURE, DSL::remainder);
        p_18307_.registerType(false, References.OBJECTIVE, DSL::remainder);
        p_18307_.registerType(false, References.TEAM, () -> DSL.optionalFields((String)"MemberNamePrefix", (TypeTemplate)References.TEXT_COMPONENT.in(p_18307_), (String)"MemberNameSuffix", (TypeTemplate)References.TEXT_COMPONENT.in(p_18307_), (String)"DisplayName", (TypeTemplate)References.TEXT_COMPONENT.in(p_18307_)));
        p_18307_.registerType(true, References.UNTAGGED_SPAWNER, DSL::remainder);
        p_18307_.registerType(false, References.POI_CHUNK, DSL::remainder);
        p_18307_.registerType(false, References.WORLD_GEN_SETTINGS, DSL::remainder);
        p_18307_.registerType(false, References.ENTITY_CHUNK, () -> DSL.optionalFields((String)"Entities", (TypeTemplate)DSL.list((TypeTemplate)References.ENTITY_TREE.in(p_18307_))));
        p_18307_.registerType(true, References.DATA_COMPONENTS, DSL::remainder);
        p_18307_.registerType(true, References.VILLAGER_TRADE, () -> DSL.optionalFields((String)"buy", (TypeTemplate)References.ITEM_STACK.in(p_18307_), (String)"buyB", (TypeTemplate)References.ITEM_STACK.in(p_18307_), (String)"sell", (TypeTemplate)References.ITEM_STACK.in(p_18307_)));
        p_18307_.registerType(true, References.PARTICLE, () -> DSL.constType((Type)DSL.string()));
        p_18307_.registerType(true, References.TEXT_COMPONENT, () -> DSL.constType((Type)DSL.string()));
        p_18307_.registerType(false, References.STRUCTURE, () -> DSL.optionalFields((String)"entities", (TypeTemplate)DSL.list((TypeTemplate)DSL.optionalFields((String)"nbt", (TypeTemplate)References.ENTITY_TREE.in(p_18307_))), (String)"blocks", (TypeTemplate)DSL.list((TypeTemplate)DSL.optionalFields((String)"nbt", (TypeTemplate)References.BLOCK_ENTITY.in(p_18307_))), (String)"palette", (TypeTemplate)DSL.list((TypeTemplate)References.BLOCK_STATE.in(p_18307_))));
        p_18307_.registerType(false, References.BLOCK_STATE, DSL::remainder);
        p_18307_.registerType(false, References.FLAT_BLOCK_STATE, DSL::remainder);
        p_18307_.registerType(true, References.ENTITY_EQUIPMENT, () -> DSL.optional((TypeTemplate)DSL.field((String)"Equipment", (TypeTemplate)DSL.list((TypeTemplate)References.ITEM_STACK.in(p_18307_)))));
    }

    public static TypeTemplate itemStackTag(Schema p_393766_) {
        return DSL.optionalFields((Pair[])new Pair[]{Pair.of((Object)"EntityTag", (Object)References.ENTITY_TREE.in(p_393766_)), Pair.of((Object)"BlockEntityTag", (Object)References.BLOCK_ENTITY.in(p_393766_)), Pair.of((Object)"CanDestroy", (Object)DSL.list((TypeTemplate)References.BLOCK_NAME.in(p_393766_))), Pair.of((Object)"CanPlaceOn", (Object)DSL.list((TypeTemplate)References.BLOCK_NAME.in(p_393766_))), Pair.of((Object)"Items", (Object)DSL.list((TypeTemplate)References.ITEM_STACK.in(p_393766_))), Pair.of((Object)"ChargedProjectiles", (Object)DSL.list((TypeTemplate)References.ITEM_STACK.in(p_393766_))), Pair.of((Object)"pages", (Object)DSL.list((TypeTemplate)References.TEXT_COMPONENT.in(p_393766_))), Pair.of((Object)"filtered_pages", (Object)DSL.compoundList((TypeTemplate)References.TEXT_COMPONENT.in(p_393766_))), Pair.of((Object)"display", (Object)DSL.optionalFields((String)"Name", (TypeTemplate)References.TEXT_COMPONENT.in(p_393766_), (String)"Lore", (TypeTemplate)DSL.list((TypeTemplate)References.TEXT_COMPONENT.in(p_393766_))))});
    }

    protected static <T> T addNames(Dynamic<T> p_18206_, Map<String, String> p_18207_, Map<String, String> p_332665_) {
        return (T)p_18206_.update("tag", p_145917_ -> p_145917_.update("BlockEntityTag", p_145912_ -> {
            String s = p_18206_.get("id").asString().result().map(NamespacedSchema::ensureNamespaced).orElse("minecraft:air");
            if (!"minecraft:air".equals(s)) {
                String s1 = (String)p_18207_.get(s);
                if (s1 != null) {
                    return p_145912_.set("id", p_18206_.createString(s1));
                }
                LOGGER.warn("Unable to resolve BlockEntity for ItemStack: {}", (Object)s);
            }
            return p_145912_;
        }).update("EntityTag", p_347072_ -> {
            if (p_347072_.get("id").result().isPresent()) {
                return p_347072_;
            }
            String s = NamespacedSchema.ensureNamespaced(p_18206_.get("id").asString(""));
            String s1 = (String)p_332665_.get(s);
            return s1 != null ? p_347072_.set("id", p_18206_.createString(s1)) : p_347072_;
        })).getValue();
    }
}

