/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import java.util.Set;
import net.minecraft.util.datafix.fixes.References;

public class WallPropertyFix
extends DataFix {
    private static final Set<String> WALL_BLOCKS = ImmutableSet.of((Object)"minecraft:andesite_wall", (Object)"minecraft:brick_wall", (Object)"minecraft:cobblestone_wall", (Object)"minecraft:diorite_wall", (Object)"minecraft:end_stone_brick_wall", (Object)"minecraft:granite_wall", (Object[])new String[]{"minecraft:mossy_cobblestone_wall", "minecraft:mossy_stone_brick_wall", "minecraft:nether_brick_wall", "minecraft:prismarine_wall", "minecraft:red_nether_brick_wall", "minecraft:red_sandstone_wall", "minecraft:sandstone_wall", "minecraft:stone_brick_wall"});

    public WallPropertyFix(Schema p_17154_, boolean p_17155_) {
        super(p_17154_, p_17155_);
    }

    public TypeRewriteRule makeRule() {
        return this.fixTypeEverywhereTyped("WallPropertyFix", this.getInputSchema().getType(References.BLOCK_STATE), p_17157_ -> p_17157_.update(DSL.remainderFinder(), WallPropertyFix::upgradeBlockStateTag));
    }

    private static String mapProperty(String p_17164_) {
        return "true".equals(p_17164_) ? "low" : "none";
    }

    private static <T> Dynamic<T> fixWallProperty(Dynamic<T> p_17161_, String p_17162_) {
        return p_17161_.update(p_17162_, p_337669_ -> (Dynamic)DataFixUtils.orElse(p_337669_.asString().result().map(WallPropertyFix::mapProperty).map(arg_0 -> ((Dynamic)p_337669_).createString(arg_0)), (Object)p_337669_));
    }

    private static <T> Dynamic<T> upgradeBlockStateTag(Dynamic<T> p_17159_) {
        boolean flag = p_17159_.get("Name").asString().result().filter(WALL_BLOCKS::contains).isPresent();
        return !flag ? p_17159_ : p_17159_.update("Properties", p_17166_ -> {
            Dynamic dynamic = WallPropertyFix.fixWallProperty(p_17166_, "east");
            dynamic = WallPropertyFix.fixWallProperty(dynamic, "west");
            dynamic = WallPropertyFix.fixWallProperty(dynamic, "north");
            return WallPropertyFix.fixWallProperty(dynamic, "south");
        });
    }
}

