/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Optional;
import net.minecraft.util.datafix.fixes.References;

public class OverreachingTickFix
extends DataFix {
    public OverreachingTickFix(Schema p_207654_) {
        super(p_207654_, false);
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(References.CHUNK);
        OpticFinder opticfinder = type.findField("block_ticks");
        return this.fixTypeEverywhereTyped("Handle ticks saved in the wrong chunk", type, p_337660_ -> {
            Optional optional = p_337660_.getOptionalTyped(opticfinder);
            Optional optional1 = optional.isPresent() ? ((Typed)optional.get()).write().result() : Optional.empty();
            return p_337660_.update(DSL.remainderFinder(), p_337658_ -> {
                int i = p_337658_.get("xPos").asInt(0);
                int j = p_337658_.get("zPos").asInt(0);
                Optional optional2 = p_337658_.get("fluid_ticks").get().result();
                p_337658_ = OverreachingTickFix.extractOverreachingTicks(p_337658_, i, j, optional1, "neighbor_block_ticks");
                return OverreachingTickFix.extractOverreachingTicks(p_337658_, i, j, optional2, "neighbor_fluid_ticks");
            });
        });
    }

    private static Dynamic<?> extractOverreachingTicks(Dynamic<?> p_207663_, int p_207664_, int p_207665_, Optional<? extends Dynamic<?>> p_207666_, String p_207667_) {
        List<Dynamic> list;
        if (p_207666_.isPresent() && !(list = p_207666_.get().asStream().filter(p_207658_ -> {
            int i = p_207658_.get("x").asInt(0);
            int j = p_207658_.get("z").asInt(0);
            int k = Math.abs(p_207664_ - (i >> 4));
            int l = Math.abs(p_207665_ - (j >> 4));
            return (k != 0 || l != 0) && k <= 1 && l <= 1;
        }).toList()).isEmpty()) {
            p_207663_ = p_207663_.set("UpgradeData", p_207663_.get("UpgradeData").orElseEmptyMap().set(p_207667_, p_207663_.createList(list.stream())));
        }
        return p_207663_;
    }
}

