/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.escape.Escaper;
import com.google.common.escape.Escapers;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.util.datafix.fixes.DataComponentRemainderFix;

public class LockComponentPredicateFix
extends DataComponentRemainderFix {
    public static final Escaper ESCAPER = Escapers.builder().addEscape('\"', "\\\"").addEscape('\\', "\\\\").build();

    public LockComponentPredicateFix(Schema p_376234_) {
        super(p_376234_, "LockComponentPredicateFix", "minecraft:lock");
    }

    @Override
    @Nullable
    protected <T> Dynamic<T> fixComponent(Dynamic<T> p_376828_) {
        return LockComponentPredicateFix.fixLock(p_376828_);
    }

    @Nullable
    public static <T> Dynamic<T> fixLock(Dynamic<T> p_376818_) {
        Optional optional = p_376818_.asString().result();
        if (optional.isEmpty()) {
            return null;
        }
        if (((String)optional.get()).isEmpty()) {
            return null;
        }
        Dynamic dynamic = p_376818_.createString("\"" + ESCAPER.escape((String)optional.get()) + "\"");
        Dynamic dynamic1 = p_376818_.emptyMap().set("minecraft:custom_name", dynamic);
        return p_376818_.emptyMap().set("components", dynamic1);
    }
}

