/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.gson.JsonElement;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JavaOps;
import com.mojang.serialization.JsonOps;
import java.util.Map;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.datafix.fixes.References;

public class LegacyHoverEventFix
extends DataFix {
    public LegacyHoverEventFix(Schema p_394437_) {
        super(p_394437_, false);
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(References.TEXT_COMPONENT).findFieldType("hoverEvent");
        return this.createFixer(this.getInputSchema().getTypeRaw(References.TEXT_COMPONENT), type);
    }

    private <C, H extends Pair<String, ?>> TypeRewriteRule createFixer(Type<C> p_393921_, Type<H> p_393491_) {
        Type type = DSL.named((String)References.TEXT_COMPONENT.typeName(), (Type)DSL.or((Type)DSL.or((Type)DSL.string(), (Type)DSL.list(p_393921_)), (Type)DSL.and((Type)DSL.optional((Type)DSL.field((String)"extra", (Type)DSL.list(p_393921_))), (Type)DSL.optional((Type)DSL.field((String)"separator", p_393921_)), (Type)DSL.optional((Type)DSL.field((String)"hoverEvent", p_393491_)), (Type)DSL.remainderType())));
        if (!type.equals((Object)this.getInputSchema().getType(References.TEXT_COMPONENT))) {
            throw new IllegalStateException("Text component type did not match, expected " + String.valueOf(type) + " but got " + String.valueOf(this.getInputSchema().getType(References.TEXT_COMPONENT)));
        }
        return this.fixTypeEverywhere("LegacyHoverEventFix", type, p_394584_ -> p_394164_ -> p_394164_.mapSecond(p_393535_ -> p_393535_.mapRight(p_394347_ -> p_394347_.mapSecond(p_393557_ -> p_393557_.mapSecond(p_394017_ -> {
            Dynamic dynamic = (Dynamic)p_394017_.getSecond();
            Optional optional = dynamic.get("hoverEvent").result();
            if (optional.isEmpty()) {
                return p_394017_;
            }
            Optional optional1 = ((Dynamic)optional.get()).get("value").result();
            if (optional1.isEmpty()) {
                return p_394017_;
            }
            String s = ((Either)p_394017_.getFirst()).left().map(Pair::getFirst).orElse("");
            Pair h = (Pair)this.fixHoverEvent(p_393491_, s, (Dynamic)optional.get());
            return p_394017_.mapFirst(p_393590_ -> Either.left((Object)h));
        })))));
    }

    private <H> H fixHoverEvent(Type<H> p_394028_, String p_394084_, Dynamic<?> p_394517_) {
        return "show_text".equals(p_394084_) ? LegacyHoverEventFix.fixShowTextHover(p_394028_, p_394517_) : LegacyHoverEventFix.createPlaceholderHover(p_394028_, p_394517_);
    }

    private static <H> H fixShowTextHover(Type<H> p_393521_, Dynamic<?> p_394195_) {
        Dynamic dynamic = p_394195_.renameField("value", "contents");
        return (H)Util.readTypedOrThrow(p_393521_, dynamic).getValue();
    }

    private static <H> H createPlaceholderHover(Type<H> p_393539_, Dynamic<?> p_394275_) {
        JsonElement jsonelement = (JsonElement)p_394275_.convert((DynamicOps)JsonOps.INSTANCE).getValue();
        Dynamic dynamic = new Dynamic((DynamicOps)JavaOps.INSTANCE, Map.of("action", "show_text", "contents", Map.of("text", "Legacy hoverEvent: " + GsonHelper.toStableString(jsonelement))));
        return (H)Util.readTypedOrThrow(p_393539_, dynamic).getValue();
    }
}

