/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.Optional;
import net.minecraft.util.datafix.fixes.References;

public class HeightmapRenamingFix
extends DataFix {
    public HeightmapRenamingFix(Schema p_15891_, boolean p_15892_) {
        super(p_15891_, p_15892_);
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(References.CHUNK);
        OpticFinder opticfinder = type.findField("Level");
        return this.fixTypeEverywhereTyped("HeightmapRenamingFix", type, p_15895_ -> p_15895_.updateTyped(opticfinder, p_145380_ -> p_145380_.update(DSL.remainderFinder(), this::fix)));
    }

    private Dynamic<?> fix(Dynamic<?> p_15899_) {
        Optional optional4;
        Optional optional3;
        Optional optional2;
        Optional optional = p_15899_.get("Heightmaps").result();
        if (optional.isEmpty()) {
            return p_15899_;
        }
        Dynamic dynamic = (Dynamic)optional.get();
        Optional optional1 = dynamic.get("LIQUID").result();
        if (optional1.isPresent()) {
            dynamic = dynamic.remove("LIQUID");
            dynamic = dynamic.set("WORLD_SURFACE_WG", (Dynamic)optional1.get());
        }
        if ((optional2 = dynamic.get("SOLID").result()).isPresent()) {
            dynamic = dynamic.remove("SOLID");
            dynamic = dynamic.set("OCEAN_FLOOR_WG", (Dynamic)optional2.get());
            dynamic = dynamic.set("OCEAN_FLOOR", (Dynamic)optional2.get());
        }
        if ((optional3 = dynamic.get("LIGHT").result()).isPresent()) {
            dynamic = dynamic.remove("LIGHT");
            dynamic = dynamic.set("LIGHT_BLOCKING", (Dynamic)optional3.get());
        }
        if ((optional4 = dynamic.get("RAIN").result()).isPresent()) {
            dynamic = dynamic.remove("RAIN");
            dynamic = dynamic.set("MOTION_BLOCKING", (Dynamic)optional4.get());
            dynamic = dynamic.set("MOTION_BLOCKING_NO_LEAVES", (Dynamic)optional4.get());
        }
        return p_15899_.set("Heightmaps", dynamic);
    }
}

