/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.util.datafix.fixes.References;

public class FeatureFlagRemoveFix
extends DataFix {
    private final String name;
    private final Set<String> flagsToRemove;

    public FeatureFlagRemoveFix(Schema p_277930_, String p_277628_, Set<String> p_277886_) {
        super(p_277930_, false);
        this.name = p_277628_;
        this.flagsToRemove = p_277886_;
    }

    protected TypeRewriteRule makeRule() {
        return this.fixTypeEverywhereTyped(this.name, this.getInputSchema().getType(References.LIGHTWEIGHT_LEVEL), p_277407_ -> p_277407_.update(DSL.remainderFinder(), this::fixTag));
    }

    private <T> Dynamic<T> fixTag(Dynamic<T> p_277583_) {
        List list = p_277583_.get("removed_features").asStream().collect(Collectors.toCollection(ArrayList::new));
        Dynamic dynamic = p_277583_.update("enabled_features", p_337630_ -> (Dynamic)DataFixUtils.orElse(p_337630_.asStreamOpt().result().map(p_277400_ -> p_277400_.filter(p_337627_ -> {
            Optional optional = p_337627_.asString().result();
            if (optional.isEmpty()) {
                return true;
            }
            boolean flag = this.flagsToRemove.contains(optional.get());
            if (flag) {
                list.add(p_277583_.createString((String)optional.get()));
            }
            return !flag;
        })).map(arg_0 -> ((Dynamic)p_277583_).createList(arg_0)), (Object)p_337630_));
        if (!list.isEmpty()) {
            dynamic = dynamic.set("removed_features", p_277583_.createList(list.stream()));
        }
        return dynamic;
    }
}

