/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.datafixers.util.Unit;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.util.datafix.fixes.References;

public class EquipmentFormatFix
extends DataFix {
    public EquipmentFormatFix(Schema p_397502_) {
        super(p_397502_, true);
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getTypeRaw(References.ITEM_STACK);
        Type type1 = this.getOutputSchema().getTypeRaw(References.ITEM_STACK);
        OpticFinder opticfinder = type.findField("id");
        return this.fix(type, type1, opticfinder);
    }

    private <ItemStackOld, ItemStackNew> TypeRewriteRule fix(Type<ItemStackOld> p_397976_, Type<ItemStackNew> p_397681_, OpticFinder<?> p_397996_) {
        Type type = DSL.named((String)References.ENTITY_EQUIPMENT.typeName(), (Type)DSL.and((Type)DSL.optional((Type)DSL.field((String)"ArmorItems", (Type)DSL.list(p_397976_))), (Type)DSL.optional((Type)DSL.field((String)"HandItems", (Type)DSL.list(p_397976_))), (Type)DSL.optional((Type)DSL.field((String)"body_armor_item", p_397976_)), (Type)DSL.optional((Type)DSL.field((String)"saddle", p_397976_))));
        Type type1 = DSL.named((String)References.ENTITY_EQUIPMENT.typeName(), (Type)DSL.optional((Type)DSL.field((String)"equipment", (Type)DSL.and((Type)DSL.optional((Type)DSL.field((String)"mainhand", p_397681_)), (Type)DSL.optional((Type)DSL.field((String)"offhand", p_397681_)), (Type)DSL.optional((Type)DSL.field((String)"feet", p_397681_)), (Type)DSL.and((Type)DSL.optional((Type)DSL.field((String)"legs", p_397681_)), (Type)DSL.optional((Type)DSL.field((String)"chest", p_397681_)), (Type)DSL.optional((Type)DSL.field((String)"head", p_397681_)), (Type)DSL.and((Type)DSL.optional((Type)DSL.field((String)"body", p_397681_)), (Type)DSL.optional((Type)DSL.field((String)"saddle", p_397681_)), (Type)DSL.remainderType()))))));
        if (!type.equals((Object)this.getInputSchema().getType(References.ENTITY_EQUIPMENT))) {
            throw new IllegalStateException("Input entity_equipment type does not match expected");
        }
        if (!type1.equals((Object)this.getOutputSchema().getType(References.ENTITY_EQUIPMENT))) {
            throw new IllegalStateException("Output entity_equipment type does not match expected");
        }
        return this.fixTypeEverywhere("EquipmentFormatFix", type, type1, p_397464_ -> {
            Predicate<Object> predicate = p_397199_ -> {
                Typed typed = new Typed(p_397976_, p_397464_, p_397199_);
                return typed.getOptional(p_397996_).isEmpty();
            };
            return p_397594_ -> {
                String s = (String)p_397594_.getFirst();
                Pair pair = (Pair)p_397594_.getSecond();
                List list = (List)((Either)pair.getFirst()).map(Function.identity(), p_397225_ -> List.of());
                List list1 = (List)((Either)((Pair)pair.getSecond()).getFirst()).map(Function.identity(), p_398024_ -> List.of());
                Either either = (Either)((Pair)((Pair)pair.getSecond()).getSecond()).getFirst();
                Either either1 = (Either)((Pair)((Pair)pair.getSecond()).getSecond()).getSecond();
                Either either2 = EquipmentFormatFix.getItemFromList(0, list, predicate);
                Either either3 = EquipmentFormatFix.getItemFromList(1, list, predicate);
                Either either4 = EquipmentFormatFix.getItemFromList(2, list, predicate);
                Either either5 = EquipmentFormatFix.getItemFromList(3, list, predicate);
                Either either6 = EquipmentFormatFix.getItemFromList(0, list1, predicate);
                Either either7 = EquipmentFormatFix.getItemFromList(1, list1, predicate);
                return EquipmentFormatFix.areAllEmpty(either, either1, either2, either3, either4, either5, either6, either7) ? Pair.of((Object)s, (Object)Either.right((Object)Unit.INSTANCE)) : Pair.of((Object)s, (Object)Either.left((Object)Pair.of(either6, (Object)Pair.of(either7, (Object)Pair.of(either2, (Object)Pair.of(either3, (Object)Pair.of(either4, (Object)Pair.of(either5, (Object)Pair.of((Object)either, (Object)Pair.of((Object)either1, (Object)new Dynamic(p_397464_)))))))))));
            };
        });
    }

    @SafeVarargs
    private static boolean areAllEmpty(Either<?, Unit> ... p_397988_) {
        for (Either<?, Unit> either : p_397988_) {
            if (!either.right().isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static <ItemStack> Either<ItemStack, Unit> getItemFromList(int p_397085_, List<ItemStack> p_397811_, Predicate<ItemStack> p_396985_) {
        if (p_397085_ >= p_397811_.size()) {
            return Either.right((Object)Unit.INSTANCE);
        }
        ItemStack itemstack = p_397811_.get(p_397085_);
        return p_396985_.test(itemstack) ? Either.right((Object)Unit.INSTANCE) : Either.left(itemstack);
    }
}

