/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.util.datafix.fixes.EntityRenameFix;
import net.minecraft.util.datafix.fixes.References;

public class EntityZombieSplitFix
extends EntityRenameFix {
    private final Supplier<Type<?>> zombieVillagerType = Suppliers.memoize(() -> this.getOutputSchema().getChoiceType(References.ENTITY, "ZombieVillager"));

    public EntityZombieSplitFix(Schema p_15798_) {
        super("EntityZombieSplitFix", p_15798_, true);
    }

    @Override
    protected Pair<String, Typed<?>> fix(String p_341651_, Typed<?> p_341608_) {
        String s;
        if (!p_341651_.equals("Zombie")) {
            return Pair.of((Object)p_341651_, p_341608_);
        }
        Dynamic dynamic = (Dynamic)p_341608_.getOptional(DSL.remainderFinder()).orElseThrow();
        int i = dynamic.get("ZombieType").asInt(0);
        return Pair.of((Object)s, (Object)(switch (i) {
            case 1, 2, 3, 4, 5 -> {
                s = "ZombieVillager";
                yield this.changeSchemaToZombieVillager(p_341608_, i - 1);
            }
            case 6 -> {
                s = "Husk";
                yield p_341608_;
            }
            default -> {
                s = "Zombie";
                yield p_341608_;
            }
        }).update(DSL.remainderFinder(), p_341600_ -> p_341600_.remove("ZombieType")));
    }

    private Typed<?> changeSchemaToZombieVillager(Typed<?> p_341612_, int p_341675_) {
        return Util.writeAndReadTypedOrThrow(p_341612_, this.zombieVillagerType.get(), p_341611_ -> p_341611_.set("Profession", p_341611_.createInt(p_341675_)));
    }
}

