/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.Lists;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.util.datafix.fixes.References;

public class EntityEquipmentToArmorAndHandFix
extends DataFix {
    public EntityEquipmentToArmorAndHandFix(Schema p_15417_) {
        super(p_15417_, true);
    }

    public TypeRewriteRule makeRule() {
        return this.cap(this.getInputSchema().getTypeRaw(References.ITEM_STACK), this.getOutputSchema().getTypeRaw(References.ITEM_STACK));
    }

    private <ItemStackOld, ItemStackNew> TypeRewriteRule cap(Type<ItemStackOld> p_15427_, Type<ItemStackNew> p_397424_) {
        Type type = DSL.named((String)References.ENTITY_EQUIPMENT.typeName(), (Type)DSL.optional((Type)DSL.field((String)"Equipment", (Type)DSL.list(p_15427_))));
        Type type1 = DSL.named((String)References.ENTITY_EQUIPMENT.typeName(), (Type)DSL.and((Type)DSL.optional((Type)DSL.field((String)"ArmorItems", (Type)DSL.list(p_397424_))), (Type)DSL.optional((Type)DSL.field((String)"HandItems", (Type)DSL.list(p_397424_))), (Type)DSL.optional((Type)DSL.field((String)"body_armor_item", p_397424_)), (Type)DSL.optional((Type)DSL.field((String)"saddle", p_397424_))));
        if (!type.equals((Object)this.getInputSchema().getType(References.ENTITY_EQUIPMENT))) {
            throw new IllegalStateException("Input entity_equipment type does not match expected");
        }
        if (!type1.equals((Object)this.getOutputSchema().getType(References.ENTITY_EQUIPMENT))) {
            throw new IllegalStateException("Output entity_equipment type does not match expected");
        }
        return TypeRewriteRule.seq((TypeRewriteRule)this.fixTypeEverywhereTyped("EntityEquipmentToArmorAndHandFix - drop chances", this.getInputSchema().getType(References.ENTITY), p_396575_ -> p_396575_.update(DSL.remainderFinder(), EntityEquipmentToArmorAndHandFix::fixDropChances)), (TypeRewriteRule)this.fixTypeEverywhere("EntityEquipmentToArmorAndHandFix - equipment", type, type1, p_396584_ -> {
            Object itemstacknew = ((Pair)p_397424_.read(new Dynamic(p_396584_).emptyMap()).result().orElseThrow(() -> new IllegalStateException("Could not parse newly created empty itemstack."))).getFirst();
            Either either = Either.right((Object)DSL.unit());
            return p_396581_ -> p_396581_.mapSecond(p_396578_ -> {
                List list = (List)p_396578_.map(Function.identity(), p_396582_ -> List.of());
                Either either1 = Either.right((Object)DSL.unit());
                Either either2 = Either.right((Object)DSL.unit());
                if (!list.isEmpty()) {
                    either1 = Either.left((Object)Lists.newArrayList((Object[])new Object[]{list.getFirst(), itemstacknew}));
                }
                if (list.size() > 1) {
                    ArrayList list1 = Lists.newArrayList((Object[])new Object[]{itemstacknew, itemstacknew, itemstacknew, itemstacknew});
                    for (int i = 1; i < Math.min(list.size(), 5); ++i) {
                        list1.set(i - 1, list.get(i));
                    }
                    either2 = Either.left((Object)list1);
                }
                return Pair.of((Object)either2, (Object)Pair.of((Object)either1, (Object)Pair.of((Object)either, (Object)either)));
            });
        }));
    }

    private static Dynamic<?> fixDropChances(Dynamic<?> p_397744_) {
        Optional optional = p_397744_.get("DropChances").asStreamOpt().result();
        p_397744_ = p_397744_.remove("DropChances");
        if (optional.isPresent()) {
            Iterator iterator = Stream.concat(((Stream)optional.get()).map(p_396585_ -> Float.valueOf(p_396585_.asFloat(0.0f))), Stream.generate(() -> Float.valueOf(0.0f))).iterator();
            float f = ((Float)iterator.next()).floatValue();
            if (p_397744_.get("HandDropChances").result().isEmpty()) {
                p_397744_ = p_397744_.set("HandDropChances", p_397744_.createList(Stream.of(Float.valueOf(f), Float.valueOf(0.0f)).map(arg_0 -> ((Dynamic)p_397744_).createFloat(arg_0))));
            }
            if (p_397744_.get("ArmorDropChances").result().isEmpty()) {
                p_397744_ = p_397744_.set("ArmorDropChances", p_397744_.createList(Stream.of((Float)iterator.next(), (Float)iterator.next(), (Float)iterator.next(), (Float)iterator.next()).map(arg_0 -> ((Dynamic)p_397744_).createFloat(arg_0))));
            }
        }
        return p_397744_;
    }
}

