/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.CrudeIncrementalIntIdentityHashBiMap;
import net.minecraft.util.datafix.ExtraDataFixUtils;
import net.minecraft.util.datafix.PackedBitStorage;
import net.minecraft.util.datafix.fixes.BlockStateData;
import net.minecraft.util.datafix.fixes.References;
import org.slf4j.Logger;

public class ChunkPalettedStorageFix
extends DataFix {
    private static final int NORTH_WEST_MASK = 128;
    private static final int WEST_MASK = 64;
    private static final int SOUTH_WEST_MASK = 32;
    private static final int SOUTH_MASK = 16;
    private static final int SOUTH_EAST_MASK = 8;
    private static final int EAST_MASK = 4;
    private static final int NORTH_EAST_MASK = 2;
    private static final int NORTH_MASK = 1;
    static final Logger LOGGER = LogUtils.getLogger();
    private static final int SIZE = 4096;

    public ChunkPalettedStorageFix(Schema p_15058_, boolean p_15059_) {
        super(p_15058_, p_15059_);
    }

    public static String getName(Dynamic<?> p_15065_) {
        return p_15065_.get("Name").asString("");
    }

    public static String getProperty(Dynamic<?> p_15067_, String p_15068_) {
        return p_15067_.get("Properties").get(p_15068_).asString("");
    }

    public static int idFor(CrudeIncrementalIntIdentityHashBiMap<Dynamic<?>> p_15062_, Dynamic<?> p_15063_) {
        int i = p_15062_.getId(p_15063_);
        if (i == -1) {
            i = p_15062_.add(p_15063_);
        }
        return i;
    }

    private Dynamic<?> fix(Dynamic<?> p_15093_) {
        Optional optional = p_15093_.get("Level").result();
        return optional.isPresent() && ((Dynamic)optional.get()).get("Sections").asStreamOpt().result().isPresent() ? p_15093_.set("Level", new UpgradeChunk((Dynamic)optional.get()).write()) : p_15093_;
    }

    public TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(References.CHUNK);
        Type type1 = this.getOutputSchema().getType(References.CHUNK);
        return this.writeFixAndRead("ChunkPalettedStorageFix", type, type1, this::fix);
    }

    public static int getSideMask(boolean p_15087_, boolean p_15088_, boolean p_15089_, boolean p_15090_) {
        int i = 0;
        if (p_15089_) {
            i = p_15088_ ? (i |= 2) : (p_15087_ ? (i |= 0x80) : (i |= 1));
        } else if (p_15090_) {
            i = p_15087_ ? (i |= 0x20) : (p_15088_ ? (i |= 8) : (i |= 0x10));
        } else if (p_15088_) {
            i |= 4;
        } else if (p_15087_) {
            i |= 0x40;
        }
        return i;
    }

    static final class UpgradeChunk {
        private int sides;
        private final Section[] sections = new Section[16];
        private final Dynamic<?> level;
        private final int x;
        private final int z;
        private final Int2ObjectMap<Dynamic<?>> blockEntities = new Int2ObjectLinkedOpenHashMap(16);

        public UpgradeChunk(Dynamic<?> p_15222_) {
            this.level = p_15222_;
            this.x = p_15222_.get("xPos").asInt(0) << 4;
            this.z = p_15222_.get("zPos").asInt(0) << 4;
            p_15222_.get("TileEntities").asStreamOpt().ifSuccess(p_15241_ -> p_15241_.forEach(p_145228_ -> {
                int j4;
                int l3 = p_145228_.get("x").asInt(0) - this.x & 0xF;
                int i4 = p_145228_.get("y").asInt(0);
                int k4 = i4 << 8 | (j4 = p_145228_.get("z").asInt(0) - this.z & 0xF) << 4 | l3;
                if (this.blockEntities.put(k4, p_145228_) != null) {
                    LOGGER.warn("In chunk: {}x{} found a duplicate block entity at position: [{}, {}, {}]", new Object[]{this.x, this.z, l3, i4, j4});
                }
            }));
            boolean flag = p_15222_.get("convertedFromAlphaFormat").asBoolean(false);
            p_15222_.get("Sections").asStreamOpt().ifSuccess(p_15235_ -> p_15235_.forEach(p_145226_ -> {
                Section chunkpalettedstoragefix$section1 = new Section((Dynamic<?>)p_145226_);
                this.sides = chunkpalettedstoragefix$section1.upgrade(this.sides);
                this.sections[chunkpalettedstoragefix$section1.y] = chunkpalettedstoragefix$section1;
            }));
            for (Section chunkpalettedstoragefix$section : this.sections) {
                if (chunkpalettedstoragefix$section == null) continue;
                block30: for (Int2ObjectMap.Entry entry : chunkpalettedstoragefix$section.toFix.int2ObjectEntrySet()) {
                    int i = chunkpalettedstoragefix$section.y << 12;
                    switch (entry.getIntKey()) {
                        case 2: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                String s11;
                                int i3 = (Integer)intListIterator.next();
                                Dynamic<?> dynamic11 = this.getBlock(i3 |= i);
                                if (!"minecraft:grass_block".equals(ChunkPalettedStorageFix.getName(dynamic11)) || !"minecraft:snow".equals(s11 = ChunkPalettedStorageFix.getName(this.getBlock(UpgradeChunk.relative(i3, Direction.UP)))) && !"minecraft:snow_layer".equals(s11)) continue;
                                this.setBlock(i3, MappingConstants.SNOWY_GRASS);
                            }
                            continue block30;
                        }
                        case 3: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                String s10;
                                int l2 = (Integer)intListIterator.next();
                                Dynamic<?> dynamic10 = this.getBlock(l2 |= i);
                                if (!"minecraft:podzol".equals(ChunkPalettedStorageFix.getName(dynamic10)) || !"minecraft:snow".equals(s10 = ChunkPalettedStorageFix.getName(this.getBlock(UpgradeChunk.relative(l2, Direction.UP)))) && !"minecraft:snow_layer".equals(s10)) continue;
                                this.setBlock(l2, MappingConstants.SNOWY_PODZOL);
                            }
                            continue block30;
                        }
                        case 25: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                int k2 = (Integer)intListIterator.next();
                                Dynamic<?> dynamic9 = this.removeBlockEntity(k2 |= i);
                                if (dynamic9 == null) continue;
                                String s9 = Boolean.toString(dynamic9.get("powered").asBoolean(false)) + (byte)Math.min(Math.max(dynamic9.get("note").asInt(0), 0), 24);
                                this.setBlock(k2, MappingConstants.NOTE_BLOCK_MAP.getOrDefault(s9, MappingConstants.NOTE_BLOCK_MAP.get("false0")));
                            }
                            continue block30;
                        }
                        case 26: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                String s15;
                                int k3;
                                int j2 = (Integer)intListIterator.next();
                                Dynamic<?> dynamic8 = this.getBlockEntity(j2 |= i);
                                Dynamic<?> dynamic14 = this.getBlock(j2);
                                if (dynamic8 == null || (k3 = dynamic8.get("color").asInt(0)) == 14 || k3 < 0 || k3 >= 16 || !MappingConstants.BED_BLOCK_MAP.containsKey(s15 = ChunkPalettedStorageFix.getProperty(dynamic14, "facing") + ChunkPalettedStorageFix.getProperty(dynamic14, "occupied") + ChunkPalettedStorageFix.getProperty(dynamic14, "part") + k3)) continue;
                                this.setBlock(j2, MappingConstants.BED_BLOCK_MAP.get(s15));
                            }
                            continue block30;
                        }
                        case 64: 
                        case 71: 
                        case 193: 
                        case 194: 
                        case 195: 
                        case 196: 
                        case 197: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                Dynamic<?> dynamic13;
                                int i2 = (Integer)intListIterator.next();
                                Dynamic<?> dynamic7 = this.getBlock(i2 |= i);
                                if (!ChunkPalettedStorageFix.getName(dynamic7).endsWith("_door") || !"lower".equals(ChunkPalettedStorageFix.getProperty(dynamic13 = this.getBlock(i2), "half"))) continue;
                                int j3 = UpgradeChunk.relative(i2, Direction.UP);
                                Dynamic<?> dynamic15 = this.getBlock(j3);
                                String s16 = ChunkPalettedStorageFix.getName(dynamic13);
                                if (!s16.equals(ChunkPalettedStorageFix.getName(dynamic15))) continue;
                                String s1 = ChunkPalettedStorageFix.getProperty(dynamic13, "facing");
                                String s2 = ChunkPalettedStorageFix.getProperty(dynamic13, "open");
                                String s3 = flag ? "left" : ChunkPalettedStorageFix.getProperty(dynamic15, "hinge");
                                String s4 = flag ? "false" : ChunkPalettedStorageFix.getProperty(dynamic15, "powered");
                                this.setBlock(i2, MappingConstants.DOOR_MAP.get(s16 + s1 + "lower" + s3 + s2 + s4));
                                this.setBlock(j3, MappingConstants.DOOR_MAP.get(s16 + s1 + "upper" + s3 + s2 + s4));
                            }
                            continue block30;
                        }
                        case 86: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                String s8;
                                int l1 = (Integer)intListIterator.next();
                                Dynamic<?> dynamic6 = this.getBlock(l1 |= i);
                                if (!"minecraft:carved_pumpkin".equals(ChunkPalettedStorageFix.getName(dynamic6)) || !"minecraft:grass_block".equals(s8 = ChunkPalettedStorageFix.getName(this.getBlock(UpgradeChunk.relative(l1, Direction.DOWN)))) && !"minecraft:dirt".equals(s8)) continue;
                                this.setBlock(l1, MappingConstants.PUMPKIN);
                            }
                            continue block30;
                        }
                        case 110: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                String s7;
                                int k1 = (Integer)intListIterator.next();
                                Dynamic<?> dynamic5 = this.getBlock(k1 |= i);
                                if (!"minecraft:mycelium".equals(ChunkPalettedStorageFix.getName(dynamic5)) || !"minecraft:snow".equals(s7 = ChunkPalettedStorageFix.getName(this.getBlock(UpgradeChunk.relative(k1, Direction.UP)))) && !"minecraft:snow_layer".equals(s7)) continue;
                                this.setBlock(k1, MappingConstants.SNOWY_MYCELIUM);
                            }
                            continue block30;
                        }
                        case 140: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                int j1 = (Integer)intListIterator.next();
                                Dynamic<?> dynamic4 = this.removeBlockEntity(j1 |= i);
                                if (dynamic4 == null) continue;
                                String s6 = dynamic4.get("Item").asString("") + dynamic4.get("Data").asInt(0);
                                this.setBlock(j1, MappingConstants.FLOWER_POT_MAP.getOrDefault(s6, MappingConstants.FLOWER_POT_MAP.get("minecraft:air0")));
                            }
                            continue block30;
                        }
                        case 144: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                int i1 = (Integer)intListIterator.next();
                                Dynamic<?> dynamic3 = this.getBlockEntity(i1 |= i);
                                if (dynamic3 == null) continue;
                                String s5 = String.valueOf(dynamic3.get("SkullType").asInt(0));
                                String s13 = ChunkPalettedStorageFix.getProperty(this.getBlock(i1), "facing");
                                Object s14 = !"up".equals(s13) && !"down".equals(s13) ? s5 + s13 : s5 + dynamic3.get("Rot").asInt(0);
                                dynamic3.remove("SkullType");
                                dynamic3.remove("facing");
                                dynamic3.remove("Rot");
                                this.setBlock(i1, MappingConstants.SKULL_MAP.getOrDefault(s14, MappingConstants.SKULL_MAP.get("0north")));
                            }
                            continue block30;
                        }
                        case 175: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                int l = (Integer)intListIterator.next();
                                Dynamic<?> dynamic2 = this.getBlock(l |= i);
                                if (!"upper".equals(ChunkPalettedStorageFix.getProperty(dynamic2, "half"))) continue;
                                Dynamic<?> dynamic12 = this.getBlock(UpgradeChunk.relative(l, Direction.DOWN));
                                String s12 = ChunkPalettedStorageFix.getName(dynamic12);
                                switch (s12) {
                                    case "minecraft:sunflower": {
                                        this.setBlock(l, MappingConstants.UPPER_SUNFLOWER);
                                        break;
                                    }
                                    case "minecraft:lilac": {
                                        this.setBlock(l, MappingConstants.UPPER_LILAC);
                                        break;
                                    }
                                    case "minecraft:tall_grass": {
                                        this.setBlock(l, MappingConstants.UPPER_TALL_GRASS);
                                        break;
                                    }
                                    case "minecraft:large_fern": {
                                        this.setBlock(l, MappingConstants.UPPER_LARGE_FERN);
                                        break;
                                    }
                                    case "minecraft:rose_bush": {
                                        this.setBlock(l, MappingConstants.UPPER_ROSE_BUSH);
                                        break;
                                    }
                                    case "minecraft:peony": {
                                        this.setBlock(l, MappingConstants.UPPER_PEONY);
                                    }
                                }
                            }
                            continue block30;
                        }
                        case 176: 
                        case 177: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                String s;
                                int k;
                                int j = (Integer)intListIterator.next();
                                Dynamic<?> dynamic = this.getBlockEntity(j |= i);
                                Dynamic<?> dynamic1 = this.getBlock(j);
                                if (dynamic == null || (k = dynamic.get("Base").asInt(0)) == 15 || k < 0 || k >= 16 || !MappingConstants.BANNER_BLOCK_MAP.containsKey(s = ChunkPalettedStorageFix.getProperty(dynamic1, entry.getIntKey() == 176 ? "rotation" : "facing") + "_" + k)) continue;
                                this.setBlock(j, MappingConstants.BANNER_BLOCK_MAP.get(s));
                            }
                            break;
                        }
                    }
                }
            }
        }

        @Nullable
        private Dynamic<?> getBlockEntity(int p_15237_) {
            return (Dynamic)this.blockEntities.get(p_15237_);
        }

        @Nullable
        private Dynamic<?> removeBlockEntity(int p_15243_) {
            return (Dynamic)this.blockEntities.remove(p_15243_);
        }

        public static int relative(int p_15227_, Direction p_15228_) {
            return switch (p_15228_.getAxis().ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    int k = (p_15227_ & 0xF) + p_15228_.getAxisDirection().getStep();
                    if (k >= 0 && k <= 15) {
                        yield p_15227_ & 0xFFFFFFF0 | k;
                    }
                    yield -1;
                }
                case 1 -> {
                    int j = (p_15227_ >> 8) + p_15228_.getAxisDirection().getStep();
                    if (j >= 0 && j <= 255) {
                        yield p_15227_ & 0xFF | j << 8;
                    }
                    yield -1;
                }
                case 2 -> {
                    int i = (p_15227_ >> 4 & 0xF) + p_15228_.getAxisDirection().getStep();
                    if (i >= 0 && i <= 15) {
                        yield p_15227_ & 0xFFFFFF0F | i << 4;
                    }
                    yield -1;
                }
            };
        }

        private void setBlock(int p_15230_, Dynamic<?> p_15231_) {
            Section chunkpalettedstoragefix$section;
            if (p_15230_ >= 0 && p_15230_ <= 65535 && (chunkpalettedstoragefix$section = this.getSection(p_15230_)) != null) {
                chunkpalettedstoragefix$section.setBlock(p_15230_ & 0xFFF, p_15231_);
            }
        }

        @Nullable
        private Section getSection(int p_15245_) {
            int i = p_15245_ >> 12;
            return i < this.sections.length ? this.sections[i] : null;
        }

        public Dynamic<?> getBlock(int p_15225_) {
            if (p_15225_ >= 0 && p_15225_ <= 65535) {
                Section chunkpalettedstoragefix$section = this.getSection(p_15225_);
                return chunkpalettedstoragefix$section == null ? MappingConstants.AIR : chunkpalettedstoragefix$section.getBlock(p_15225_ & 0xFFF);
            }
            return MappingConstants.AIR;
        }

        public Dynamic<?> write() {
            Dynamic dynamic = this.level;
            dynamic = this.blockEntities.isEmpty() ? dynamic.remove("TileEntities") : dynamic.set("TileEntities", dynamic.createList(this.blockEntities.values().stream()));
            Dynamic dynamic1 = dynamic.emptyMap();
            ArrayList list = Lists.newArrayList();
            for (Section chunkpalettedstoragefix$section : this.sections) {
                if (chunkpalettedstoragefix$section == null) continue;
                list.add(chunkpalettedstoragefix$section.write());
                dynamic1 = dynamic1.set(String.valueOf(chunkpalettedstoragefix$section.y), dynamic1.createIntList(Arrays.stream(chunkpalettedstoragefix$section.update.toIntArray())));
            }
            Dynamic dynamic2 = dynamic.emptyMap();
            dynamic2 = dynamic2.set("Sides", dynamic2.createByte((byte)this.sides));
            dynamic2 = dynamic2.set("Indices", dynamic1);
            return dynamic.set("UpgradeData", dynamic2).set("Sections", dynamic2.createList(list.stream()));
        }
    }

    static class Section {
        private final CrudeIncrementalIntIdentityHashBiMap<Dynamic<?>> palette = CrudeIncrementalIntIdentityHashBiMap.create(32);
        private final List<Dynamic<?>> listTag;
        private final Dynamic<?> section;
        private final boolean hasData;
        final Int2ObjectMap<IntList> toFix = new Int2ObjectLinkedOpenHashMap();
        final IntList update = new IntArrayList();
        public final int y;
        private final Set<Dynamic<?>> seen = Sets.newIdentityHashSet();
        private final int[] buffer = new int[4096];

        public Section(Dynamic<?> p_15195_) {
            this.listTag = Lists.newArrayList();
            this.section = p_15195_;
            this.y = p_15195_.get("Y").asInt(0);
            this.hasData = p_15195_.get("Blocks").result().isPresent();
        }

        public Dynamic<?> getBlock(int p_15198_) {
            if (p_15198_ >= 0 && p_15198_ <= 4095) {
                Dynamic<?> dynamic = this.palette.byId(this.buffer[p_15198_]);
                return dynamic == null ? MappingConstants.AIR : dynamic;
            }
            return MappingConstants.AIR;
        }

        public void setBlock(int p_15203_, Dynamic<?> p_15204_) {
            if (this.seen.add(p_15204_)) {
                this.listTag.add("%%FILTER_ME%%".equals(ChunkPalettedStorageFix.getName(p_15204_)) ? MappingConstants.AIR : p_15204_);
            }
            this.buffer[p_15203_] = ChunkPalettedStorageFix.idFor(this.palette, p_15204_);
        }

        public int upgrade(int p_15210_) {
            if (!this.hasData) {
                return p_15210_;
            }
            ByteBuffer bytebuffer = (ByteBuffer)this.section.get("Blocks").asByteBufferOpt().result().get();
            DataLayer chunkpalettedstoragefix$datalayer = this.section.get("Data").asByteBufferOpt().map(p_15214_ -> new DataLayer(DataFixUtils.toArray((ByteBuffer)p_15214_))).result().orElseGet(DataLayer::new);
            DataLayer chunkpalettedstoragefix$datalayer1 = this.section.get("Add").asByteBufferOpt().map(p_15208_ -> new DataLayer(DataFixUtils.toArray((ByteBuffer)p_15208_))).result().orElseGet(DataLayer::new);
            this.seen.add(MappingConstants.AIR);
            ChunkPalettedStorageFix.idFor(this.palette, MappingConstants.AIR);
            this.listTag.add(MappingConstants.AIR);
            for (int i = 0; i < 4096; ++i) {
                int j = i & 0xF;
                int k = i >> 8 & 0xF;
                int l = i >> 4 & 0xF;
                int i1 = chunkpalettedstoragefix$datalayer1.get(j, k, l) << 12 | (bytebuffer.get(i) & 0xFF) << 4 | chunkpalettedstoragefix$datalayer.get(j, k, l);
                if (MappingConstants.FIX.get(i1 >> 4)) {
                    this.addFix(i1 >> 4, i);
                }
                if (MappingConstants.VIRTUAL.get(i1 >> 4)) {
                    int j1 = ChunkPalettedStorageFix.getSideMask(j == 0, j == 15, l == 0, l == 15);
                    if (j1 == 0) {
                        this.update.add(i);
                    } else {
                        p_15210_ |= j1;
                    }
                }
                this.setBlock(i, BlockStateData.getTag(i1));
            }
            return p_15210_;
        }

        private void addFix(int p_15200_, int p_15201_) {
            IntList intlist = (IntList)this.toFix.get(p_15200_);
            if (intlist == null) {
                intlist = new IntArrayList();
                this.toFix.put(p_15200_, (Object)intlist);
            }
            intlist.add(p_15201_);
        }

        public Dynamic<?> write() {
            Dynamic dynamic = this.section;
            if (!this.hasData) {
                return dynamic;
            }
            dynamic = dynamic.set("Palette", dynamic.createList(this.listTag.stream()));
            int i = Math.max(4, DataFixUtils.ceillog2((int)this.seen.size()));
            PackedBitStorage packedbitstorage = new PackedBitStorage(i, 4096);
            for (int j = 0; j < this.buffer.length; ++j) {
                packedbitstorage.set(j, this.buffer[j]);
            }
            dynamic = dynamic.set("BlockStates", dynamic.createLongList(Arrays.stream(packedbitstorage.getRaw())));
            dynamic = dynamic.remove("Blocks");
            dynamic = dynamic.remove("Data");
            return dynamic.remove("Add");
        }
    }

    static class MappingConstants {
        static final BitSet VIRTUAL = new BitSet(256);
        static final BitSet FIX = new BitSet(256);
        static final Dynamic<?> PUMPKIN = ExtraDataFixUtils.blockState("minecraft:pumpkin");
        static final Dynamic<?> SNOWY_PODZOL = ExtraDataFixUtils.blockState("minecraft:podzol", Map.of("snowy", "true"));
        static final Dynamic<?> SNOWY_GRASS = ExtraDataFixUtils.blockState("minecraft:grass_block", Map.of("snowy", "true"));
        static final Dynamic<?> SNOWY_MYCELIUM = ExtraDataFixUtils.blockState("minecraft:mycelium", Map.of("snowy", "true"));
        static final Dynamic<?> UPPER_SUNFLOWER = ExtraDataFixUtils.blockState("minecraft:sunflower", Map.of("half", "upper"));
        static final Dynamic<?> UPPER_LILAC = ExtraDataFixUtils.blockState("minecraft:lilac", Map.of("half", "upper"));
        static final Dynamic<?> UPPER_TALL_GRASS = ExtraDataFixUtils.blockState("minecraft:tall_grass", Map.of("half", "upper"));
        static final Dynamic<?> UPPER_LARGE_FERN = ExtraDataFixUtils.blockState("minecraft:large_fern", Map.of("half", "upper"));
        static final Dynamic<?> UPPER_ROSE_BUSH = ExtraDataFixUtils.blockState("minecraft:rose_bush", Map.of("half", "upper"));
        static final Dynamic<?> UPPER_PEONY = ExtraDataFixUtils.blockState("minecraft:peony", Map.of("half", "upper"));
        static final Map<String, Dynamic<?>> FLOWER_POT_MAP = (Map)DataFixUtils.make((Object)Maps.newHashMap(), p_363273_ -> {
            p_363273_.put("minecraft:air0", ExtraDataFixUtils.blockState("minecraft:flower_pot"));
            p_363273_.put("minecraft:red_flower0", ExtraDataFixUtils.blockState("minecraft:potted_poppy"));
            p_363273_.put("minecraft:red_flower1", ExtraDataFixUtils.blockState("minecraft:potted_blue_orchid"));
            p_363273_.put("minecraft:red_flower2", ExtraDataFixUtils.blockState("minecraft:potted_allium"));
            p_363273_.put("minecraft:red_flower3", ExtraDataFixUtils.blockState("minecraft:potted_azure_bluet"));
            p_363273_.put("minecraft:red_flower4", ExtraDataFixUtils.blockState("minecraft:potted_red_tulip"));
            p_363273_.put("minecraft:red_flower5", ExtraDataFixUtils.blockState("minecraft:potted_orange_tulip"));
            p_363273_.put("minecraft:red_flower6", ExtraDataFixUtils.blockState("minecraft:potted_white_tulip"));
            p_363273_.put("minecraft:red_flower7", ExtraDataFixUtils.blockState("minecraft:potted_pink_tulip"));
            p_363273_.put("minecraft:red_flower8", ExtraDataFixUtils.blockState("minecraft:potted_oxeye_daisy"));
            p_363273_.put("minecraft:yellow_flower0", ExtraDataFixUtils.blockState("minecraft:potted_dandelion"));
            p_363273_.put("minecraft:sapling0", ExtraDataFixUtils.blockState("minecraft:potted_oak_sapling"));
            p_363273_.put("minecraft:sapling1", ExtraDataFixUtils.blockState("minecraft:potted_spruce_sapling"));
            p_363273_.put("minecraft:sapling2", ExtraDataFixUtils.blockState("minecraft:potted_birch_sapling"));
            p_363273_.put("minecraft:sapling3", ExtraDataFixUtils.blockState("minecraft:potted_jungle_sapling"));
            p_363273_.put("minecraft:sapling4", ExtraDataFixUtils.blockState("minecraft:potted_acacia_sapling"));
            p_363273_.put("minecraft:sapling5", ExtraDataFixUtils.blockState("minecraft:potted_dark_oak_sapling"));
            p_363273_.put("minecraft:red_mushroom0", ExtraDataFixUtils.blockState("minecraft:potted_red_mushroom"));
            p_363273_.put("minecraft:brown_mushroom0", ExtraDataFixUtils.blockState("minecraft:potted_brown_mushroom"));
            p_363273_.put("minecraft:deadbush0", ExtraDataFixUtils.blockState("minecraft:potted_dead_bush"));
            p_363273_.put("minecraft:tallgrass2", ExtraDataFixUtils.blockState("minecraft:potted_fern"));
            p_363273_.put("minecraft:cactus0", ExtraDataFixUtils.blockState("minecraft:potted_cactus"));
        });
        static final Map<String, Dynamic<?>> SKULL_MAP = (Map)DataFixUtils.make((Object)Maps.newHashMap(), p_363674_ -> {
            MappingConstants.mapSkull(p_363674_, 0, "skeleton", "skull");
            MappingConstants.mapSkull(p_363674_, 1, "wither_skeleton", "skull");
            MappingConstants.mapSkull(p_363674_, 2, "zombie", "head");
            MappingConstants.mapSkull(p_363674_, 3, "player", "head");
            MappingConstants.mapSkull(p_363674_, 4, "creeper", "head");
            MappingConstants.mapSkull(p_363674_, 5, "dragon", "head");
        });
        static final Map<String, Dynamic<?>> DOOR_MAP = (Map)DataFixUtils.make((Object)Maps.newHashMap(), p_363442_ -> {
            MappingConstants.mapDoor(p_363442_, "oak_door");
            MappingConstants.mapDoor(p_363442_, "iron_door");
            MappingConstants.mapDoor(p_363442_, "spruce_door");
            MappingConstants.mapDoor(p_363442_, "birch_door");
            MappingConstants.mapDoor(p_363442_, "jungle_door");
            MappingConstants.mapDoor(p_363442_, "acacia_door");
            MappingConstants.mapDoor(p_363442_, "dark_oak_door");
        });
        static final Map<String, Dynamic<?>> NOTE_BLOCK_MAP = (Map)DataFixUtils.make((Object)Maps.newHashMap(), p_361924_ -> {
            for (int i = 0; i < 26; ++i) {
                p_361924_.put("true" + i, ExtraDataFixUtils.blockState("minecraft:note_block", Map.of("powered", "true", "note", String.valueOf(i))));
                p_361924_.put("false" + i, ExtraDataFixUtils.blockState("minecraft:note_block", Map.of("powered", "false", "note", String.valueOf(i))));
            }
        });
        private static final Int2ObjectMap<String> DYE_COLOR_MAP = (Int2ObjectMap)DataFixUtils.make((Object)new Int2ObjectOpenHashMap(), p_360500_ -> {
            p_360500_.put(0, (Object)"white");
            p_360500_.put(1, (Object)"orange");
            p_360500_.put(2, (Object)"magenta");
            p_360500_.put(3, (Object)"light_blue");
            p_360500_.put(4, (Object)"yellow");
            p_360500_.put(5, (Object)"lime");
            p_360500_.put(6, (Object)"pink");
            p_360500_.put(7, (Object)"gray");
            p_360500_.put(8, (Object)"light_gray");
            p_360500_.put(9, (Object)"cyan");
            p_360500_.put(10, (Object)"purple");
            p_360500_.put(11, (Object)"blue");
            p_360500_.put(12, (Object)"brown");
            p_360500_.put(13, (Object)"green");
            p_360500_.put(14, (Object)"red");
            p_360500_.put(15, (Object)"black");
        });
        static final Map<String, Dynamic<?>> BED_BLOCK_MAP = (Map)DataFixUtils.make((Object)Maps.newHashMap(), p_361617_ -> {
            for (Int2ObjectMap.Entry entry : DYE_COLOR_MAP.int2ObjectEntrySet()) {
                if (Objects.equals(entry.getValue(), "red")) continue;
                MappingConstants.addBeds(p_361617_, entry.getIntKey(), (String)entry.getValue());
            }
        });
        static final Map<String, Dynamic<?>> BANNER_BLOCK_MAP = (Map)DataFixUtils.make((Object)Maps.newHashMap(), p_364554_ -> {
            for (Int2ObjectMap.Entry entry : DYE_COLOR_MAP.int2ObjectEntrySet()) {
                if (Objects.equals(entry.getValue(), "white")) continue;
                MappingConstants.addBanners(p_364554_, 15 - entry.getIntKey(), (String)entry.getValue());
            }
        });
        static final Dynamic<?> AIR = ExtraDataFixUtils.blockState("minecraft:air");

        private MappingConstants() {
        }

        private static void mapSkull(Map<String, Dynamic<?>> p_365006_, int p_362507_, String p_362757_, String p_361302_) {
            p_365006_.put(p_362507_ + "north", ExtraDataFixUtils.blockState("minecraft:" + p_362757_ + "_wall_" + p_361302_, Map.of("facing", "north")));
            p_365006_.put(p_362507_ + "east", ExtraDataFixUtils.blockState("minecraft:" + p_362757_ + "_wall_" + p_361302_, Map.of("facing", "east")));
            p_365006_.put(p_362507_ + "south", ExtraDataFixUtils.blockState("minecraft:" + p_362757_ + "_wall_" + p_361302_, Map.of("facing", "south")));
            p_365006_.put(p_362507_ + "west", ExtraDataFixUtils.blockState("minecraft:" + p_362757_ + "_wall_" + p_361302_, Map.of("facing", "west")));
            for (int i = 0; i < 16; ++i) {
                p_365006_.put("" + p_362507_ + i, ExtraDataFixUtils.blockState("minecraft:" + p_362757_ + "_" + p_361302_, Map.of("rotation", String.valueOf(i))));
            }
        }

        private static void mapDoor(Map<String, Dynamic<?>> p_363047_, String p_362668_) {
            String s = "minecraft:" + p_362668_;
            p_363047_.put("minecraft:" + p_362668_ + "eastlowerleftfalsefalse", ExtraDataFixUtils.blockState(s, Map.of("facing", "east", "half", "lower", "hinge", "left", "open", "false", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "eastlowerleftfalsetrue", ExtraDataFixUtils.blockState(s, Map.of("facing", "east", "half", "lower", "hinge", "left", "open", "false", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "eastlowerlefttruefalse", ExtraDataFixUtils.blockState(s, Map.of("facing", "east", "half", "lower", "hinge", "left", "open", "true", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "eastlowerlefttruetrue", ExtraDataFixUtils.blockState(s, Map.of("facing", "east", "half", "lower", "hinge", "left", "open", "true", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "eastlowerrightfalsefalse", ExtraDataFixUtils.blockState(s, Map.of("facing", "east", "half", "lower", "hinge", "right", "open", "false", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "eastlowerrightfalsetrue", ExtraDataFixUtils.blockState(s, Map.of("facing", "east", "half", "lower", "hinge", "right", "open", "false", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "eastlowerrighttruefalse", ExtraDataFixUtils.blockState(s, Map.of("facing", "east", "half", "lower", "hinge", "right", "open", "true", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "eastlowerrighttruetrue", ExtraDataFixUtils.blockState(s, Map.of("facing", "east", "half", "lower", "hinge", "right", "open", "true", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "eastupperleftfalsefalse", ExtraDataFixUtils.blockState(s, Map.of("facing", "east", "half", "upper", "hinge", "left", "open", "false", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "eastupperleftfalsetrue", ExtraDataFixUtils.blockState(s, Map.of("facing", "east", "half", "upper", "hinge", "left", "open", "false", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "eastupperlefttruefalse", ExtraDataFixUtils.blockState(s, Map.of("facing", "east", "half", "upper", "hinge", "left", "open", "true", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "eastupperlefttruetrue", ExtraDataFixUtils.blockState(s, Map.of("facing", "east", "half", "upper", "hinge", "left", "open", "true", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "eastupperrightfalsefalse", ExtraDataFixUtils.blockState(s, Map.of("facing", "east", "half", "upper", "hinge", "right", "open", "false", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "eastupperrightfalsetrue", ExtraDataFixUtils.blockState(s, Map.of("facing", "east", "half", "upper", "hinge", "right", "open", "false", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "eastupperrighttruefalse", ExtraDataFixUtils.blockState(s, Map.of("facing", "east", "half", "upper", "hinge", "right", "open", "true", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "eastupperrighttruetrue", ExtraDataFixUtils.blockState(s, Map.of("facing", "east", "half", "upper", "hinge", "right", "open", "true", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "northlowerleftfalsefalse", ExtraDataFixUtils.blockState(s, Map.of("facing", "north", "half", "lower", "hinge", "left", "open", "false", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "northlowerleftfalsetrue", ExtraDataFixUtils.blockState(s, Map.of("facing", "north", "half", "lower", "hinge", "left", "open", "false", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "northlowerlefttruefalse", ExtraDataFixUtils.blockState(s, Map.of("facing", "north", "half", "lower", "hinge", "left", "open", "true", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "northlowerlefttruetrue", ExtraDataFixUtils.blockState(s, Map.of("facing", "north", "half", "lower", "hinge", "left", "open", "true", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "northlowerrightfalsefalse", ExtraDataFixUtils.blockState(s, Map.of("facing", "north", "half", "lower", "hinge", "right", "open", "false", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "northlowerrightfalsetrue", ExtraDataFixUtils.blockState(s, Map.of("facing", "north", "half", "lower", "hinge", "right", "open", "false", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "northlowerrighttruefalse", ExtraDataFixUtils.blockState(s, Map.of("facing", "north", "half", "lower", "hinge", "right", "open", "true", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "northlowerrighttruetrue", ExtraDataFixUtils.blockState(s, Map.of("facing", "north", "half", "lower", "hinge", "right", "open", "true", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "northupperleftfalsefalse", ExtraDataFixUtils.blockState(s, Map.of("facing", "north", "half", "upper", "hinge", "left", "open", "false", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "northupperleftfalsetrue", ExtraDataFixUtils.blockState(s, Map.of("facing", "north", "half", "upper", "hinge", "left", "open", "false", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "northupperlefttruefalse", ExtraDataFixUtils.blockState(s, Map.of("facing", "north", "half", "upper", "hinge", "left", "open", "true", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "northupperlefttruetrue", ExtraDataFixUtils.blockState(s, Map.of("facing", "north", "half", "upper", "hinge", "left", "open", "true", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "northupperrightfalsefalse", ExtraDataFixUtils.blockState(s, Map.of("facing", "north", "half", "upper", "hinge", "right", "open", "false", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "northupperrightfalsetrue", ExtraDataFixUtils.blockState(s, Map.of("facing", "north", "half", "upper", "hinge", "right", "open", "false", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "northupperrighttruefalse", ExtraDataFixUtils.blockState(s, Map.of("facing", "north", "half", "upper", "hinge", "right", "open", "true", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "northupperrighttruetrue", ExtraDataFixUtils.blockState(s, Map.of("facing", "north", "half", "upper", "hinge", "right", "open", "true", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "southlowerleftfalsefalse", ExtraDataFixUtils.blockState(s, Map.of("facing", "south", "half", "lower", "hinge", "left", "open", "false", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "southlowerleftfalsetrue", ExtraDataFixUtils.blockState(s, Map.of("facing", "south", "half", "lower", "hinge", "left", "open", "false", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "southlowerlefttruefalse", ExtraDataFixUtils.blockState(s, Map.of("facing", "south", "half", "lower", "hinge", "left", "open", "true", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "southlowerlefttruetrue", ExtraDataFixUtils.blockState(s, Map.of("facing", "south", "half", "lower", "hinge", "left", "open", "true", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "southlowerrightfalsefalse", ExtraDataFixUtils.blockState(s, Map.of("facing", "south", "half", "lower", "hinge", "right", "open", "false", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "southlowerrightfalsetrue", ExtraDataFixUtils.blockState(s, Map.of("facing", "south", "half", "lower", "hinge", "right", "open", "false", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "southlowerrighttruefalse", ExtraDataFixUtils.blockState(s, Map.of("facing", "south", "half", "lower", "hinge", "right", "open", "true", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "southlowerrighttruetrue", ExtraDataFixUtils.blockState(s, Map.of("facing", "south", "half", "lower", "hinge", "right", "open", "true", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "southupperleftfalsefalse", ExtraDataFixUtils.blockState(s, Map.of("facing", "south", "half", "upper", "hinge", "left", "open", "false", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "southupperleftfalsetrue", ExtraDataFixUtils.blockState(s, Map.of("facing", "south", "half", "upper", "hinge", "left", "open", "false", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "southupperlefttruefalse", ExtraDataFixUtils.blockState(s, Map.of("facing", "south", "half", "upper", "hinge", "left", "open", "true", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "southupperlefttruetrue", ExtraDataFixUtils.blockState(s, Map.of("facing", "south", "half", "upper", "hinge", "left", "open", "true", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "southupperrightfalsefalse", ExtraDataFixUtils.blockState(s, Map.of("facing", "south", "half", "upper", "hinge", "right", "open", "false", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "southupperrightfalsetrue", ExtraDataFixUtils.blockState(s, Map.of("facing", "south", "half", "upper", "hinge", "right", "open", "false", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "southupperrighttruefalse", ExtraDataFixUtils.blockState(s, Map.of("facing", "south", "half", "upper", "hinge", "right", "open", "true", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "southupperrighttruetrue", ExtraDataFixUtils.blockState(s, Map.of("facing", "south", "half", "upper", "hinge", "right", "open", "true", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "westlowerleftfalsefalse", ExtraDataFixUtils.blockState(s, Map.of("facing", "west", "half", "lower", "hinge", "left", "open", "false", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "westlowerleftfalsetrue", ExtraDataFixUtils.blockState(s, Map.of("facing", "west", "half", "lower", "hinge", "left", "open", "false", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "westlowerlefttruefalse", ExtraDataFixUtils.blockState(s, Map.of("facing", "west", "half", "lower", "hinge", "left", "open", "true", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "westlowerlefttruetrue", ExtraDataFixUtils.blockState(s, Map.of("facing", "west", "half", "lower", "hinge", "left", "open", "true", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "westlowerrightfalsefalse", ExtraDataFixUtils.blockState(s, Map.of("facing", "west", "half", "lower", "hinge", "right", "open", "false", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "westlowerrightfalsetrue", ExtraDataFixUtils.blockState(s, Map.of("facing", "west", "half", "lower", "hinge", "right", "open", "false", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "westlowerrighttruefalse", ExtraDataFixUtils.blockState(s, Map.of("facing", "west", "half", "lower", "hinge", "right", "open", "true", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "westlowerrighttruetrue", ExtraDataFixUtils.blockState(s, Map.of("facing", "west", "half", "lower", "hinge", "right", "open", "true", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "westupperleftfalsefalse", ExtraDataFixUtils.blockState(s, Map.of("facing", "west", "half", "upper", "hinge", "left", "open", "false", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "westupperleftfalsetrue", ExtraDataFixUtils.blockState(s, Map.of("facing", "west", "half", "upper", "hinge", "left", "open", "false", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "westupperlefttruefalse", ExtraDataFixUtils.blockState(s, Map.of("facing", "west", "half", "upper", "hinge", "left", "open", "true", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "westupperlefttruetrue", ExtraDataFixUtils.blockState(s, Map.of("facing", "west", "half", "upper", "hinge", "left", "open", "true", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "westupperrightfalsefalse", ExtraDataFixUtils.blockState(s, Map.of("facing", "west", "half", "upper", "hinge", "right", "open", "false", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "westupperrightfalsetrue", ExtraDataFixUtils.blockState(s, Map.of("facing", "west", "half", "upper", "hinge", "right", "open", "false", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "westupperrighttruefalse", ExtraDataFixUtils.blockState(s, Map.of("facing", "west", "half", "upper", "hinge", "right", "open", "true", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "westupperrighttruetrue", ExtraDataFixUtils.blockState(s, Map.of("facing", "west", "half", "upper", "hinge", "right", "open", "true", "powered", "true")));
        }

        private static void addBeds(Map<String, Dynamic<?>> p_362926_, int p_362734_, String p_363528_) {
            p_362926_.put("southfalsefoot" + p_362734_, ExtraDataFixUtils.blockState("minecraft:" + p_363528_ + "_bed", Map.of("facing", "south", "occupied", "false", "part", "foot")));
            p_362926_.put("westfalsefoot" + p_362734_, ExtraDataFixUtils.blockState("minecraft:" + p_363528_ + "_bed", Map.of("facing", "west", "occupied", "false", "part", "foot")));
            p_362926_.put("northfalsefoot" + p_362734_, ExtraDataFixUtils.blockState("minecraft:" + p_363528_ + "_bed", Map.of("facing", "north", "occupied", "false", "part", "foot")));
            p_362926_.put("eastfalsefoot" + p_362734_, ExtraDataFixUtils.blockState("minecraft:" + p_363528_ + "_bed", Map.of("facing", "east", "occupied", "false", "part", "foot")));
            p_362926_.put("southfalsehead" + p_362734_, ExtraDataFixUtils.blockState("minecraft:" + p_363528_ + "_bed", Map.of("facing", "south", "occupied", "false", "part", "head")));
            p_362926_.put("westfalsehead" + p_362734_, ExtraDataFixUtils.blockState("minecraft:" + p_363528_ + "_bed", Map.of("facing", "west", "occupied", "false", "part", "head")));
            p_362926_.put("northfalsehead" + p_362734_, ExtraDataFixUtils.blockState("minecraft:" + p_363528_ + "_bed", Map.of("facing", "north", "occupied", "false", "part", "head")));
            p_362926_.put("eastfalsehead" + p_362734_, ExtraDataFixUtils.blockState("minecraft:" + p_363528_ + "_bed", Map.of("facing", "east", "occupied", "false", "part", "head")));
            p_362926_.put("southtruehead" + p_362734_, ExtraDataFixUtils.blockState("minecraft:" + p_363528_ + "_bed", Map.of("facing", "south", "occupied", "true", "part", "head")));
            p_362926_.put("westtruehead" + p_362734_, ExtraDataFixUtils.blockState("minecraft:" + p_363528_ + "_bed", Map.of("facing", "west", "occupied", "true", "part", "head")));
            p_362926_.put("northtruehead" + p_362734_, ExtraDataFixUtils.blockState("minecraft:" + p_363528_ + "_bed", Map.of("facing", "north", "occupied", "true", "part", "head")));
            p_362926_.put("easttruehead" + p_362734_, ExtraDataFixUtils.blockState("minecraft:" + p_363528_ + "_bed", Map.of("facing", "east", "occupied", "true", "part", "head")));
        }

        private static void addBanners(Map<String, Dynamic<?>> p_364918_, int p_361132_, String p_364042_) {
            for (int i = 0; i < 16; ++i) {
                p_364918_.put(i + "_" + p_361132_, ExtraDataFixUtils.blockState("minecraft:" + p_364042_ + "_banner", Map.of("rotation", String.valueOf(i))));
            }
            p_364918_.put("north_" + p_361132_, ExtraDataFixUtils.blockState("minecraft:" + p_364042_ + "_wall_banner", Map.of("facing", "north")));
            p_364918_.put("south_" + p_361132_, ExtraDataFixUtils.blockState("minecraft:" + p_364042_ + "_wall_banner", Map.of("facing", "south")));
            p_364918_.put("west_" + p_361132_, ExtraDataFixUtils.blockState("minecraft:" + p_364042_ + "_wall_banner", Map.of("facing", "west")));
            p_364918_.put("east_" + p_361132_, ExtraDataFixUtils.blockState("minecraft:" + p_364042_ + "_wall_banner", Map.of("facing", "east")));
        }

        static {
            FIX.set(2);
            FIX.set(3);
            FIX.set(110);
            FIX.set(140);
            FIX.set(144);
            FIX.set(25);
            FIX.set(86);
            FIX.set(26);
            FIX.set(176);
            FIX.set(177);
            FIX.set(175);
            FIX.set(64);
            FIX.set(71);
            FIX.set(193);
            FIX.set(194);
            FIX.set(195);
            FIX.set(196);
            FIX.set(197);
            VIRTUAL.set(54);
            VIRTUAL.set(146);
            VIRTUAL.set(25);
            VIRTUAL.set(26);
            VIRTUAL.set(51);
            VIRTUAL.set(53);
            VIRTUAL.set(67);
            VIRTUAL.set(108);
            VIRTUAL.set(109);
            VIRTUAL.set(114);
            VIRTUAL.set(128);
            VIRTUAL.set(134);
            VIRTUAL.set(135);
            VIRTUAL.set(136);
            VIRTUAL.set(156);
            VIRTUAL.set(163);
            VIRTUAL.set(164);
            VIRTUAL.set(180);
            VIRTUAL.set(203);
            VIRTUAL.set(55);
            VIRTUAL.set(85);
            VIRTUAL.set(113);
            VIRTUAL.set(188);
            VIRTUAL.set(189);
            VIRTUAL.set(190);
            VIRTUAL.set(191);
            VIRTUAL.set(192);
            VIRTUAL.set(93);
            VIRTUAL.set(94);
            VIRTUAL.set(101);
            VIRTUAL.set(102);
            VIRTUAL.set(160);
            VIRTUAL.set(106);
            VIRTUAL.set(107);
            VIRTUAL.set(183);
            VIRTUAL.set(184);
            VIRTUAL.set(185);
            VIRTUAL.set(186);
            VIRTUAL.set(187);
            VIRTUAL.set(132);
            VIRTUAL.set(139);
            VIRTUAL.set(199);
        }
    }

    public static enum Direction {
        DOWN(AxisDirection.NEGATIVE, Axis.Y),
        UP(AxisDirection.POSITIVE, Axis.Y),
        NORTH(AxisDirection.NEGATIVE, Axis.Z),
        SOUTH(AxisDirection.POSITIVE, Axis.Z),
        WEST(AxisDirection.NEGATIVE, Axis.X),
        EAST(AxisDirection.POSITIVE, Axis.X);

        private final Axis axis;
        private final AxisDirection axisDirection;

        private Direction(AxisDirection p_15154_, Axis p_15155_) {
            this.axis = p_15155_;
            this.axisDirection = p_15154_;
        }

        public AxisDirection getAxisDirection() {
            return this.axisDirection;
        }

        public Axis getAxis() {
            return this.axis;
        }

        public static enum Axis {
            X,
            Y,
            Z;

        }

        public static enum AxisDirection {
            POSITIVE(1),
            NEGATIVE(-1);

            private final int step;

            private AxisDirection(int p_15180_) {
                this.step = p_15180_;
            }

            public int getStep() {
                return this.step;
            }
        }
    }

    static class DataLayer {
        private static final int SIZE = 2048;
        private static final int NIBBLE_SIZE = 4;
        private final byte[] data;

        public DataLayer() {
            this.data = new byte[2048];
        }

        public DataLayer(byte[] p_15132_) {
            this.data = p_15132_;
            if (p_15132_.length != 2048) {
                throw new IllegalArgumentException("ChunkNibbleArrays should be 2048 bytes not: " + p_15132_.length);
            }
        }

        public int get(int p_15136_, int p_15137_, int p_15138_) {
            int i = this.getPosition(p_15137_ << 8 | p_15138_ << 4 | p_15136_);
            return this.isFirst(p_15137_ << 8 | p_15138_ << 4 | p_15136_) ? this.data[i] & 0xF : this.data[i] >> 4 & 0xF;
        }

        private boolean isFirst(int p_15134_) {
            return (p_15134_ & 1) == 0;
        }

        private int getPosition(int p_15140_) {
            return p_15140_ >> 1;
        }
    }
}

