/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.List;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Function;
import java.util.stream.IntStream;
import net.minecraft.util.datafix.fixes.References;

public class ChunkBedBlockEntityInjecterFix
extends DataFix {
    public ChunkBedBlockEntityInjecterFix(Schema p_184825_, boolean p_184826_) {
        super(p_184825_, p_184826_);
    }

    public TypeRewriteRule makeRule() {
        Type type = this.getOutputSchema().getType(References.CHUNK);
        Type type1 = type.findFieldType("Level");
        Type type2 = type1.findFieldType("TileEntities");
        if (!(type2 instanceof List.ListType)) {
            throw new IllegalStateException("Tile entity type is not a list type.");
        }
        List.ListType listtype = (List.ListType)type2;
        return this.cap(type1, listtype);
    }

    private <TE> TypeRewriteRule cap(Type<?> p_184834_, List.ListType<TE> p_184835_) {
        Type type = p_184835_.getElement();
        OpticFinder opticfinder = DSL.fieldFinder((String)"Level", p_184834_);
        OpticFinder opticfinder1 = DSL.fieldFinder((String)"TileEntities", p_184835_);
        int i = 416;
        return TypeRewriteRule.seq((TypeRewriteRule)this.fixTypeEverywhere("InjectBedBlockEntityType", (Type)this.getInputSchema().findChoiceType(References.BLOCK_ENTITY), (Type)this.getOutputSchema().findChoiceType(References.BLOCK_ENTITY), p_184841_ -> p_184837_ -> p_184837_), (TypeRewriteRule)this.fixTypeEverywhereTyped("BedBlockEntityInjecter", this.getOutputSchema().getType(References.CHUNK), p_297967_ -> {
            Typed typed = p_297967_.getTyped(opticfinder);
            Dynamic dynamic = (Dynamic)typed.get(DSL.remainderFinder());
            int j = dynamic.get("xPos").asInt(0);
            int k = dynamic.get("zPos").asInt(0);
            ArrayList list = Lists.newArrayList((Iterable)((Iterable)typed.getOrCreate(opticfinder1)));
            for (Dynamic dynamic1 : dynamic.get("Sections").asList(Function.identity())) {
                int l = dynamic1.get("Y").asInt(0);
                Streams.mapWithIndex((IntStream)dynamic1.get("Blocks").asIntStream(), (p_274917_, p_274918_) -> {
                    if (416 == (p_274917_ & 0xFF) << 4) {
                        int i1 = (int)p_274918_;
                        int j1 = i1 & 0xF;
                        int k1 = i1 >> 8 & 0xF;
                        int l1 = i1 >> 4 & 0xF;
                        HashMap map = Maps.newHashMap();
                        map.put(dynamic1.createString("id"), dynamic1.createString("minecraft:bed"));
                        map.put(dynamic1.createString("x"), dynamic1.createInt(j1 + (j << 4)));
                        map.put(dynamic1.createString("y"), dynamic1.createInt(k1 + (l << 4)));
                        map.put(dynamic1.createString("z"), dynamic1.createInt(l1 + (k << 4)));
                        map.put(dynamic1.createString("color"), dynamic1.createShort((short)14));
                        return map;
                    }
                    return null;
                }).forEachOrdered(p_337607_ -> {
                    if (p_337607_ != null) {
                        list.add(((Pair)type.read(dynamic1.createMap(p_337607_)).result().orElseThrow(() -> new IllegalStateException("Could not parse newly created bed block entity."))).getFirst());
                    }
                });
            }
            return !list.isEmpty() ? p_297967_.set(opticfinder, typed.set(opticfinder1, (Object)list)) : p_297967_;
        }));
    }
}

