/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.Optional;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.util.datafix.ExtraDataFixUtils;
import net.minecraft.util.datafix.LegacyComponentDataFixUtils;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.util.datafix.schemas.NamespacedSchema;

public class BlockEntityCustomNameToComponentFix
extends DataFix {
    private static final Set<String> NAMEABLE_BLOCK_ENTITIES = Set.of("minecraft:beacon", "minecraft:banner", "minecraft:brewing_stand", "minecraft:chest", "minecraft:trapped_chest", "minecraft:dispenser", "minecraft:dropper", "minecraft:enchanting_table", "minecraft:furnace", "minecraft:hopper", "minecraft:shulker_box");

    public BlockEntityCustomNameToComponentFix(Schema p_14817_) {
        super(p_14817_, true);
    }

    public TypeRewriteRule makeRule() {
        OpticFinder opticfinder = DSL.fieldFinder((String)"id", NamespacedSchema.namespacedString());
        Type type = this.getInputSchema().getType(References.BLOCK_ENTITY);
        Type type1 = this.getOutputSchema().getType(References.BLOCK_ENTITY);
        Type<?> type2 = ExtraDataFixUtils.patchSubType(type, type, type1);
        return this.fixTypeEverywhereTyped("BlockEntityCustomNameToComponentFix", type, type1, p_392814_ -> {
            Optional optional = p_392814_.getOptional(opticfinder);
            return optional.isPresent() && !NAMEABLE_BLOCK_ENTITIES.contains(optional.get()) ? ExtraDataFixUtils.cast(type1, p_392814_) : Util.writeAndReadTypedOrThrow(ExtraDataFixUtils.cast(type2, p_392814_), type1, BlockEntityCustomNameToComponentFix::fixTagCustomName);
        });
    }

    public static <T> Dynamic<T> fixTagCustomName(Dynamic<T> p_394274_) {
        String s = p_394274_.get("CustomName").asString("");
        return s.isEmpty() ? p_394274_.remove("CustomName") : p_394274_.set("CustomName", LegacyComponentDataFixUtils.createPlainTextComponent(p_394274_.getOps(), s));
    }
}

