/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.LenientJsonParser;

public class LegacyComponentDataFixUtils {
    private static final String EMPTY_CONTENTS = LegacyComponentDataFixUtils.createTextComponentJson("");

    public static <T> Dynamic<T> createPlainTextComponent(DynamicOps<T> p_394303_, String p_393613_) {
        String s = LegacyComponentDataFixUtils.createTextComponentJson(p_393613_);
        return new Dynamic(p_394303_, p_394303_.createString(s));
    }

    public static <T> Dynamic<T> createEmptyComponent(DynamicOps<T> p_393609_) {
        return new Dynamic(p_393609_, p_393609_.createString(EMPTY_CONTENTS));
    }

    public static String createTextComponentJson(String p_394314_) {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("text", p_394314_);
        return GsonHelper.toStableString((JsonElement)jsonobject);
    }

    public static String createTranslatableComponentJson(String p_393777_) {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("translate", p_393777_);
        return GsonHelper.toStableString((JsonElement)jsonobject);
    }

    public static <T> Dynamic<T> createTranslatableComponent(DynamicOps<T> p_393546_, String p_394262_) {
        String s = LegacyComponentDataFixUtils.createTranslatableComponentJson(p_394262_);
        return new Dynamic(p_393546_, p_393546_.createString(s));
    }

    public static String rewriteFromLenient(String p_393742_) {
        if (!p_393742_.isEmpty() && !p_393742_.equals("null")) {
            char c0 = p_393742_.charAt(0);
            char c1 = p_393742_.charAt(p_393742_.length() - 1);
            if (c0 == '\"' && c1 == '\"' || c0 == '{' && c1 == '}' || c0 == '[' && c1 == ']') {
                try {
                    JsonElement jsonelement = LenientJsonParser.parse(p_393742_);
                    if (jsonelement.isJsonPrimitive()) {
                        return LegacyComponentDataFixUtils.createTextComponentJson(jsonelement.getAsString());
                    }
                    return GsonHelper.toStableString(jsonelement);
                }
                catch (JsonParseException jsonParseException) {
                    // empty catch block
                }
            }
            return LegacyComponentDataFixUtils.createTextComponentJson(p_393742_);
        }
        return EMPTY_CONTENTS;
    }

    public static Optional<String> extractTranslationString(String p_393970_) {
        try {
            JsonObject jsonobject;
            JsonElement jsonelement1;
            JsonElement jsonelement = LenientJsonParser.parse(p_393970_);
            if (jsonelement.isJsonObject() && (jsonelement1 = (jsonobject = jsonelement.getAsJsonObject()).get("translate")) != null && jsonelement1.isJsonPrimitive()) {
                return Optional.of(jsonelement1.getAsString());
            }
        }
        catch (JsonParseException jsonParseException) {
            // empty catch block
        }
        return Optional.empty();
    }
}

