/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.Strictness;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.MalformedJsonException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public class StrictJsonParser {
    public static JsonElement parse(Reader p_421780_) throws JsonIOException, JsonSyntaxException {
        try {
            JsonReader jsonreader = new JsonReader(p_421780_);
            jsonreader.setStrictness(Strictness.STRICT);
            JsonElement jsonelement = JsonParser.parseReader((JsonReader)jsonreader);
            if (!jsonelement.isJsonNull() && jsonreader.peek() != JsonToken.END_DOCUMENT) {
                throw new JsonSyntaxException("Did not consume the entire document.");
            }
            return jsonelement;
        }
        catch (MalformedJsonException | NumberFormatException malformedjsonexception) {
            throw new JsonSyntaxException(malformedjsonexception);
        }
        catch (IOException ioexception) {
            throw new JsonIOException((Throwable)ioexception);
        }
    }

    public static JsonElement parse(String p_421563_) throws JsonSyntaxException {
        return StrictJsonParser.parse(new StringReader(p_421563_));
    }
}

